/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;

@ScalarFunction(value="element_at")
@Description(value="Get element of array at given index")
public final class ArrayElementAtFunction {
    private ArrayElementAtFunction() {
    }

    @TypeParameter(value="E")
    @SqlNullable
    @SqlType(value="E")
    public static Long longElementAt(@TypeParameter(value="E") Type elementType, @SqlType(value="array(E)") Block array, @SqlType(value="bigint") long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (position == -1) {
            return null;
        }
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getLong(array, position);
    }

    @TypeParameter(value="E")
    @SqlNullable
    @SqlType(value="E")
    public static Boolean booleanElementAt(@TypeParameter(value="E") Type elementType, @SqlType(value="array(E)") Block array, @SqlType(value="bigint") long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (position == -1) {
            return null;
        }
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getBoolean(array, position);
    }

    @TypeParameter(value="E")
    @SqlNullable
    @SqlType(value="E")
    public static Double doubleElementAt(@TypeParameter(value="E") Type elementType, @SqlType(value="array(E)") Block array, @SqlType(value="bigint") long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (position == -1) {
            return null;
        }
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getDouble(array, position);
    }

    @TypeParameter(value="E")
    @SqlNullable
    @SqlType(value="E")
    public static Object sliceElementAt(@TypeParameter(value="E") Type elementType, @SqlType(value="array(E)") Block array, @SqlType(value="bigint") long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (position == -1) {
            return null;
        }
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getObject(array, position);
    }

    private static int checkedIndexToBlockPosition(Block block, long index) {
        int arrayLength = block.getPositionCount();
        if (index == 0L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "SQL array indices start at 1");
        }
        if (Math.abs(index) > (long)arrayLength) {
            return -1;
        }
        if (index > 0L) {
            return Math.toIntExact(index - 1L);
        }
        return Math.toIntExact((long)arrayLength + index);
    }
}

