/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.stats.TDigest;
import io.trino.operator.aggregation.state.TDigestAndPercentileState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;

public class TDigestAndPercentileStateSerializer
implements AccumulatorStateSerializer<TDigestAndPercentileState> {
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(TDigestAndPercentileState state, BlockBuilder out) {
        if (state.getDigest() == null) {
            out.appendNull();
        } else {
            Slice serialized = state.getDigest().serialize();
            SliceOutput output = Slices.allocate((int)(12 + serialized.length())).getOutput();
            output.appendDouble(state.getPercentile());
            output.appendInt(serialized.length());
            output.appendBytes(serialized);
            VarbinaryType.VARBINARY.writeSlice(out, output.slice());
        }
    }

    public void deserialize(Block block, int index, TDigestAndPercentileState state) {
        BasicSliceInput input = VarbinaryType.VARBINARY.getSlice(block, index).getInput();
        state.setPercentile(input.readDouble());
        int length = input.readInt();
        TDigest digest = TDigest.deserialize((Slice)input.readSlice(length));
        state.setDigest(digest);
        state.addMemoryUsage(state.getDigest().estimatedInMemorySizeInBytes());
    }
}

