/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.Signature;
import io.trino.metadata.SignatureBinder;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.operator.ParametricFunctionHelpers;
import io.trino.operator.ParametricImplementationsGroup;
import io.trino.operator.aggregation.AggregationFunctionAdapter;
import io.trino.operator.aggregation.AggregationHeader;
import io.trino.operator.aggregation.AggregationImplementation;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.state.StateCompiler;
import io.trino.operator.annotations.ImplementationDependency;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.type.TypeSignature;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public class ParametricAggregation
extends SqlAggregationFunction {
    private final ParametricImplementationsGroup<AggregationImplementation> implementations;
    private final Class<? extends AccumulatorState> stateClass;

    public ParametricAggregation(Signature signature, AggregationHeader details, Class<? extends AccumulatorState> stateClass, ParametricImplementationsGroup<AggregationImplementation> implementations) {
        super(new FunctionMetadata(signature, details.getName(), implementations.getFunctionNullability(), details.isHidden(), true, details.getDescription().orElse(""), FunctionKind.AGGREGATE, details.isDeprecated()), new AggregationFunctionMetadata(details.isOrderSensitive(), (List<TypeSignature>)(details.isDecomposable() ? ImmutableList.of((Object)StateCompiler.getSerializedType(stateClass).getTypeSignature()) : ImmutableList.of())));
        this.stateClass = Objects.requireNonNull(stateClass, "stateClass is null");
        Preconditions.checkArgument((boolean)implementations.getFunctionNullability().isReturnNullable(), (Object)"currently aggregates are required to be nullable");
        this.implementations = Objects.requireNonNull(implementations, "implementations is null");
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder = FunctionDependencyDeclaration.builder();
        ParametricAggregation.declareDependencies(builder, this.implementations.getExactImplementations().values());
        ParametricAggregation.declareDependencies(builder, this.implementations.getSpecializedImplementations());
        ParametricAggregation.declareDependencies(builder, this.implementations.getGenericImplementations());
        return builder.build();
    }

    private static void declareDependencies(FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder, Collection<AggregationImplementation> implementations) {
        for (AggregationImplementation implementation : implementations) {
            for (ImplementationDependency dependency : implementation.getInputDependencies()) {
                dependency.declareDependencies(builder);
            }
            for (ImplementationDependency dependency : implementation.getCombineDependencies()) {
                dependency.declareDependencies(builder);
            }
            for (ImplementationDependency dependency : implementation.getOutputDependencies()) {
                dependency.declareDependencies(builder);
            }
        }
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        AggregationImplementation concreteImplementation = this.findMatchingImplementation(boundSignature);
        AggregationMetadata.AccumulatorStateDescriptor<? extends AccumulatorState> accumulatorStateDescriptor = ParametricAggregation.generateAccumulatorStateDescriptor(this.stateClass);
        FunctionMetadata metadata = this.getFunctionMetadata();
        FunctionBinding functionBinding = SignatureBinder.bindFunction(metadata.getFunctionId(), metadata.getSignature(), boundSignature);
        MethodHandle inputHandle = ParametricFunctionHelpers.bindDependencies(concreteImplementation.getInputFunction(), concreteImplementation.getInputDependencies(), functionBinding, functionDependencies);
        Optional<MethodHandle> removeInputHandle = concreteImplementation.getRemoveInputFunction().map(removeInputFunction -> ParametricFunctionHelpers.bindDependencies(removeInputFunction, concreteImplementation.getRemoveInputDependencies(), functionBinding, functionDependencies));
        Optional<MethodHandle> combineHandle = concreteImplementation.getCombineFunction();
        if (this.getAggregationMetadata().isDecomposable()) {
            Preconditions.checkArgument((boolean)combineHandle.isPresent(), (String)"Decomposable method %s does not have a combine method", (Object)boundSignature.getName());
            combineHandle = combineHandle.map(combineFunction -> ParametricFunctionHelpers.bindDependencies(combineFunction, concreteImplementation.getCombineDependencies(), functionBinding, functionDependencies));
        } else {
            Preconditions.checkArgument((boolean)concreteImplementation.getCombineFunction().isEmpty(), (String)"Decomposable method %s does not have a combine method", (Object)boundSignature.getName());
        }
        MethodHandle outputHandle = ParametricFunctionHelpers.bindDependencies(concreteImplementation.getOutputFunction(), concreteImplementation.getOutputDependencies(), functionBinding, functionDependencies);
        List<AggregationFunctionAdapter.AggregationParameterKind> inputParameterKinds = concreteImplementation.getInputParameterKinds();
        inputHandle = AggregationFunctionAdapter.normalizeInputMethod(inputHandle, boundSignature, inputParameterKinds);
        removeInputHandle = removeInputHandle.map(function -> AggregationFunctionAdapter.normalizeInputMethod(function, boundSignature, inputParameterKinds));
        return new AggregationMetadata(inputHandle, removeInputHandle, combineHandle, outputHandle, (List<AggregationMetadata.AccumulatorStateDescriptor<?>>)ImmutableList.of(accumulatorStateDescriptor));
    }

    private static <T extends AccumulatorState> AggregationMetadata.AccumulatorStateDescriptor<T> generateAccumulatorStateDescriptor(Class<T> stateClass) {
        return new AggregationMetadata.AccumulatorStateDescriptor<T>(stateClass, StateCompiler.generateStateSerializer(stateClass), StateCompiler.generateStateFactory(stateClass));
    }

    public Class<?> getStateClass() {
        return this.stateClass;
    }

    @VisibleForTesting
    public ParametricImplementationsGroup<AggregationImplementation> getImplementations() {
        return this.implementations;
    }

    private AggregationImplementation findMatchingImplementation(BoundSignature boundSignature) {
        Signature signature = boundSignature.toSignature();
        Optional<Object> foundImplementation = Optional.empty();
        if (this.implementations.getExactImplementations().containsKey(signature)) {
            foundImplementation = Optional.of(this.implementations.getExactImplementations().get(signature));
        } else {
            for (AggregationImplementation candidate : this.implementations.getGenericImplementations()) {
                if (!candidate.areTypesAssignable(boundSignature)) continue;
                if (foundImplementation.isPresent()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_CALL, String.format("Ambiguous function call (%s) for %s", boundSignature, this.getFunctionMetadata().getSignature()));
                }
                foundImplementation = Optional.of(candidate);
            }
        }
        if (foundImplementation.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, String.format("Unsupported type parameters (%s) for %s", boundSignature, this.getFunctionMetadata().getSignature()));
        }
        return (AggregationImplementation)foundImplementation.get();
    }

    public String toString() {
        return new StringJoiner(", ", ParametricAggregation.class.getSimpleName() + "[", "]").add("signature=" + this.implementations.getSignature()).toString();
    }
}

