/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import java.util.Objects;
import java.util.Optional;

public abstract class RedirectionAwareTableHandle {
    private final Optional<TableHandle> tableHandle;

    protected RedirectionAwareTableHandle(Optional<TableHandle> tableHandle) {
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
    }

    public static RedirectionAwareTableHandle withRedirectionTo(QualifiedObjectName redirectedTableName, TableHandle tableHandle) {
        return new TableHandleWithRedirection(redirectedTableName, tableHandle);
    }

    public static RedirectionAwareTableHandle noRedirection(Optional<TableHandle> tableHandle) {
        return new TableHandleWithoutRedirection(tableHandle);
    }

    public Optional<TableHandle> getTableHandle() {
        return this.tableHandle;
    }

    public abstract Optional<QualifiedObjectName> getRedirectedTableName();

    private static class TableHandleWithRedirection
    extends RedirectionAwareTableHandle {
        private final QualifiedObjectName redirectedTableName;

        public TableHandleWithRedirection(QualifiedObjectName redirectedTableName, TableHandle tableHandle) {
            super(Optional.of(tableHandle));
            this.redirectedTableName = Objects.requireNonNull(redirectedTableName, "redirectedTableName is null");
        }

        @Override
        public Optional<QualifiedObjectName> getRedirectedTableName() {
            return Optional.of(this.redirectedTableName);
        }
    }

    private static class TableHandleWithoutRedirection
    extends RedirectionAwareTableHandle {
        protected TableHandleWithoutRedirection(Optional<TableHandle> tableHandle) {
            super(tableHandle);
        }

        @Override
        public Optional<QualifiedObjectName> getRedirectedTableName() {
            return Optional.empty();
        }
    }
}

