/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import io.trino.metadata.Signature;
import java.util.Locale;
import java.util.Objects;

public class FunctionId {
    private final String id;

    @JsonCreator
    public FunctionId(String id) {
        Objects.requireNonNull(id, "id is null");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"id must not be empty");
        Preconditions.checkArgument((boolean)id.toLowerCase(Locale.US).equals(id), (Object)"id must be lowercase");
        Preconditions.checkArgument((!id.contains("@") ? 1 : 0) != 0, (Object)"id must not contain '@'");
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionId that = (FunctionId)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @JsonValue
    public String toString() {
        return this.id;
    }

    public static FunctionId toFunctionId(Signature signature) {
        return new FunctionId(signature.toString().toLowerCase(Locale.US));
    }
}

