/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import io.trino.memory.LocalMemoryManager;
import io.trino.memory.LowMemoryKiller;
import io.trino.memory.MemoryInfo;
import io.trino.spi.QueryId;
import io.trino.spi.memory.MemoryPoolInfo;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TotalReservationOnBlockedNodesLowMemoryKiller
implements LowMemoryKiller {
    @Override
    public Optional<QueryId> chooseQueryToKill(List<LowMemoryKiller.QueryMemoryInfo> runningQueries, List<MemoryInfo> nodes) {
        HashMap memoryReservationOnBlockedNodes = new HashMap();
        for (MemoryInfo node : nodes) {
            MemoryPoolInfo generalPool = node.getPools().get(LocalMemoryManager.GENERAL_POOL);
            if (generalPool == null || generalPool.getFreeBytes() + generalPool.getReservedRevocableBytes() > 0L) continue;
            Map queryMemoryReservations = generalPool.getQueryMemoryReservations();
            queryMemoryReservations.forEach((queryId, memoryReservation) -> memoryReservationOnBlockedNodes.compute(queryId, (id, oldValue) -> oldValue == null ? memoryReservation : oldValue + memoryReservation));
        }
        return memoryReservationOnBlockedNodes.entrySet().stream().max(Comparator.comparingLong(Map.Entry::getValue)).map(Map.Entry::getKey);
    }
}

