/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.log.Logger;
import io.trino.execution.QueryState;
import io.trino.server.BasicQueryInfo;
import io.trino.spi.QueryId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;

@ThreadSafe
public class ClusterMemoryLeakDetector {
    private static final Logger log = Logger.get(ClusterMemoryLeakDetector.class);
    private static final int DEFAULT_LEAK_CLAIM_DELTA_SEC = 60;
    @GuardedBy(value="this")
    private Set<QueryId> leakedQueries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkForMemoryLeaks(Supplier<List<BasicQueryInfo>> queryInfoSupplier, Map<QueryId, Long> queryMemoryReservations) {
        Objects.requireNonNull(queryInfoSupplier);
        Objects.requireNonNull(queryMemoryReservations);
        ImmutableMap queryIdToInfo = Maps.uniqueIndex((Iterable)queryInfoSupplier.get(), BasicQueryInfo::getQueryId);
        Map leakedQueryReservations = (Map)queryMemoryReservations.entrySet().stream().filter(entry -> (Long)entry.getValue() > 0L).filter(arg_0 -> ClusterMemoryLeakDetector.lambda$checkForMemoryLeaks$1((Map)queryIdToInfo, arg_0)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!leakedQueryReservations.isEmpty()) {
            log.debug("Memory leak detected. The following queries are already finished, but they have memory reservations on some worker node(s): %s", new Object[]{leakedQueryReservations});
        }
        ClusterMemoryLeakDetector clusterMemoryLeakDetector = this;
        synchronized (clusterMemoryLeakDetector) {
            this.leakedQueries = ImmutableSet.copyOf(leakedQueryReservations.keySet());
        }
    }

    private static boolean isLeaked(Map<QueryId, BasicQueryInfo> queryIdToInfo, QueryId queryId) {
        BasicQueryInfo queryInfo = queryIdToInfo.get(queryId);
        if (queryInfo == null) {
            return true;
        }
        DateTime queryEndTime = queryInfo.getQueryStats().getEndTime();
        if (queryInfo.getState() == QueryState.RUNNING || queryEndTime == null) {
            return false;
        }
        return Seconds.secondsBetween((ReadableInstant)queryEndTime, (ReadableInstant)DateTime.now()).getSeconds() >= 60;
    }

    synchronized boolean wasQueryPossiblyLeaked(QueryId queryId) {
        return this.leakedQueries.contains(queryId);
    }

    synchronized int getNumberOfLeakedQueries() {
        return this.leakedQueries.size();
    }

    private static /* synthetic */ boolean lambda$checkForMemoryLeaks$1(Map queryIdToInfo, Map.Entry entry) {
        return ClusterMemoryLeakDetector.isLeaked(queryIdToInfo, (QueryId)entry.getKey());
    }
}

