/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.scheduler.OutputBufferManager;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class BroadcastOutputBufferManager
implements OutputBufferManager {
    @GuardedBy(value="this")
    private OutputBuffers outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers(OutputBuffers.BufferType.BROADCAST);

    BroadcastOutputBufferManager() {
    }

    @Override
    public synchronized void addOutputBuffer(OutputBuffers.OutputBufferId newBuffer) {
        if (this.outputBuffers.isNoMoreBufferIds()) {
            return;
        }
        OutputBuffers newOutputBuffers = this.outputBuffers.withBuffer(newBuffer, 0);
        if (newOutputBuffers != this.outputBuffers) {
            this.outputBuffers = newOutputBuffers;
        }
    }

    @Override
    public synchronized void noMoreBuffers() {
        if (!this.outputBuffers.isNoMoreBufferIds()) {
            this.outputBuffers = this.outputBuffers.withNoMoreBufferIds();
        }
    }

    @Override
    public synchronized OutputBuffers getOutputBuffers() {
        return this.outputBuffers;
    }
}

