/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.Use;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.inject.Inject;

public class UseTask
implements DataDefinitionTask<Use> {
    private final Metadata metadata;

    @Inject
    public UseTask(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public String getName() {
        return "USE";
    }

    @Override
    public ListenableFuture<Void> execute(Use statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        String catalog;
        Session session = stateMachine.getSession();
        if (this.metadata.getCatalogHandle(session, catalog = statement.getCatalog().map(identifier -> identifier.getValue().toLowerCase(Locale.ENGLISH)).orElseGet(() -> session.getCatalog().orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_CATALOG_NAME, (Node)statement, "Catalog must be specified when session catalog is not set", new Object[0])))).isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + catalog);
        }
        String schema = statement.getSchema().getValue().toLowerCase(Locale.ENGLISH);
        CatalogSchemaName name = new CatalogSchemaName(catalog, schema);
        if (!this.metadata.schemaExists(session, name)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Schema does not exist: " + name);
        }
        if (statement.getCatalog().isPresent()) {
            stateMachine.setSetCatalog(catalog);
        }
        stateMachine.setSetSchema(schema);
        return Futures.immediateVoidFuture();
    }
}

