/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TablePropertyManager;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.NodeUtils;
import io.trino.sql.ParameterUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SetProperties;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class SetPropertiesTask
implements DataDefinitionTask<SetProperties> {
    private final PlannerContext plannerContext;
    private final AccessControl accessControl;
    private final TablePropertyManager tablePropertyManager;

    @Inject
    public SetPropertiesTask(PlannerContext plannerContext, AccessControl accessControl, TablePropertyManager tablePropertyManager) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
    }

    @Override
    public String getName() {
        return "SET PROPERTIES";
    }

    @Override
    public ListenableFuture<Void> execute(SetProperties statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        Map<String, Expression> sqlProperties = NodeUtils.mapFromProperties(statement.getProperties());
        if (statement.getType() != SetProperties.Type.TABLE) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Unsupported target type: %s", statement.getType());
        }
        Map properties = this.tablePropertyManager.getProperties(MetadataUtil.getRequiredCatalogHandle(this.plannerContext.getMetadata(), session, (Node)statement, tableName.getCatalogName()), tableName.getCatalogName(), (Map)sqlProperties, session, this.plannerContext, this.accessControl, (Map)ParameterUtils.parameterExtractor((Statement)statement, parameters), false);
        this.setTableProperties(statement, tableName, session, properties);
        return Futures.immediateVoidFuture();
    }

    private void setTableProperties(SetProperties statement, QualifiedObjectName tableName, Session session, Map<String, Object> properties) {
        if (this.plannerContext.getMetadata().isMaterializedView(session, tableName)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot set properties to a materialized view in ALTER TABLE", new Object[0]);
        }
        if (this.plannerContext.getMetadata().isView(session, tableName)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot set properties to a view in ALTER TABLE", new Object[0]);
        }
        Optional<TableHandle> tableHandle = this.plannerContext.getMetadata().getTableHandle(session, tableName);
        if (tableHandle.isEmpty()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table does not exist: %s", tableName);
        }
        this.accessControl.checkCanSetTableProperties(session.toSecurityContext(), tableName, properties);
        this.plannerContext.getMetadata().setTableProperties(session, tableHandle.get(), properties);
    }
}

