/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.MoreObjects;

public final class PartitionedSplitsInfo {
    private static final PartitionedSplitsInfo NO_SPLITS_INFO = new PartitionedSplitsInfo(0, 0L);
    private final int count;
    private final long weightSum;

    private PartitionedSplitsInfo(int splitCount, long splitsWeightSum) {
        this.count = splitCount;
        this.weightSum = splitsWeightSum;
    }

    public int getCount() {
        return this.count;
    }

    public long getWeightSum() {
        return this.weightSum;
    }

    public int hashCode() {
        return this.count * 31 + Long.hashCode(this.weightSum);
    }

    public boolean equals(Object other) {
        if (!(other instanceof PartitionedSplitsInfo)) {
            return false;
        }
        PartitionedSplitsInfo otherInfo = (PartitionedSplitsInfo)other;
        return this == otherInfo || this.count == otherInfo.count && this.weightSum == otherInfo.weightSum;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("count", this.count).add("weightSum", this.weightSum).toString();
    }

    public static PartitionedSplitsInfo forSplitCountAndWeightSum(int splitCount, long weightSum) {
        return splitCount == 0 ? NO_SPLITS_INFO : new PartitionedSplitsInfo(splitCount, weightSum);
    }

    public static PartitionedSplitsInfo forZeroSplits() {
        return NO_SPLITS_INFO;
    }
}

