/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.Session;
import io.trino.cost.ComposableStatsCalculator;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsNormalizer;
import io.trino.cost.StatsProvider;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public abstract class SimpleStatsRule<T extends PlanNode>
implements ComposableStatsCalculator.Rule<T> {
    private final StatsNormalizer normalizer;

    protected SimpleStatsRule(StatsNormalizer normalizer) {
        this.normalizer = Objects.requireNonNull(normalizer, "normalizer is null");
    }

    @Override
    public final Optional<PlanNodeStatsEstimate> calculate(T node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        return this.doCalculate(node, sourceStats, lookup, session, types).map(estimate -> this.normalizer.normalize((PlanNodeStatsEstimate)estimate, (Collection<Symbol>)node.getOutputSymbols(), types));
    }

    protected abstract Optional<PlanNodeStatsEstimate> doCalculate(T var1, StatsProvider var2, Lookup var3, Session var4, TypeProvider var5);
}

