/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance.state;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.api.kv.Table;
import org.apache.bookkeeper.api.kv.options.Options;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.functions.api.StateStoreContext;
import org.apache.pulsar.functions.instance.state.DefaultStateStore;
import org.apache.pulsar.functions.utils.FunctionCommon;

public class BKStateStoreImpl
implements DefaultStateStore {
    private final String tenant;
    private final String namespace;
    private final String name;
    private final String fqsn;
    private final Table<ByteBuf, ByteBuf> table;

    public BKStateStoreImpl(String tenant, String namespace, String name, Table<ByteBuf, ByteBuf> table) {
        this.tenant = tenant;
        this.namespace = namespace;
        this.name = name;
        this.table = table;
        this.fqsn = FunctionCommon.getFullyQualifiedName((String)tenant, (String)namespace, (String)name);
    }

    public String tenant() {
        return this.tenant;
    }

    public String namespace() {
        return this.namespace;
    }

    public String name() {
        return this.name;
    }

    public String fqsn() {
        return this.fqsn;
    }

    public void init(StateStoreContext ctx) {
    }

    public void close() {
        this.table.close();
    }

    public CompletableFuture<Void> incrCounterAsync(String key, long amount) {
        return this.table.increment((Object)Unpooled.wrappedBuffer((byte[])key.getBytes(StandardCharsets.UTF_8)), amount);
    }

    public void incrCounter(String key, long amount) {
        try {
            FutureUtils.result(this.incrCounterAsync(key, amount));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to increment key '" + key + "' by amount '" + amount + "'", e);
        }
    }

    public CompletableFuture<Long> getCounterAsync(String key) {
        return this.table.getNumber((Object)Unpooled.wrappedBuffer((byte[])key.getBytes(StandardCharsets.UTF_8)));
    }

    public long getCounter(String key) {
        try {
            return (Long)FutureUtils.result(this.getCounterAsync(key));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve counter from key '" + key + "'");
        }
    }

    public CompletableFuture<Void> putAsync(String key, ByteBuffer value) {
        if (value != null) {
            value.position(0);
            return this.table.put((Object)Unpooled.wrappedBuffer((byte[])key.getBytes(StandardCharsets.UTF_8)), (Object)Unpooled.wrappedBuffer((ByteBuffer)value));
        }
        return this.table.put((Object)Unpooled.wrappedBuffer((byte[])key.getBytes(StandardCharsets.UTF_8)), null);
    }

    public void put(String key, ByteBuffer value) {
        try {
            FutureUtils.result(this.putAsync(key, value));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update the state value for key '" + key + "'");
        }
    }

    public CompletableFuture<Void> deleteAsync(String key) {
        return this.table.delete((Object)Unpooled.wrappedBuffer((byte[])key.getBytes(StandardCharsets.UTF_8)), Options.delete()).thenApply(ignored -> null);
    }

    public void delete(String key) {
        try {
            FutureUtils.result(this.deleteAsync(key));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete the state value for key '" + key + "'");
        }
    }

    public CompletableFuture<ByteBuffer> getAsync(String key) {
        return this.table.get((Object)Unpooled.wrappedBuffer((byte[])key.getBytes(StandardCharsets.UTF_8))).thenApply(data -> {
            try {
                if (data != null) {
                    ByteBuffer result = ByteBuffer.allocate(data.readableBytes());
                    data.readBytes(result);
                    result.position(0);
                    ByteBuffer byteBuffer = result;
                    return byteBuffer;
                }
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            finally {
                if (data != null) {
                    ReferenceCountUtil.safeRelease((Object)data);
                }
            }
        });
    }

    public ByteBuffer get(String key) {
        try {
            return (ByteBuffer)FutureUtils.result(this.getAsync(key));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve the state value for key '" + key + "'", e);
        }
    }
}

