/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jmx.http.rpc;

import com.google.common.base.MoreObjects;
import io.airlift.jmx.http.rpc.HttpMBeanServerCredentials;
import io.airlift.jmx.http.rpc.HttpMBeanServerRpc;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXAddressable;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;

public class HttpJmxConnector
implements JMXConnector,
JMXAddressable {
    private final JMXServiceURL jmxServiceUrl;
    private final URI baseUri;
    private final String connectionId = "http-" + UUID.randomUUID();
    private final HttpMBeanServerCredentials credentials;

    public HttpJmxConnector(JMXServiceURL jmxServiceUrl, Map<String, ?> environment) throws MalformedURLException {
        String[] credentials = (String[])environment.get("jmx.remote.credentials");
        this.credentials = credentials != null ? new HttpMBeanServerCredentials(credentials[0], credentials[1]) : null;
        String protocol = jmxServiceUrl.getProtocol();
        if (!"http".equalsIgnoreCase(protocol) && !"https".equalsIgnoreCase(protocol)) {
            throw new MalformedURLException(jmxServiceUrl.toString());
        }
        Object urlPath = jmxServiceUrl.getURLPath();
        if (!((String)urlPath).endsWith("/")) {
            urlPath = (String)urlPath + "/";
        }
        urlPath = (String)urlPath + "v1/jmx/mbeanServer/";
        int port = jmxServiceUrl.getPort();
        if (port == 0) {
            port = "http".equalsIgnoreCase(protocol) ? 80 : 433;
        }
        try {
            this.baseUri = new URI(protocol, null, jmxServiceUrl.getHost(), port, (String)urlPath, null, null);
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(jmxServiceUrl.toString());
        }
        this.jmxServiceUrl = jmxServiceUrl;
    }

    @Override
    public JMXServiceURL getAddress() {
        return this.jmxServiceUrl;
    }

    @Override
    public String getConnectionId() {
        return this.connectionId;
    }

    @Override
    public void connect() {
    }

    @Override
    public void connect(Map<String, ?> env) {
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() {
        return new HttpMBeanServerConnection(this.baseUri, this.credentials);
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(Subject delegationSubject) {
        return this.getMBeanServerConnection();
    }

    @Override
    public void close() {
    }

    @Override
    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener) {
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener l, NotificationFilter f, Object handback) {
    }

    public static class HttpMBeanServerConnection
    implements MBeanServerConnection {
        private final URI baseUri;
        private final HttpMBeanServerCredentials credentials;

        public HttpMBeanServerConnection(URI baseUri, HttpMBeanServerCredentials credentials) {
            this.baseUri = baseUri;
            this.credentials = credentials;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object invoke(String method, Object ... args) throws Exception {
            OutputStream outputStream = null;
            InputStream inputStream = null;
            try {
                HttpURLConnection urlConnection = (HttpURLConnection)this.baseUri.resolve(method).toURL().openConnection(Proxy.NO_PROXY);
                urlConnection.setRequestMethod("GET");
                if (this.credentials != null) {
                    urlConnection.setRequestProperty("Authorization", this.credentials.toBasicAuthHeader());
                }
                urlConnection.setDoOutput(true);
                urlConnection.setChunkedStreamingMode(4096);
                outputStream = urlConnection.getOutputStream();
                outputStream.write(HttpMBeanServerRpc.serialize(args));
                outputStream.close();
                int statusCode = urlConnection.getResponseCode();
                if (statusCode == 401) {
                    throw new SecurityException("Unauthorized");
                }
                inputStream = statusCode < 400 ? urlConnection.getInputStream() : urlConnection.getErrorStream();
                Object result = HttpMBeanServerRpc.deserialize(inputStream);
                if (statusCode / 100 != 2) {
                    if (result instanceof Exception) {
                        throw (Exception)result;
                    }
                    throw new IllegalStateException(String.format("Expected response (%d) body to contain a serialized Exception, but body contains a serialized %s", statusCode, result.getClass().getName()));
                }
                Object object = result;
                return object;
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        @Override
        public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
            try {
                return (ObjectInstance)this.invoke("getObjectInstance", name);
            }
            catch (Exception e) {
                HttpMBeanServerRpc.propagateIfInstanceOf(e, InstanceNotFoundException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, IOException.class);
                HttpMBeanServerRpc.propagateIfPossible(e);
                throw new IOException(e);
            }
        }

        @Override
        public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws IOException {
            try {
                return (Set)this.invoke("queryMBeans", name, query);
            }
            catch (Exception e) {
                HttpMBeanServerRpc.propagateIfInstanceOf(e, IOException.class);
                HttpMBeanServerRpc.propagateIfPossible(e);
                throw new IOException(e);
            }
        }

        @Override
        public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws IOException {
            try {
                return (Set)this.invoke("queryNames", name, query);
            }
            catch (Exception e) {
                HttpMBeanServerRpc.propagateIfInstanceOf(e, IOException.class);
                HttpMBeanServerRpc.propagateIfPossible(e);
                throw new IOException(e);
            }
        }

        @Override
        public boolean isRegistered(ObjectName name) throws IOException {
            try {
                return (Boolean)this.invoke("isRegistered", name);
            }
            catch (Exception e) {
                HttpMBeanServerRpc.propagateIfInstanceOf(e, IOException.class);
                HttpMBeanServerRpc.propagateIfPossible(e);
                throw new IOException(e);
            }
        }

        @Override
        public Integer getMBeanCount() throws IOException {
            try {
                return (Integer)this.invoke("getMBeanCount", new Object[0]);
            }
            catch (Exception e) {
                HttpMBeanServerRpc.propagateIfInstanceOf(e, IOException.class);
                HttpMBeanServerRpc.propagateIfPossible(e);
                throw new IOException(e);
            }
        }

        @Override
        public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
            try {
                return this.invoke("getAttribute", name, attribute);
            }
            catch (Exception e) {
                HttpMBeanServerRpc.propagateIfInstanceOf(e, MBeanException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, AttributeNotFoundException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, InstanceNotFoundException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, ReflectionException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, IOException.class);
                HttpMBeanServerRpc.propagateIfPossible(e);
                throw new IOException(e);
            }
        }

        @Override
        public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            try {
                return (AttributeList)this.invoke("getAttributes", name, attributes);
            }
            catch (Exception e) {
                HttpMBeanServerRpc.propagateIfInstanceOf(e, InstanceNotFoundException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, ReflectionException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, IOException.class);
                HttpMBeanServerRpc.propagateIfPossible(e);
                throw new IOException(e);
            }
        }

        @Override
        public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
            try {
                this.invoke("setAttribute", name, attribute);
            }
            catch (Exception e) {
                HttpMBeanServerRpc.propagateIfInstanceOf(e, InstanceNotFoundException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, AttributeNotFoundException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, InvalidAttributeValueException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, MBeanException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, ReflectionException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, IOException.class);
                HttpMBeanServerRpc.propagateIfPossible(e);
                throw new IOException(e);
            }
        }

        @Override
        public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            try {
                return (AttributeList)this.invoke("setAttributes", name, attributes);
            }
            catch (Exception e) {
                HttpMBeanServerRpc.propagateIfInstanceOf(e, InstanceNotFoundException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, ReflectionException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, IOException.class);
                HttpMBeanServerRpc.propagateIfPossible(e);
                throw new IOException(e);
            }
        }

        @Override
        public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            try {
                return this.invoke("invoke", name, operationName, params, signature);
            }
            catch (Exception e) {
                HttpMBeanServerRpc.propagateIfInstanceOf(e, InstanceNotFoundException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, MBeanException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, ReflectionException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, IOException.class);
                HttpMBeanServerRpc.propagateIfPossible(e);
                throw new IOException(e);
            }
        }

        @Override
        public String getDefaultDomain() throws IOException {
            try {
                return (String)this.invoke("getDefaultDomain", new Object[0]);
            }
            catch (Exception e) {
                HttpMBeanServerRpc.propagateIfInstanceOf(e, IOException.class);
                HttpMBeanServerRpc.propagateIfPossible(e);
                throw new IOException(e);
            }
        }

        @Override
        public String[] getDomains() throws IOException {
            try {
                return (String[])this.invoke("getDomains", new Object[0]);
            }
            catch (Exception e) {
                HttpMBeanServerRpc.propagateIfInstanceOf(e, IOException.class);
                HttpMBeanServerRpc.propagateIfPossible(e);
                throw new IOException(e);
            }
        }

        @Override
        public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            try {
                return (MBeanInfo)this.invoke("getMBeanInfo", name);
            }
            catch (Exception e) {
                HttpMBeanServerRpc.propagateIfInstanceOf(e, InstanceNotFoundException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, IntrospectionException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, ReflectionException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, IOException.class);
                HttpMBeanServerRpc.propagateIfPossible(e);
                throw new IOException(e);
            }
        }

        @Override
        public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
            try {
                return (Boolean)this.invoke("isInstanceOf", name, className);
            }
            catch (Exception e) {
                HttpMBeanServerRpc.propagateIfInstanceOf(e, InstanceNotFoundException.class);
                HttpMBeanServerRpc.propagateIfInstanceOf(e, IOException.class);
                HttpMBeanServerRpc.propagateIfPossible(e);
                throw new IOException(e);
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("baseUri", (Object)this.baseUri).toString();
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name) {
            new Exception().printStackTrace();
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) {
            new Exception().printStackTrace();
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) {
            new Exception().printStackTrace();
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) {
            new Exception().printStackTrace();
            throw new UnsupportedOperationException();
        }

        @Override
        public void unregisterMBean(ObjectName name) {
            new Exception().printStackTrace();
            throw new UnsupportedOperationException();
        }

        @Override
        public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
        }

        @Override
        public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) {
        }

        @Override
        public void removeNotificationListener(ObjectName name, ObjectName listener) {
        }

        @Override
        public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) {
        }

        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener) {
        }

        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
        }
    }
}

