/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.ComponentTree;
import org.apache.lucene.geo.EdgeTree;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.index.PointValues;

public class Polygon2D
implements Component2D {
    private final double minY;
    private final double maxY;
    private final double minX;
    private final double maxX;
    protected final Component2D holes;
    final EdgeTree tree;

    protected Polygon2D(double minX, double maxX, double minY, double maxY, double[] x, double[] y, Component2D holes) {
        this.minY = minY;
        this.maxY = maxY;
        this.minX = minX;
        this.maxX = maxX;
        this.holes = holes;
        this.tree = EdgeTree.createTree(x, y);
    }

    protected Polygon2D(Polygon polygon, Component2D holes) {
        this(polygon.minLon, polygon.maxLon, polygon.minLat, polygon.maxLat, polygon.getPolyLons(), polygon.getPolyLats(), holes);
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public boolean contains(double x, double y) {
        if (Component2D.containsPoint(x, y, this.minX, this.maxX, this.minY, this.maxY)) {
            return this.internalContains(x, y);
        }
        return false;
    }

    private boolean internalContains(double x, double y) {
        if (this.tree.contains(x, y)) {
            return this.holes == null || !this.holes.contains(x, y);
        }
        return false;
    }

    @Override
    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        int numCorners;
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (Component2D.within(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        if (this.holes != null) {
            PointValues.Relation holeRelation = this.holes.relate(minX, maxX, minY, maxY);
            if (holeRelation == PointValues.Relation.CELL_CROSSES_QUERY) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            if (holeRelation == PointValues.Relation.CELL_INSIDE_QUERY) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        }
        if ((numCorners = this.numberOfCorners(minX, maxX, minY, maxY)) == 4) {
            if (this.tree.crossesBox(minX, maxX, minY, maxY, true)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        if (numCorners == 0) {
            if (Component2D.containsPoint(this.tree.x1, this.tree.y1, minX, maxX, minY, maxY)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            if (this.tree.crossesBox(minX, maxX, minY, maxY, true)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    @Override
    public PointValues.Relation relateTriangle(double minX, double maxX, double minY, double maxY, double ax, double ay, double bx, double by, double cx, double cy) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (this.holes != null) {
            PointValues.Relation holeRelation = this.holes.relateTriangle(minX, maxX, minY, maxY, ax, ay, bx, by, cx, cy);
            if (holeRelation == PointValues.Relation.CELL_CROSSES_QUERY) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            if (holeRelation == PointValues.Relation.CELL_INSIDE_QUERY) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        }
        if (ax == bx && bx == cx && ay == by && by == cy) {
            return this.internalContains(ax, ay) ? PointValues.Relation.CELL_INSIDE_QUERY : PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (ax == cx && ay == cy) {
            return this.relateIndexedLineSegment(minX, maxX, minY, maxY, ax, ay, bx, by);
        }
        if (ax == bx && ay == by) {
            return this.relateIndexedLineSegment(minX, maxX, minY, maxY, bx, by, cx, cy);
        }
        if (bx == cx && by == cy) {
            return this.relateIndexedLineSegment(minX, maxX, minY, maxY, cx, cy, ax, ay);
        }
        return this.relateIndexedTriangle(minX, maxX, minY, maxY, ax, ay, bx, by, cx, cy);
    }

    @Override
    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double ax, double ay, boolean ab, double bx, double by, boolean bc, double cx, double cy, boolean ca) {
        if (ax == bx && ay == by || ax == cx && ay == cy || bx == cx && by == cy) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (this.contains(ax, ay) || this.contains(bx, by) || this.contains(cx, cy)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        Component2D.WithinRelation relation = Component2D.WithinRelation.DISJOINT;
        if (this.tree.crossesLine(minX, maxX, minY, maxY, ax, ay, bx, by)) {
            if (ab) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.tree.crossesLine(minX, maxX, minY, maxY, bx, by, cx, cy)) {
            if (bc) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.tree.crossesLine(minX, maxX, minY, maxY, cx, cy, ax, ay)) {
            if (ca) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (relation == Component2D.WithinRelation.CANDIDATE) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        if (Component2D.pointInTriangle(minX, maxX, minY, maxY, this.tree.x1, this.tree.y1, ax, ay, bx, by, cx, cy)) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        return relation;
    }

    private PointValues.Relation relateIndexedLineSegment(double minX, double maxX, double minY, double maxY, double a2x, double a2y, double b2x, double b2y) {
        int numCorners = 0;
        if (this.contains(a2x, a2y)) {
            ++numCorners;
        }
        if (this.contains(b2x, b2y)) {
            ++numCorners;
        }
        if (numCorners == 2) {
            if (this.tree.crossesLine(minX, maxX, minY, maxY, a2x, a2y, b2x, b2y)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        if (numCorners == 0) {
            if (this.tree.crossesLine(minX, maxX, minY, maxY, a2x, a2y, b2x, b2y)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    private PointValues.Relation relateIndexedTriangle(double minX, double maxX, double minY, double maxY, double ax, double ay, double bx, double by, double cx, double cy) {
        int numCorners = this.numberOfTriangleCorners(ax, ay, bx, by, cx, cy);
        if (numCorners == 3) {
            if (this.tree.crossesTriangle(minX, maxX, minY, maxY, ax, ay, bx, by, cx, cy, false)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        if (numCorners == 0) {
            if (Component2D.pointInTriangle(minX, maxX, minY, maxY, this.tree.x1, this.tree.y1, ax, ay, bx, by, cx, cy)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            if (this.tree.crossesTriangle(minX, maxX, minY, maxY, ax, ay, bx, by, cx, cy, false)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    private int numberOfTriangleCorners(double ax, double ay, double bx, double by, double cx, double cy) {
        int containsCount = 0;
        if (this.contains(ax, ay)) {
            ++containsCount;
        }
        if (this.contains(bx, by)) {
            ++containsCount;
        }
        if (containsCount == 1) {
            return containsCount;
        }
        if (this.contains(cx, cy)) {
            ++containsCount;
        }
        return containsCount;
    }

    private int numberOfCorners(double minX, double maxX, double minY, double maxY) {
        int containsCount = 0;
        if (this.contains(minX, minY)) {
            ++containsCount;
        }
        if (this.contains(maxX, minY)) {
            ++containsCount;
        }
        if (containsCount == 1) {
            return containsCount;
        }
        if (this.contains(maxX, maxY)) {
            ++containsCount;
        }
        if (containsCount == 2) {
            return containsCount;
        }
        if (this.contains(minX, maxY)) {
            ++containsCount;
        }
        return containsCount;
    }

    public static Component2D create(Polygon ... polygons) {
        Component2D[] components = new Component2D[polygons.length];
        for (int i = 0; i < components.length; ++i) {
            Polygon gon = polygons[i];
            Polygon[] gonHoles = gon.getHoles();
            Component2D holes = null;
            if (gonHoles.length > 0) {
                holes = Polygon2D.create(gonHoles);
            }
            components[i] = new Polygon2D(gon, holes);
        }
        return ComponentTree.create(components);
    }
}

