/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.protobuf.services;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.ExperimentalApi;
import io.grpc.InternalChannelz;
import io.grpc.InternalInstrumented;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.channelz.v1.ChannelzGrpc;
import io.grpc.channelz.v1.GetChannelRequest;
import io.grpc.channelz.v1.GetChannelResponse;
import io.grpc.channelz.v1.GetServerRequest;
import io.grpc.channelz.v1.GetServerResponse;
import io.grpc.channelz.v1.GetServerSocketsRequest;
import io.grpc.channelz.v1.GetServerSocketsResponse;
import io.grpc.channelz.v1.GetServersRequest;
import io.grpc.channelz.v1.GetServersResponse;
import io.grpc.channelz.v1.GetSocketRequest;
import io.grpc.channelz.v1.GetSocketResponse;
import io.grpc.channelz.v1.GetSubchannelRequest;
import io.grpc.channelz.v1.GetSubchannelResponse;
import io.grpc.channelz.v1.GetTopChannelsRequest;
import io.grpc.channelz.v1.GetTopChannelsResponse;
import io.grpc.protobuf.services.ChannelzProtoUtil;
import io.grpc.stub.StreamObserver;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4206")
public final class ChannelzService
extends ChannelzGrpc.ChannelzImplBase {
    private final InternalChannelz channelz;
    private final int maxPageSize;

    public static ChannelzService newInstance(int maxPageSize) {
        return new ChannelzService(InternalChannelz.instance(), maxPageSize);
    }

    @VisibleForTesting
    ChannelzService(InternalChannelz channelz, int maxPageSize) {
        this.channelz = channelz;
        this.maxPageSize = maxPageSize;
    }

    @Override
    public void getTopChannels(GetTopChannelsRequest request, StreamObserver<GetTopChannelsResponse> responseObserver) {
        GetTopChannelsResponse resp;
        InternalChannelz.RootChannelList rootChannels = this.channelz.getRootChannels(request.getStartChannelId(), this.maxPageSize);
        try {
            resp = ChannelzProtoUtil.toGetTopChannelResponse(rootChannels);
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
            return;
        }
        responseObserver.onNext((Object)resp);
        responseObserver.onCompleted();
    }

    @Override
    public void getChannel(GetChannelRequest request, StreamObserver<GetChannelResponse> responseObserver) {
        GetChannelResponse resp;
        InternalInstrumented s = this.channelz.getRootChannel(request.getChannelId());
        if (s == null) {
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription("Can't find channel " + request.getChannelId()).asRuntimeException());
            return;
        }
        try {
            resp = GetChannelResponse.newBuilder().setChannel(ChannelzProtoUtil.toChannel((InternalInstrumented<InternalChannelz.ChannelStats>)s)).build();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
            return;
        }
        responseObserver.onNext((Object)resp);
        responseObserver.onCompleted();
    }

    @Override
    public void getServers(GetServersRequest request, StreamObserver<GetServersResponse> responseObserver) {
        GetServersResponse resp;
        InternalChannelz.ServerList servers = this.channelz.getServers(request.getStartServerId(), this.maxPageSize);
        try {
            resp = ChannelzProtoUtil.toGetServersResponse(servers);
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
            return;
        }
        responseObserver.onNext((Object)resp);
        responseObserver.onCompleted();
    }

    @Override
    public void getServer(GetServerRequest request, StreamObserver<GetServerResponse> responseObserver) {
        GetServerResponse resp;
        InternalInstrumented s = this.channelz.getServer(request.getServerId());
        if (s == null) {
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription("Can't find server " + request.getServerId()).asRuntimeException());
            return;
        }
        try {
            resp = GetServerResponse.newBuilder().setServer(ChannelzProtoUtil.toServer((InternalInstrumented<InternalChannelz.ServerStats>)s)).build();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
            return;
        }
        responseObserver.onNext((Object)resp);
        responseObserver.onCompleted();
    }

    @Override
    public void getSubchannel(GetSubchannelRequest request, StreamObserver<GetSubchannelResponse> responseObserver) {
        GetSubchannelResponse resp;
        InternalInstrumented s = this.channelz.getSubchannel(request.getSubchannelId());
        if (s == null) {
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription("Can't find subchannel " + request.getSubchannelId()).asRuntimeException());
            return;
        }
        try {
            resp = GetSubchannelResponse.newBuilder().setSubchannel(ChannelzProtoUtil.toSubchannel((InternalInstrumented<InternalChannelz.ChannelStats>)s)).build();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
            return;
        }
        responseObserver.onNext((Object)resp);
        responseObserver.onCompleted();
    }

    @Override
    public void getSocket(GetSocketRequest request, StreamObserver<GetSocketResponse> responseObserver) {
        GetSocketResponse resp;
        InternalInstrumented s = this.channelz.getSocket(request.getSocketId());
        if (s == null) {
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription("Can't find socket " + request.getSocketId()).asRuntimeException());
            return;
        }
        try {
            resp = GetSocketResponse.newBuilder().setSocket(ChannelzProtoUtil.toSocket((InternalInstrumented<InternalChannelz.SocketStats>)s)).build();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
            return;
        }
        responseObserver.onNext((Object)resp);
        responseObserver.onCompleted();
    }

    @Override
    public void getServerSockets(GetServerSocketsRequest request, StreamObserver<GetServerSocketsResponse> responseObserver) {
        GetServerSocketsResponse resp;
        InternalChannelz.ServerSocketsList serverSockets = this.channelz.getServerSockets(request.getServerId(), request.getStartSocketId(), this.maxPageSize);
        if (serverSockets == null) {
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription("Can't find server " + request.getServerId()).asRuntimeException());
            return;
        }
        try {
            resp = ChannelzProtoUtil.toGetServerSocketsResponse(serverSockets);
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
            return;
        }
        responseObserver.onNext((Object)resp);
        responseObserver.onCompleted();
    }
}

