/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SubsetDefinition
extends Node {
    private final Identifier name;
    private final List<Identifier> identifiers;

    public SubsetDefinition(Identifier name, List<Identifier> identifiers) {
        this(Optional.empty(), name, identifiers);
    }

    public SubsetDefinition(NodeLocation location, Identifier name, List<Identifier> identifiers) {
        this(Optional.of(location), name, identifiers);
    }

    private SubsetDefinition(Optional<NodeLocation> location, Identifier name, List<Identifier> identifiers) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(identifiers, "identifiers is null");
        Preconditions.checkArgument((!identifiers.isEmpty() ? 1 : 0) != 0, (Object)"identifiers is empty");
        this.identifiers = identifiers;
    }

    public Identifier getName() {
        return this.name;
    }

    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSubsetDefinition(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.identifiers;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("identifiers", this.identifiers).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubsetDefinition that = (SubsetDefinition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.identifiers, that.identifiers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.identifiers);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!SubsetDefinition.sameClass(this, other)) {
            return false;
        }
        return Objects.equals(this.name, ((SubsetDefinition)other).name);
    }
}

