/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.type.TimeZoneKey;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public final class LongTimestampWithTimeZone
implements Comparable<LongTimestampWithTimeZone> {
    public static final int INSTANCE_SIZE = ClassLayout.parseClass(LongTimestampWithTimeZone.class).instanceSize();
    private final long epochMillis;
    private final int picosOfMilli;
    private final short timeZoneKey;

    public static LongTimestampWithTimeZone fromEpochSecondsAndFraction(long epochSecond, long fractionInPicos, TimeZoneKey timeZoneKey) {
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction(epochSecond * 1000L + fractionInPicos / 1000000000L, (int)(fractionInPicos % 1000000000L), timeZoneKey);
    }

    public static LongTimestampWithTimeZone fromEpochMillisAndFraction(long epochMillis, int picosOfMilli, TimeZoneKey timeZoneKey) {
        return new LongTimestampWithTimeZone(epochMillis, picosOfMilli, timeZoneKey.getKey());
    }

    public static LongTimestampWithTimeZone fromEpochMillisAndFraction(long epochMillis, int picosOfMilli, short timeZoneKey) {
        return new LongTimestampWithTimeZone(epochMillis, picosOfMilli, timeZoneKey);
    }

    private LongTimestampWithTimeZone(long epochMillis, int picosOfMilli, short timeZoneKey) {
        if (picosOfMilli < 0) {
            throw new IllegalArgumentException("picosOfMilli must be >= 0");
        }
        if (picosOfMilli >= 1000000000) {
            throw new IllegalArgumentException("picosOfMilli must be < 1000000000");
        }
        this.epochMillis = epochMillis;
        this.picosOfMilli = picosOfMilli;
        this.timeZoneKey = timeZoneKey;
    }

    public long getEpochMillis() {
        return this.epochMillis;
    }

    public int getPicosOfMilli() {
        return this.picosOfMilli;
    }

    public short getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongTimestampWithTimeZone that = (LongTimestampWithTimeZone)o;
        return this.epochMillis == that.epochMillis && this.picosOfMilli == that.picosOfMilli && this.timeZoneKey == that.timeZoneKey;
    }

    public int hashCode() {
        return Objects.hash(this.epochMillis, this.picosOfMilli, this.timeZoneKey);
    }

    @Override
    public int compareTo(LongTimestampWithTimeZone other) {
        int value = Long.compare(this.epochMillis, other.epochMillis);
        if (value != 0) {
            return value;
        }
        return Integer.compare(this.picosOfMilli, other.picosOfMilli);
    }
}

