/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.eventlistener;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.eventlistener.ColumnDetail;
import java.util.Objects;
import java.util.Set;

public class OutputColumnMetadata {
    private final String columnName;
    private final String columnType;
    private final Set<ColumnDetail> sourceColumns;

    @JsonCreator
    public OutputColumnMetadata(String columnName, String columnType, Set<ColumnDetail> sourceColumns) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.sourceColumns = Objects.requireNonNull(sourceColumns, "sourceColumns is null");
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public String getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public Set<ColumnDetail> getSourceColumns() {
        return this.sourceColumns;
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.columnType, this.sourceColumns);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OutputColumnMetadata other = (OutputColumnMetadata)obj;
        return Objects.equals(this.columnName, other.columnName) && Objects.equals(this.columnType, other.columnType) && Objects.equals(this.sourceColumns, other.sourceColumns);
    }
}

