/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.node;

import com.google.common.net.InetAddresses;
import io.airlift.configuration.Config;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import java.net.InetAddress;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@DefunctConfig(value={"http-server.ip", "jetty.ip"})
public class NodeConfig {
    public static final String ID_REGEXP = "[A-Za-z0-9][_A-Za-z0-9-]*";
    public static final String ENV_REGEXP = "[a-z0-9][_a-z0-9]*";
    public static final String POOL_REGEXP = "[a-z0-9][_a-z0-9]*";
    private String environment;
    private String pool = "general";
    private String nodeId;
    private String location;
    private String nodeInternalAddress;
    private String nodeExternalAddress;
    private InetAddress nodeBindIp;
    private String binarySpec;
    private String configSpec;
    private AddressSource internalAddressSource = AddressSource.IP;

    @NotNull
    @Pattern(regexp="[a-z0-9][_a-z0-9]*", message="is malformed")
    public @NotNull @Pattern(regexp="[a-z0-9][_a-z0-9]*", message="is malformed") String getEnvironment() {
        return this.environment;
    }

    @Config(value="node.environment")
    public NodeConfig setEnvironment(String environment) {
        this.environment = environment;
        return this;
    }

    @NotNull
    @Pattern(regexp="[a-z0-9][_a-z0-9]*", message="is malformed")
    public @NotNull @Pattern(regexp="[a-z0-9][_a-z0-9]*", message="is malformed") String getPool() {
        return this.pool;
    }

    @Config(value="node.pool")
    public NodeConfig setPool(String pool) {
        this.pool = pool;
        return this;
    }

    @Pattern(regexp="[A-Za-z0-9][_A-Za-z0-9-]*", message="is malformed")
    public @Pattern(regexp="[A-Za-z0-9][_A-Za-z0-9-]*", message="is malformed") String getNodeId() {
        return this.nodeId;
    }

    @Config(value="node.id")
    public NodeConfig setNodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    @Config(value="node.location")
    public NodeConfig setLocation(String location) {
        this.location = location;
        return this;
    }

    public String getNodeInternalAddress() {
        return this.nodeInternalAddress;
    }

    @Config(value="node.internal-address")
    @LegacyConfig(value={"node.ip"})
    public NodeConfig setNodeInternalAddress(String nodeInternalAddress) {
        this.nodeInternalAddress = nodeInternalAddress;
        return this;
    }

    public String getNodeExternalAddress() {
        return this.nodeExternalAddress;
    }

    @Config(value="node.external-address")
    public NodeConfig setNodeExternalAddress(String nodeExternalAddress) {
        this.nodeExternalAddress = nodeExternalAddress;
        return this;
    }

    public InetAddress getNodeBindIp() {
        return this.nodeBindIp;
    }

    public NodeConfig setNodeBindIp(InetAddress nodeBindIp) {
        this.nodeBindIp = nodeBindIp;
        return this;
    }

    @Config(value="node.bind-ip")
    public NodeConfig setNodeBindIp(String nodeBindIp) {
        if (nodeBindIp != null) {
            this.nodeBindIp = InetAddresses.forString((String)nodeBindIp);
        }
        return this;
    }

    public String getBinarySpec() {
        return this.binarySpec;
    }

    @Config(value="node.binary-spec")
    public NodeConfig setBinarySpec(String binarySpec) {
        this.binarySpec = binarySpec;
        return this;
    }

    public String getConfigSpec() {
        return this.configSpec;
    }

    @Config(value="node.config-spec")
    public NodeConfig setConfigSpec(String configSpec) {
        this.configSpec = configSpec;
        return this;
    }

    public AddressSource getInternalAddressSource() {
        return this.internalAddressSource;
    }

    @Config(value="node.internal-address-source")
    public NodeConfig setInternalAddressSource(AddressSource internalAddressSource) {
        this.internalAddressSource = internalAddressSource;
        return this;
    }

    public static enum AddressSource {
        HOSTNAME,
        FQDN,
        IP,
        IP_ENCODED_AS_HOSTNAME;

    }
}

