/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.common.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.distributedlog.common.config.ConcurrentBaseConfiguration;
import org.apache.distributedlog.common.config.ConfigurationListener;
import org.apache.distributedlog.common.config.FileConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationSubscription {
    static final Logger LOG = LoggerFactory.getLogger(ConfigurationSubscription.class);
    private final ConcurrentBaseConfiguration viewConfig;
    private final ScheduledExecutorService executorService;
    private final int reloadPeriod;
    private final TimeUnit reloadUnit;
    private final List<FileConfigurationBuilder> fileConfigBuilders;
    private final List<FileConfiguration> fileConfigs;
    private final CopyOnWriteArraySet<ConfigurationListener> confListeners;

    public ConfigurationSubscription(ConcurrentBaseConfiguration viewConfig, List<FileConfigurationBuilder> fileConfigBuilders, ScheduledExecutorService executorService, int reloadPeriod, TimeUnit reloadUnit) throws ConfigurationException {
        Preconditions.checkNotNull(fileConfigBuilders);
        Preconditions.checkArgument((!fileConfigBuilders.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)executorService);
        Preconditions.checkNotNull((Object)((Object)viewConfig));
        this.viewConfig = viewConfig;
        this.executorService = executorService;
        this.reloadPeriod = reloadPeriod;
        this.reloadUnit = reloadUnit;
        this.fileConfigBuilders = fileConfigBuilders;
        this.fileConfigs = Lists.newArrayListWithExpectedSize((int)this.fileConfigBuilders.size());
        this.confListeners = new CopyOnWriteArraySet();
        this.reload();
        this.scheduleReload();
    }

    public void registerListener(ConfigurationListener listener) {
        this.confListeners.add(listener);
    }

    public void unregisterListener(ConfigurationListener listener) {
        this.confListeners.remove(listener);
    }

    private boolean initConfig() {
        block4: {
            if (this.fileConfigs.isEmpty()) {
                try {
                    for (FileConfigurationBuilder fileConfigBuilder : this.fileConfigBuilders) {
                        FileConfiguration fileConfig = fileConfigBuilder.getConfiguration();
                        FileChangedReloadingStrategy reloadingStrategy = new FileChangedReloadingStrategy();
                        reloadingStrategy.setRefreshDelay(0L);
                        fileConfig.setReloadingStrategy((ReloadingStrategy)reloadingStrategy);
                        this.fileConfigs.add(fileConfig);
                    }
                }
                catch (ConfigurationException ex) {
                    if (this.fileNotFound((Exception)((Object)ex))) break block4;
                    LOG.error("Config init failed", (Throwable)ex);
                }
            }
        }
        return !this.fileConfigs.isEmpty();
    }

    private void scheduleReload() {
        this.executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ConfigurationSubscription.this.reload();
            }
        }, 0L, this.reloadPeriod, this.reloadUnit);
    }

    @VisibleForTesting
    void reload() {
        if (!this.initConfig()) {
            return;
        }
        HashSet confKeys = Sets.newHashSet();
        for (FileConfiguration fileConfig : this.fileConfigs) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Check and reload config, file={}, lastModified={}", (Object)fileConfig.getFile(), (Object)fileConfig.getFile().lastModified());
            }
            fileConfig.reload();
            Iterator keyIter = fileConfig.getKeys();
            while (keyIter.hasNext()) {
                String key = (String)keyIter.next();
                confKeys.add(key);
            }
        }
        Iterator viewIter = this.viewConfig.getKeys();
        while (viewIter.hasNext()) {
            String key = (String)viewIter.next();
            if (confKeys.contains(key)) continue;
            this.clearViewProperty(key);
        }
        LOG.info("Reload features : {}", (Object)confKeys);
        for (FileConfiguration fileConfig : this.fileConfigs) {
            try {
                this.loadView(fileConfig);
            }
            catch (Exception ex) {
                if (this.fileNotFound(ex)) continue;
                LOG.error("Config reload failed for file {}", (Object)fileConfig.getFileName(), (Object)ex);
            }
        }
        for (ConfigurationListener listener : this.confListeners) {
            listener.onReload(this.viewConfig);
        }
    }

    private boolean fileNotFound(Exception ex) {
        return ex instanceof FileNotFoundException || ex.getCause() != null && ex.getCause() instanceof FileNotFoundException;
    }

    private void loadView(FileConfiguration fileConfig) {
        Iterator fileIter = fileConfig.getKeys();
        while (fileIter.hasNext()) {
            String key = (String)fileIter.next();
            this.setViewProperty(fileConfig, key, fileConfig.getProperty(key));
        }
    }

    private void clearViewProperty(String key) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing property, key={}", (Object)key);
        }
        this.viewConfig.clearProperty(key);
    }

    private void setViewProperty(FileConfiguration fileConfig, String key, Object value) {
        if (!this.viewConfig.containsKey(key) || !this.viewConfig.getProperty(key).equals(value)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting property, key={} value={}", (Object)key, fileConfig.getProperty(key));
            }
            this.viewConfig.setProperty(key, fileConfig.getProperty(key));
        }
    }
}

