/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.AbstractZkLedgerManagerFactory;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerAuditorManager;
import org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerMetadataSerDe;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.ZkLayoutManager;
import org.apache.bookkeeper.meta.ZkLedgerAuditorManager;
import org.apache.bookkeeper.meta.ZkLedgerIdGenerator;
import org.apache.bookkeeper.meta.ZkLedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.metastore.MSException;
import org.apache.bookkeeper.metastore.MSWatchedEvent;
import org.apache.bookkeeper.metastore.MetaStore;
import org.apache.bookkeeper.metastore.MetastoreCallback;
import org.apache.bookkeeper.metastore.MetastoreCursor;
import org.apache.bookkeeper.metastore.MetastoreException;
import org.apache.bookkeeper.metastore.MetastoreFactory;
import org.apache.bookkeeper.metastore.MetastoreScannableTable;
import org.apache.bookkeeper.metastore.MetastoreTable;
import org.apache.bookkeeper.metastore.MetastoreTableItem;
import org.apache.bookkeeper.metastore.MetastoreUtils;
import org.apache.bookkeeper.metastore.MetastoreWatcher;
import org.apache.bookkeeper.metastore.Value;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.StringUtils;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSLedgerManagerFactory
extends AbstractZkLedgerManagerFactory {
    private static final Logger log = LoggerFactory.getLogger(MSLedgerManagerFactory.class);
    private static final Logger LOG = LoggerFactory.getLogger(MSLedgerManagerFactory.class);
    private static final int MS_CONNECT_BACKOFF_MS = 200;
    public static final int CUR_VERSION = 1;
    public static final String NAME = "ms";
    public static final String TABLE_NAME = "LEDGER";
    public static final String META_FIELD = ".META";
    AbstractConfiguration conf;
    MetaStore metastore;

    @Override
    public int getCurrentVersion() {
        return 1;
    }

    @Override
    public LedgerManagerFactory initialize(AbstractConfiguration conf, LayoutManager layoutManager, int factoryVersion) throws IOException {
        Preconditions.checkArgument((boolean)(layoutManager instanceof ZkLayoutManager));
        ZkLayoutManager zkLayoutManager = (ZkLayoutManager)layoutManager;
        if (1 != factoryVersion) {
            throw new IOException("Incompatible layout version found : " + factoryVersion);
        }
        this.conf = conf;
        this.zk = zkLayoutManager.getZk();
        String msName = conf.getMetastoreImplClass();
        try {
            this.metastore = MetastoreFactory.createMetaStore(msName);
            int msVersion = this.metastore.getVersion();
            this.metastore.init((Configuration)conf, msVersion);
        }
        catch (Throwable t) {
            throw new IOException("Failed to initialize metastore " + msName + " : ", t);
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        this.metastore.close();
    }

    static Long key2LedgerId(String key) {
        return null == key ? null : Long.valueOf(Long.parseLong(key, 10));
    }

    static String ledgerId2Key(Long lid) {
        return null == lid ? null : StringUtils.getZKStringId(lid);
    }

    static String rangeToString(Long firstLedger, boolean firstInclusive, Long lastLedger, boolean lastInclusive) {
        StringBuilder sb = new StringBuilder();
        sb.append(firstInclusive ? "[ " : "( ").append(firstLedger).append(" ~ ").append(lastLedger).append(lastInclusive ? " ]" : " )");
        return sb.toString();
    }

    static SortedSet<Long> entries2Ledgers(Iterator<MetastoreTableItem> entries) {
        TreeSet<Long> ledgers = new TreeSet<Long>();
        while (entries.hasNext()) {
            MetastoreTableItem item = entries.next();
            try {
                ledgers.add(MSLedgerManagerFactory.key2LedgerId(item.getKey()));
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Found invalid ledger key {}", (Object)item.getKey());
            }
        }
        return ledgers;
    }

    @Override
    public LedgerIdGenerator newLedgerIdGenerator() {
        List<ACL> zkAcls = ZkUtils.getACLs(this.conf);
        return new ZkLedgerIdGenerator(this.zk, ZKMetadataDriverBase.resolveZkLedgersRootPath(this.conf), "ms-idgen", zkAcls);
    }

    @Override
    public LedgerManager newLedgerManager() {
        return new MsLedgerManager(this.conf, this.zk, this.metastore);
    }

    @Override
    public LedgerUnderreplicationManager newLedgerUnderreplicationManager() throws ReplicationException.UnavailableException, InterruptedException, ReplicationException.CompatibilityException {
        return new ZkLedgerUnderreplicationManager(this.conf, this.zk);
    }

    @Override
    public void format(AbstractConfiguration<?> conf, LayoutManager layoutManager) throws InterruptedException, KeeperException, IOException {
        Class<LedgerManagerFactory> factoryClass;
        MetastoreScannableTable ledgerTable;
        try {
            ledgerTable = this.metastore.createScannableTable(TABLE_NAME);
        }
        catch (MetastoreException mse) {
            throw new IOException("Failed to instantiate table LEDGER in metastore " + this.metastore.getName());
        }
        try {
            MetastoreUtils.cleanTable(ledgerTable, conf.getMetastoreMaxEntriesPerScan());
        }
        catch (MSException mse) {
            throw new IOException("Exception when cleanning up table LEDGER", mse);
        }
        LOG.info("Finished cleaning up table {}.", (Object)TABLE_NAME);
        try {
            factoryClass = conf.getLedgerManagerFactoryClass();
        }
        catch (ConfigurationException e) {
            throw new IOException("Failed to get ledger manager factory class from configuration : ", e);
        }
        layoutManager.deleteLedgerLayout();
        MSLedgerManagerFactory.createNewLMFactory(conf, layoutManager, factoryClass);
    }

    @Override
    public boolean validateAndNukeExistingCluster(AbstractConfiguration<?> conf, LayoutManager layoutManager) throws InterruptedException, KeeperException, IOException {
        String zkLedgersRootPath = ZKMetadataDriverBase.resolveZkLedgersRootPath(conf);
        String zkServers = ZKMetadataDriverBase.resolveZkServers(conf);
        List ledgersRootPathChildrenList = this.zk.getChildren(zkLedgersRootPath, false);
        for (String ledgersRootPathChildren : ledgersRootPathChildrenList) {
            if (MsLedgerManager.isSpecialZnode(ledgersRootPathChildren)) continue;
            log.error("Found unexpected znode : {} under ledgersRootPath : {} so exiting nuke operation", (Object)ledgersRootPathChildren, (Object)zkLedgersRootPath);
            return false;
        }
        this.format(conf, layoutManager);
        ledgersRootPathChildrenList = this.zk.getChildren(zkLedgersRootPath, false);
        for (String ledgersRootPathChildren : ledgersRootPathChildrenList) {
            if (MsLedgerManager.isSpecialZnode(ledgersRootPathChildren)) {
                ZKUtil.deleteRecursive((ZooKeeper)this.zk, (String)(zkLedgersRootPath + "/" + ledgersRootPathChildren));
                continue;
            }
            log.error("Found unexpected znode : {} under ledgersRootPath : {} so exiting nuke operation", (Object)ledgersRootPathChildren, (Object)zkLedgersRootPath);
            return false;
        }
        this.zk.delete(zkLedgersRootPath, -1);
        log.info("Successfully nuked existing cluster, ZKServers: {} ledger root path: {}", (Object)zkServers, (Object)zkLedgersRootPath);
        return true;
    }

    @Override
    public LedgerAuditorManager newLedgerAuditorManager() {
        ServerConfiguration serverConfiguration = new ServerConfiguration(this.conf);
        return new ZkLedgerAuditorManager(this.zk, serverConfiguration, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    private static class AsyncSetProcessor<T> {
        ScheduledExecutorService scheduler;

        public AsyncSetProcessor(ScheduledExecutorService scheduler) {
            this.scheduler = scheduler;
        }

        public void process(Set<T> data, final BookkeeperInternalCallbacks.Processor<T> processor, final AsyncCallback.VoidCallback finalCb, final Object context, final int successRc, final int failureRc) {
            if (data == null || data.size() == 0) {
                finalCb.processResult(successRc, null, context);
                return;
            }
            final Iterator<T> iter = data.iterator();
            AsyncCallback.VoidCallback stubCallback = new AsyncCallback.VoidCallback(){

                public void processResult(int rc, String path, Object ctx) {
                    if (rc != successRc) {
                        finalCb.processResult(failureRc, null, context);
                        return;
                    }
                    if (!iter.hasNext()) {
                        finalCb.processResult(successRc, null, context);
                        return;
                    }
                    final Object dataToProcess = iter.next();
                    final 1 stub = this;
                    scheduler.submit(new Runnable(){

                        @Override
                        public void run() {
                            processor.process(dataToProcess, stub);
                        }
                    });
                }
            };
            T firstElement = iter.next();
            processor.process(firstElement, stubCallback);
        }
    }

    static class MsLedgerManager
    implements LedgerManager,
    MetastoreWatcher {
        final ZooKeeper zk;
        final AbstractConfiguration conf;
        private final LedgerMetadataSerDe serDe;
        final MetaStore metastore;
        final MetastoreScannableTable ledgerTable;
        final int maxEntriesPerScan;
        static final String IDGEN_ZNODE = "ms-idgen";
        protected final ConcurrentMap<Long, Set<BookkeeperInternalCallbacks.LedgerMetadataListener>> listeners = new ConcurrentHashMap<Long, Set<BookkeeperInternalCallbacks.LedgerMetadataListener>>();
        ScheduledExecutorService scheduler;

        MsLedgerManager(AbstractConfiguration conf, ZooKeeper zk, MetaStore metastore) {
            this.conf = conf;
            this.zk = zk;
            this.metastore = metastore;
            this.serDe = new LedgerMetadataSerDe();
            try {
                this.ledgerTable = metastore.createScannableTable(MSLedgerManagerFactory.TABLE_NAME);
            }
            catch (MetastoreException mse) {
                LOG.error("Failed to instantiate table LEDGER in metastore " + metastore.getName());
                throw new RuntimeException("Failed to instantiate table LEDGER in metastore " + metastore.getName());
            }
            this.maxEntriesPerScan = conf.getMetastoreMaxEntriesPerScan();
            ThreadFactoryBuilder tfb = new ThreadFactoryBuilder().setNameFormat("MSLedgerManagerScheduler-%d");
            this.scheduler = Executors.newSingleThreadScheduledExecutor(tfb.build());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(MSWatchedEvent e) {
            long ledgerId = MSLedgerManagerFactory.key2LedgerId(e.getKey());
            switch (e.getType()) {
                case CHANGED: {
                    new ReadLedgerMetadataTask(MSLedgerManagerFactory.key2LedgerId(e.getKey())).run();
                    break;
                }
                case REMOVED: {
                    Set listenerSet = (Set)this.listeners.get(ledgerId);
                    if (listenerSet == null) break;
                    Set set = listenerSet;
                    synchronized (set) {
                        for (BookkeeperInternalCallbacks.LedgerMetadataListener l : listenerSet) {
                            this.unregisterLedgerMetadataListener(ledgerId, l);
                            l.onChanged(ledgerId, null);
                        }
                        break;
                    }
                }
                default: {
                    LOG.warn("Unknown type: {}", (Object)e.getType());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerLedgerMetadataListener(long ledgerId, BookkeeperInternalCallbacks.LedgerMetadataListener listener) {
            if (null != listener) {
                LOG.info("Registered ledger metadata listener {} on ledger {}.", (Object)listener, (Object)ledgerId);
                Set<BookkeeperInternalCallbacks.LedgerMetadataListener> listenerSet = (HashSet<BookkeeperInternalCallbacks.LedgerMetadataListener>)this.listeners.get(ledgerId);
                if (listenerSet == null) {
                    HashSet<BookkeeperInternalCallbacks.LedgerMetadataListener> newListenerSet = new HashSet<BookkeeperInternalCallbacks.LedgerMetadataListener>();
                    Set oldListenerSet = this.listeners.putIfAbsent(ledgerId, newListenerSet);
                    listenerSet = null != oldListenerSet ? oldListenerSet : newListenerSet;
                }
                HashSet<BookkeeperInternalCallbacks.LedgerMetadataListener> hashSet = listenerSet;
                synchronized (hashSet) {
                    listenerSet.add(listener);
                }
                new ReadLedgerMetadataTask(ledgerId).run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregisterLedgerMetadataListener(long ledgerId, BookkeeperInternalCallbacks.LedgerMetadataListener listener) {
            Set listenerSet = (Set)this.listeners.get(ledgerId);
            if (listenerSet != null) {
                Set set = listenerSet;
                synchronized (set) {
                    if (listenerSet.remove(listener)) {
                        LOG.info("Unregistered ledger metadata listener {} on ledger {}.", (Object)listener, (Object)ledgerId);
                    }
                    if (listenerSet.isEmpty()) {
                        this.listeners.remove(ledgerId, listenerSet);
                    }
                }
            }
        }

        @Override
        public void close() {
            try {
                this.scheduler.shutdown();
            }
            catch (Exception e) {
                LOG.warn("Error when closing MsLedgerManager : ", (Throwable)e);
            }
            this.ledgerTable.close();
        }

        @Override
        public CompletableFuture<Versioned<LedgerMetadata>> createLedgerMetadata(final long lid, final LedgerMetadata metadata) {
            byte[] bytes;
            final CompletableFuture<Versioned<LedgerMetadata>> promise = new CompletableFuture<Versioned<LedgerMetadata>>();
            MetastoreCallback<Version> msCallback = new MetastoreCallback<Version>(){

                @Override
                public void complete(int rc, Version version, Object ctx) {
                    if (MSException.Code.BadVersion.getCode() == rc) {
                        promise.completeExceptionally(new BKException.BKMetadataVersionException());
                        return;
                    }
                    if (MSException.Code.OK.getCode() != rc) {
                        promise.completeExceptionally(new BKException.MetaStoreException());
                        return;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Create ledger {} with version {} successfully.", (Object)lid, (Object)version);
                    }
                    promise.complete(new Versioned<LedgerMetadata>(metadata, version));
                }
            };
            try {
                bytes = this.serDe.serialize(metadata);
            }
            catch (IOException ioe) {
                promise.completeExceptionally(new BKException.BKMetadataSerializationException(ioe));
                return promise;
            }
            this.ledgerTable.put(MSLedgerManagerFactory.ledgerId2Key(lid), new Value().setField(MSLedgerManagerFactory.META_FIELD, bytes), Version.NEW, msCallback, null);
            return promise;
        }

        @Override
        public CompletableFuture<Void> removeLedgerMetadata(final long ledgerId, Version version) {
            final CompletableFuture<Void> promise = new CompletableFuture<Void>();
            MetastoreCallback<Void> msCallback = new MetastoreCallback<Void>(){

                @Override
                public void complete(int rc, Void value, Object ctx) {
                    if (MSException.Code.NoKey.getCode() == rc) {
                        LOG.warn("Ledger entry does not exist in meta table: ledgerId={}", (Object)ledgerId);
                        promise.completeExceptionally(new BKException.BKNoSuchLedgerExistsOnMetadataServerException());
                    } else if (MSException.Code.OK.getCode() == rc) {
                        FutureUtils.complete((CompletableFuture)promise, null);
                    } else {
                        promise.completeExceptionally(new BKException.BKMetadataSerializationException());
                    }
                }
            };
            this.ledgerTable.remove(MSLedgerManagerFactory.ledgerId2Key(ledgerId), version, msCallback, null);
            return promise;
        }

        @Override
        public CompletableFuture<Versioned<LedgerMetadata>> readLedgerMetadata(final long ledgerId) {
            final String key = MSLedgerManagerFactory.ledgerId2Key(ledgerId);
            final CompletableFuture<Versioned<LedgerMetadata>> promise = new CompletableFuture<Versioned<LedgerMetadata>>();
            MetastoreCallback<Versioned<Value>> msCallback = new MetastoreCallback<Versioned<Value>>(){

                @Override
                public void complete(int rc, Versioned<Value> value, Object ctx) {
                    if (MSException.Code.NoKey.getCode() == rc) {
                        LOG.error("No ledger metadata found for ledger " + ledgerId + " : ", (Throwable)MSException.create(MSException.Code.get(rc), "No key " + key + " found."));
                        promise.completeExceptionally(new BKException.BKNoSuchLedgerExistsOnMetadataServerException());
                        return;
                    }
                    if (MSException.Code.OK.getCode() != rc) {
                        LOG.error("Could not read metadata for ledger " + ledgerId + " : ", (Throwable)MSException.create(MSException.Code.get(rc), "Failed to get key " + key));
                        promise.completeExceptionally(new BKException.MetaStoreException());
                        return;
                    }
                    try {
                        LedgerMetadata metadata = serDe.parseConfig(value.getValue().getField(MSLedgerManagerFactory.META_FIELD), ledgerId, Optional.empty());
                        promise.complete(new Versioned<LedgerMetadata>(metadata, value.getVersion()));
                    }
                    catch (IOException e) {
                        LOG.error("Could not parse ledger metadata for ledger " + ledgerId + " : ", (Throwable)e);
                        promise.completeExceptionally(new BKException.MetaStoreException());
                    }
                }
            };
            this.ledgerTable.get(key, this, msCallback, MetastoreTable.ALL_FIELDS);
            return promise;
        }

        @Override
        public CompletableFuture<Versioned<LedgerMetadata>> writeLedgerMetadata(final long ledgerId, final LedgerMetadata metadata, Version currentVersion) {
            byte[] bytes;
            final CompletableFuture<Versioned<LedgerMetadata>> promise = new CompletableFuture<Versioned<LedgerMetadata>>();
            try {
                bytes = this.serDe.serialize(metadata);
            }
            catch (IOException ioe) {
                promise.completeExceptionally(new BKException.MetaStoreException(ioe));
                return promise;
            }
            Value data = new Value().setField(MSLedgerManagerFactory.META_FIELD, bytes);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Writing ledger {} metadata, version {}", new Object[]{ledgerId, currentVersion});
            }
            final String key = MSLedgerManagerFactory.ledgerId2Key(ledgerId);
            MetastoreCallback<Version> msCallback = new MetastoreCallback<Version>(){

                @Override
                public void complete(int rc, Version version, Object ctx) {
                    if (MSException.Code.BadVersion.getCode() == rc) {
                        LOG.info("Bad version provided to updat metadata for ledger {}", (Object)ledgerId);
                        promise.completeExceptionally(new BKException.BKMetadataVersionException());
                    } else if (MSException.Code.NoKey.getCode() == rc) {
                        LOG.warn("Ledger {} doesn't exist when writing its ledger metadata.", (Object)ledgerId);
                        promise.completeExceptionally(new BKException.BKNoSuchLedgerExistsOnMetadataServerException());
                    } else if (MSException.Code.OK.getCode() == rc) {
                        promise.complete(new Versioned<LedgerMetadata>(metadata, version));
                    } else {
                        LOG.warn("Conditional update ledger metadata failed: ", (Throwable)MSException.create(MSException.Code.get(rc), "Failed to put key " + key));
                        promise.completeExceptionally(new BKException.MetaStoreException());
                    }
                }
            };
            this.ledgerTable.put(key, data, currentVersion, msCallback, null);
            return promise;
        }

        @Override
        public void asyncProcessLedgers(final BookkeeperInternalCallbacks.Processor<Long> processor, final AsyncCallback.VoidCallback finalCb, final Object context, final int successRc, final int failureRc) {
            MetastoreCallback<MetastoreCursor> openCursorCb = new MetastoreCallback<MetastoreCursor>(){

                @Override
                public void complete(int rc, MetastoreCursor cursor, Object ctx) {
                    if (MSException.Code.OK.getCode() != rc) {
                        finalCb.processResult(failureRc, null, context);
                        return;
                    }
                    if (!cursor.hasMoreEntries()) {
                        finalCb.processResult(successRc, null, context);
                        return;
                    }
                    this.asyncProcessLedgers(cursor, processor, finalCb, context, successRc, failureRc);
                }
            };
            this.ledgerTable.openCursor(MetastoreTable.NON_FIELDS, openCursorCb, null);
        }

        void asyncProcessLedgers(final MetastoreCursor cursor, final BookkeeperInternalCallbacks.Processor<Long> processor, final AsyncCallback.VoidCallback finalCb, final Object context, final int successRc, final int failureRc) {
            this.scheduler.submit(new Runnable(){

                @Override
                public void run() {
                    this.doAsyncProcessLedgers(cursor, processor, finalCb, context, successRc, failureRc);
                }
            });
        }

        void doAsyncProcessLedgers(final MetastoreCursor cursor, final BookkeeperInternalCallbacks.Processor<Long> processor, final AsyncCallback.VoidCallback finalCb, final Object context, final int successRc, final int failureRc) {
            if (!cursor.hasMoreEntries()) {
                finalCb.processResult(successRc, null, context);
                return;
            }
            MetastoreCursor.ReadEntriesCallback msCallback = new MetastoreCursor.ReadEntriesCallback(){

                @Override
                public void complete(int rc, Iterator<MetastoreTableItem> entries, Object ctx) {
                    if (MSException.Code.OK.getCode() != rc) {
                        finalCb.processResult(failureRc, null, context);
                        return;
                    }
                    TreeSet<Long> ledgers = new TreeSet<Long>();
                    while (entries.hasNext()) {
                        MetastoreTableItem item = entries.next();
                        try {
                            ledgers.add(MSLedgerManagerFactory.key2LedgerId(item.getKey()));
                        }
                        catch (NumberFormatException nfe) {
                            LOG.warn("Found invalid ledger key {}", (Object)item.getKey());
                        }
                    }
                    if (0 == ledgers.size()) {
                        this.asyncProcessLedgers(cursor, processor, finalCb, context, successRc, failureRc);
                        return;
                    }
                    final long startLedger = (Long)ledgers.first();
                    final long endLedger = (Long)ledgers.last();
                    AsyncSetProcessor<Long> setProcessor = new AsyncSetProcessor<Long>(scheduler);
                    setProcessor.process(ledgers, processor, new AsyncCallback.VoidCallback(){

                        public void processResult(int rc, String path, Object ctx) {
                            if (successRc != rc) {
                                LOG.error("Failed when processing range " + MSLedgerManagerFactory.rangeToString(startLedger, true, endLedger, true));
                                finalCb.processResult(failureRc, null, context);
                                return;
                            }
                            this.asyncProcessLedgers(cursor, processor, finalCb, context, successRc, failureRc);
                        }
                    }, context, successRc, failureRc);
                }
            };
            cursor.asyncReadEntries(this.maxEntriesPerScan, msCallback, null);
        }

        @Override
        public LedgerManager.LedgerRangeIterator getLedgerRanges(long zkOpTimeoutMs) {
            return new MSLedgerRangeIterator();
        }

        public static boolean isSpecialZnode(String znode) {
            return "available".equals(znode) || "cookies".equals(znode) || "LAYOUT".equals(znode) || "INSTANCEID".equals(znode) || "underreplication".equals(znode) || IDGEN_ZNODE.equals(znode);
        }

        class MSLedgerRangeIterator
        implements LedgerManager.LedgerRangeIterator {
            final CountDownLatch openCursorLatch = new CountDownLatch(1);
            MetastoreCursor cursor = null;

            MSLedgerRangeIterator() {
                MetastoreCallback<MetastoreCursor> openCursorCb = new MetastoreCallback<MetastoreCursor>(){

                    @Override
                    public void complete(int rc, MetastoreCursor newCursor, Object ctx) {
                        if (MSException.Code.OK.getCode() != rc) {
                            LOG.error("Error opening cursor for ledger range iterator {}", (Object)rc);
                        } else {
                            MSLedgerRangeIterator.this.cursor = newCursor;
                        }
                        MSLedgerRangeIterator.this.openCursorLatch.countDown();
                    }
                };
                MsLedgerManager.this.ledgerTable.openCursor(MetastoreTable.NON_FIELDS, openCursorCb, null);
            }

            @Override
            public boolean hasNext() throws IOException {
                try {
                    this.openCursorLatch.await();
                }
                catch (InterruptedException ie) {
                    LOG.error("Interrupted waiting for cursor to open", (Throwable)ie);
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted waiting to read range", ie);
                }
                if (this.cursor == null) {
                    throw new IOException("Failed to open ledger range cursor, check logs");
                }
                return this.cursor.hasMoreEntries();
            }

            @Override
            public LedgerManager.LedgerRange next() throws IOException {
                try {
                    TreeSet<Long> ledgerIds = new TreeSet<Long>();
                    Iterator<MetastoreTableItem> iter = this.cursor.readEntries(MsLedgerManager.this.maxEntriesPerScan);
                    while (iter.hasNext()) {
                        ledgerIds.add(MSLedgerManagerFactory.key2LedgerId(iter.next().getKey()));
                    }
                    return new LedgerManager.LedgerRange(ledgerIds);
                }
                catch (MSException mse) {
                    LOG.error("Exception occurred reading from metastore", (Throwable)mse);
                    throw new IOException("Couldn't read from metastore", mse);
                }
            }
        }

        protected class ReadLedgerMetadataTask
        implements Runnable {
            final long ledgerId;

            ReadLedgerMetadataTask(long ledgerId) {
                this.ledgerId = ledgerId;
            }

            @Override
            public void run() {
                if (null != MsLedgerManager.this.listeners.get(this.ledgerId)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Re-read ledger metadata for {}.", (Object)this.ledgerId);
                    }
                    MsLedgerManager.this.readLedgerMetadata(this.ledgerId).whenComplete((metadata, exception) -> this.handleMetadata((Versioned<LedgerMetadata>)metadata, (Throwable)exception));
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Ledger metadata listener for ledger {} is already removed.", (Object)this.ledgerId);
                }
            }

            private void handleMetadata(Versioned<LedgerMetadata> metadata, Throwable exception) {
                if (exception == null) {
                    Set listenerSet = (Set)MsLedgerManager.this.listeners.get(this.ledgerId);
                    if (null != listenerSet) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Ledger metadata is changed for {} : {}.", (Object)this.ledgerId, (Object)metadata.getValue());
                        }
                        MsLedgerManager.this.scheduler.submit(() -> {
                            Set set = listenerSet;
                            synchronized (set) {
                                for (BookkeeperInternalCallbacks.LedgerMetadataListener listener : listenerSet) {
                                    listener.onChanged(this.ledgerId, metadata);
                                }
                            }
                        });
                    }
                } else if (BKException.getExceptionCode(exception) == -25) {
                    Set listenerSet = (Set)MsLedgerManager.this.listeners.remove(this.ledgerId);
                    if (null != listenerSet && LOG.isDebugEnabled()) {
                        LOG.debug("Removed ledger metadata listener set on ledger {} as its ledger is deleted : {}", (Object)this.ledgerId, (Object)listenerSet.size());
                    }
                } else {
                    LOG.warn("Failed on read ledger metadata of ledger {}: {}", (Object)this.ledgerId, (Object)BKException.getExceptionCode(exception));
                    MsLedgerManager.this.scheduler.schedule(this, 200L, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    static class SyncResult<T> {
        T value;
        int rc;
        boolean finished = false;

        SyncResult() {
        }

        public synchronized void complete(int rc, T value) {
            this.rc = rc;
            this.value = value;
            this.finished = true;
            this.notify();
        }

        public synchronized void block() {
            try {
                while (!this.finished) {
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }

        public synchronized int getRetCode() {
            return this.rc;
        }

        public synchronized T getResult() {
            return this.value;
        }
    }
}

