/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.CompactableLedgerStorage;
import org.apache.bookkeeper.bookie.GarbageCollector;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanAndCompareGarbageCollector
implements GarbageCollector {
    static final Logger LOG = LoggerFactory.getLogger(ScanAndCompareGarbageCollector.class);
    private final LedgerManager ledgerManager;
    private final CompactableLedgerStorage ledgerStorage;
    private final ServerConfiguration conf;
    private final BookieId selfBookieAddress;
    private boolean enableGcOverReplicatedLedger;
    private final long gcOverReplicatedLedgerIntervalMillis;
    private long lastOverReplicatedLedgerGcTimeMillis;
    private final boolean verifyMetadataOnGc;
    private int activeLedgerCounter;
    private StatsLogger statsLogger;
    private final int maxConcurrentRequests;

    public ScanAndCompareGarbageCollector(LedgerManager ledgerManager, CompactableLedgerStorage ledgerStorage, ServerConfiguration conf, StatsLogger statsLogger) throws IOException {
        this.ledgerManager = ledgerManager;
        this.ledgerStorage = ledgerStorage;
        this.conf = conf;
        this.statsLogger = statsLogger;
        this.selfBookieAddress = BookieImpl.getBookieId(conf);
        this.gcOverReplicatedLedgerIntervalMillis = conf.getGcOverreplicatedLedgerWaitTimeMillis();
        this.lastOverReplicatedLedgerGcTimeMillis = System.currentTimeMillis();
        if (this.gcOverReplicatedLedgerIntervalMillis > 0L) {
            this.enableGcOverReplicatedLedger = true;
        }
        this.maxConcurrentRequests = conf.getGcOverreplicatedLedgerMaxConcurrentRequests();
        LOG.info("Over Replicated Ledger Deletion : enabled={}, interval={}, maxConcurrentRequests={}", new Object[]{this.enableGcOverReplicatedLedger, this.gcOverReplicatedLedgerIntervalMillis, this.maxConcurrentRequests});
        this.verifyMetadataOnGc = conf.getVerifyMetadataOnGC();
        this.activeLedgerCounter = 0;
    }

    public int getNumActiveLedgers() {
        return this.activeLedgerCounter;
    }

    @Override
    public void gc(GarbageCollector.GarbageCleaner garbageCleaner) {
        if (null == this.ledgerManager) {
            return;
        }
        try {
            boolean checkOverreplicatedLedgers;
            TreeSet bkActiveLedgers = Sets.newTreeSet(this.ledgerStorage.getActiveLedgersInRange(0L, Long.MAX_VALUE));
            this.activeLedgerCounter = bkActiveLedgers.size();
            long curTime = System.currentTimeMillis();
            boolean bl = checkOverreplicatedLedgers = this.enableGcOverReplicatedLedger && curTime - this.lastOverReplicatedLedgerGcTimeMillis > this.gcOverReplicatedLedgerIntervalMillis;
            if (checkOverreplicatedLedgers) {
                LOG.info("Start removing over-replicated ledgers. activeLedgerCounter={}", (Object)this.activeLedgerCounter);
                Set<Long> overReplicatedLedgers = this.removeOverReplicatedledgers(bkActiveLedgers, garbageCleaner);
                if (overReplicatedLedgers.isEmpty()) {
                    LOG.info("No over-replicated ledgers found.");
                } else {
                    LOG.info("Removed over-replicated ledgers: {}", overReplicatedLedgers);
                }
                this.lastOverReplicatedLedgerGcTimeMillis = System.currentTimeMillis();
            }
            long zkOpTimeoutMs = this.conf.getZkTimeout() * 2;
            LedgerManager.LedgerRangeIterator ledgerRangeIterator = this.ledgerManager.getLedgerRanges(zkOpTimeoutMs);
            Set<Object> ledgersInMetadata = null;
            long end = -1L;
            boolean done = false;
            AtomicBoolean isBookieInEnsembles = new AtomicBoolean(false);
            Versioned metadata = null;
            while (!done) {
                long start = end + 1L;
                if (ledgerRangeIterator.hasNext()) {
                    LedgerManager.LedgerRange lRange = ledgerRangeIterator.next();
                    ledgersInMetadata = lRange.getLedgers();
                    end = lRange.end();
                } else {
                    ledgersInMetadata = new TreeSet();
                    end = Long.MAX_VALUE;
                    done = true;
                }
                NavigableSet<Long> subBkActiveLedgers = bkActiveLedgers.subSet(start, true, end, true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Active in metadata {}, Active in bookie {}", ledgersInMetadata, subBkActiveLedgers);
                }
                for (Long bkLid : subBkActiveLedgers) {
                    if (ledgersInMetadata.contains(bkLid)) continue;
                    if (this.verifyMetadataOnGc) {
                        isBookieInEnsembles.set(false);
                        metadata = null;
                        int rc = 0;
                        try {
                            metadata = (Versioned)FutureUtils.result(this.ledgerManager.readLedgerMetadata(bkLid), (long)zkOpTimeoutMs, (TimeUnit)TimeUnit.MILLISECONDS);
                        }
                        catch (TimeoutException | BKException e) {
                            if (e instanceof BKException) {
                                rc = ((BKException)e).getCode();
                            }
                            LOG.warn("Time-out while fetching metadata for Ledger {} : {}.", (Object)bkLid, (Object)e.getMessage());
                            continue;
                        }
                        if (metadata != null && metadata.getValue() != null) {
                            ((LedgerMetadata)metadata.getValue()).getAllEnsembles().forEach((entryId, ensembles) -> {
                                if (ensembles != null && ensembles.contains(this.selfBookieAddress)) {
                                    isBookieInEnsembles.set(true);
                                }
                            });
                            if (isBookieInEnsembles.get()) {
                                continue;
                            }
                        } else if (rc != -25) {
                            LOG.warn("Ledger {} Missing in metadata list, but ledgerManager returned rc: {}.", (Object)bkLid, (Object)rc);
                            continue;
                        }
                    }
                    garbageCleaner.clean(bkLid);
                }
            }
        }
        catch (Throwable t) {
            LOG.warn("Exception when iterating over the metadata", t);
        }
    }

    /*
     * Exception decompiling
     */
    private Set<Long> removeOverReplicatedledgers(Set<Long> bkActiveledgers, GarbageCollector.GarbageCleaner garbageCleaner) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static MetadataBookieDriver instantiateMetadataDriver(ServerConfiguration conf, StatsLogger statsLogger) throws BookieException {
        try {
            String metadataServiceUriStr = conf.getMetadataServiceUri();
            MetadataBookieDriver driver = MetadataDrivers.getBookieDriver(URI.create(metadataServiceUriStr));
            driver.initialize(conf, statsLogger);
            return driver;
        }
        catch (MetadataException me) {
            throw new BookieException.MetadataStoreException("Failed to initialize metadata bookie driver", (Throwable)me);
        }
        catch (ConfigurationException e) {
            throw new BookieException.BookieIllegalOpException(e);
        }
    }

    private boolean isNotBookieIncludedInLedgerEnsembles(Versioned<LedgerMetadata> metadata) {
        if (!metadata.getValue().isClosed()) {
            return false;
        }
        NavigableMap<Long, ? extends List<BookieId>> ensembles = metadata.getValue().getAllEnsembles();
        for (List ensemble : ensembles.values()) {
            if (!ensemble.contains(this.selfBookieAddress)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$removeOverReplicatedledgers$1(Set overReplicatedLedgers, Long ledgerId, GarbageCollector.GarbageCleaner garbageCleaner, Semaphore semaphore, CountDownLatch latch, LedgerUnderreplicationManager lum, Versioned metadata, Throwable exception) {
        try {
            if (exception == null) {
                if (this.isNotBookieIncludedInLedgerEnsembles(metadata)) {
                    overReplicatedLedgers.add(ledgerId);
                    garbageCleaner.clean(ledgerId);
                }
            } else if (!(exception instanceof BKException.BKNoSuchLedgerExistsOnMetadataServerException)) {
                LOG.warn("Failed to get metadata for ledger {}. {}: {}", new Object[]{ledgerId, exception.getClass().getName(), exception.getMessage()});
            }
        }
        finally {
            semaphore.release();
            latch.countDown();
            try {
                lum.releaseUnderreplicatedLedger(ledgerId);
            }
            catch (Throwable t) {
                LOG.error("Exception when removing underreplicated lock for ledger {}", (Object)ledgerId, (Object)t);
            }
        }
    }
}

