/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum MemoryArea {
  COUNTERS((short) 0x1C, (String) "C"),
  TIMERS((short) 0x1D, (String) "T"),
  DIRECT_PERIPHERAL_ACCESS((short) 0x80, (String) "D"),
  INPUTS((short) 0x81, (String) "I"),
  OUTPUTS((short) 0x82, (String) "Q"),
  FLAGS_MARKERS((short) 0x83, (String) "M"),
  DATA_BLOCKS((short) 0x84, (String) "DB"),
  INSTANCE_DATA_BLOCKS((short) 0x85, (String) "DBI"),
  LOCAL_DATA((short) 0x86, (String) "LD");
  private static final Map<Short, MemoryArea> map;

  static {
    map = new HashMap<>();
    for (MemoryArea value : MemoryArea.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;
  private final String shortName;

  MemoryArea(short value, String shortName) {
    this.value = value;
    this.shortName = shortName;
  }

  public short getValue() {
    return value;
  }

  public String getShortName() {
    return shortName;
  }

  public static MemoryArea firstEnumForFieldShortName(String fieldValue) {
    for (MemoryArea _val : MemoryArea.values()) {
      if (_val.getShortName().equals(fieldValue)) {
        return _val;
      }
    }
    return null;
  }

  public static List<MemoryArea> enumsForFieldShortName(String fieldValue) {
    List<MemoryArea> _values = new ArrayList<>();
    for (MemoryArea _val : MemoryArea.values()) {
      if (_val.getShortName().equals(fieldValue)) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static MemoryArea enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
