/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.openprotocol.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OpenProtocolMessageLinkLevelPositiveAcknowledgeRev1
    extends OpenProtocolMessageLinkLevelPositiveAcknowledge implements Message {

  // Accessors for discriminator values.
  public Integer getRevision() {
    return (int) 1;
  }

  // Properties.
  protected final Mid midNumber;

  public OpenProtocolMessageLinkLevelPositiveAcknowledgeRev1(
      Integer midRevision,
      Short noAckFlag,
      Integer targetStationId,
      Integer targetSpindleId,
      Integer sequenceNumber,
      Short numberOfMessageParts,
      Short messagePartNumber,
      Mid midNumber) {
    super(
        midRevision,
        noAckFlag,
        targetStationId,
        targetSpindleId,
        sequenceNumber,
        numberOfMessageParts,
        messagePartNumber);
    this.midNumber = midNumber;
  }

  public Mid getMidNumber() {
    return midNumber;
  }

  @Override
  protected void serializeOpenProtocolMessageLinkLevelPositiveAcknowledgeChild(
      WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("OpenProtocolMessageLinkLevelPositiveAcknowledgeRev1");

    // Simple Field (midNumber)
    writeSimpleEnumField(
        "midNumber",
        "Mid",
        midNumber,
        writeEnum(Mid::getValue, Mid::name, writeUnsignedLong(writeBuffer, 32)),
        WithOption.WithEncoding("ASCII"));

    writeBuffer.popContext("OpenProtocolMessageLinkLevelPositiveAcknowledgeRev1");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    OpenProtocolMessageLinkLevelPositiveAcknowledgeRev1 _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (midNumber)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static OpenProtocolMessageLinkLevelPositiveAcknowledgeBuilder
      staticParseOpenProtocolMessageLinkLevelPositiveAcknowledgeBuilder(
          ReadBuffer readBuffer, Integer revision) throws ParseException {
    readBuffer.pullContext("OpenProtocolMessageLinkLevelPositiveAcknowledgeRev1");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Mid midNumber =
        readEnumField(
            "midNumber",
            "Mid",
            readEnum(Mid::enumForValue, readUnsignedLong(readBuffer, 32)),
            WithOption.WithEncoding("ASCII"));

    readBuffer.closeContext("OpenProtocolMessageLinkLevelPositiveAcknowledgeRev1");
    // Create the instance
    return new OpenProtocolMessageLinkLevelPositiveAcknowledgeRev1BuilderImpl(midNumber);
  }

  public static class OpenProtocolMessageLinkLevelPositiveAcknowledgeRev1BuilderImpl
      implements OpenProtocolMessageLinkLevelPositiveAcknowledge
          .OpenProtocolMessageLinkLevelPositiveAcknowledgeBuilder {
    private final Mid midNumber;

    public OpenProtocolMessageLinkLevelPositiveAcknowledgeRev1BuilderImpl(Mid midNumber) {
      this.midNumber = midNumber;
    }

    public OpenProtocolMessageLinkLevelPositiveAcknowledgeRev1 build(
        Integer midRevision,
        Short noAckFlag,
        Integer targetStationId,
        Integer targetSpindleId,
        Integer sequenceNumber,
        Short numberOfMessageParts,
        Short messagePartNumber) {
      OpenProtocolMessageLinkLevelPositiveAcknowledgeRev1
          openProtocolMessageLinkLevelPositiveAcknowledgeRev1 =
              new OpenProtocolMessageLinkLevelPositiveAcknowledgeRev1(
                  midRevision,
                  noAckFlag,
                  targetStationId,
                  targetSpindleId,
                  sequenceNumber,
                  numberOfMessageParts,
                  messagePartNumber,
                  midNumber);
      return openProtocolMessageLinkLevelPositiveAcknowledgeRev1;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpenProtocolMessageLinkLevelPositiveAcknowledgeRev1)) {
      return false;
    }
    OpenProtocolMessageLinkLevelPositiveAcknowledgeRev1 that =
        (OpenProtocolMessageLinkLevelPositiveAcknowledgeRev1) o;
    return (getMidNumber() == that.getMidNumber()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getMidNumber());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
