/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class TrustListDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 12556;
  }

  // Properties.
  protected final long specifiedLists;
  protected final List<PascalByteString> trustedCertificates;
  protected final List<PascalByteString> trustedCrls;
  protected final List<PascalByteString> issuerCertificates;
  protected final List<PascalByteString> issuerCrls;

  public TrustListDataType(
      long specifiedLists,
      List<PascalByteString> trustedCertificates,
      List<PascalByteString> trustedCrls,
      List<PascalByteString> issuerCertificates,
      List<PascalByteString> issuerCrls) {
    super();
    this.specifiedLists = specifiedLists;
    this.trustedCertificates = trustedCertificates;
    this.trustedCrls = trustedCrls;
    this.issuerCertificates = issuerCertificates;
    this.issuerCrls = issuerCrls;
  }

  public long getSpecifiedLists() {
    return specifiedLists;
  }

  public List<PascalByteString> getTrustedCertificates() {
    return trustedCertificates;
  }

  public List<PascalByteString> getTrustedCrls() {
    return trustedCrls;
  }

  public List<PascalByteString> getIssuerCertificates() {
    return issuerCertificates;
  }

  public List<PascalByteString> getIssuerCrls() {
    return issuerCrls;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("TrustListDataType");

    // Simple Field (specifiedLists)
    writeSimpleField("specifiedLists", specifiedLists, writeUnsignedLong(writeBuffer, 32));

    // Implicit Field (noOfTrustedCertificates) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfTrustedCertificates =
        (int) ((((getTrustedCertificates()) == (null)) ? -(1) : COUNT(getTrustedCertificates())));
    writeImplicitField(
        "noOfTrustedCertificates", noOfTrustedCertificates, writeSignedInt(writeBuffer, 32));

    // Array Field (trustedCertificates)
    writeComplexTypeArrayField("trustedCertificates", trustedCertificates, writeBuffer);

    // Implicit Field (noOfTrustedCrls) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfTrustedCrls = (int) ((((getTrustedCrls()) == (null)) ? -(1) : COUNT(getTrustedCrls())));
    writeImplicitField("noOfTrustedCrls", noOfTrustedCrls, writeSignedInt(writeBuffer, 32));

    // Array Field (trustedCrls)
    writeComplexTypeArrayField("trustedCrls", trustedCrls, writeBuffer);

    // Implicit Field (noOfIssuerCertificates) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfIssuerCertificates =
        (int) ((((getIssuerCertificates()) == (null)) ? -(1) : COUNT(getIssuerCertificates())));
    writeImplicitField(
        "noOfIssuerCertificates", noOfIssuerCertificates, writeSignedInt(writeBuffer, 32));

    // Array Field (issuerCertificates)
    writeComplexTypeArrayField("issuerCertificates", issuerCertificates, writeBuffer);

    // Implicit Field (noOfIssuerCrls) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfIssuerCrls = (int) ((((getIssuerCrls()) == (null)) ? -(1) : COUNT(getIssuerCrls())));
    writeImplicitField("noOfIssuerCrls", noOfIssuerCrls, writeSignedInt(writeBuffer, 32));

    // Array Field (issuerCrls)
    writeComplexTypeArrayField("issuerCrls", issuerCrls, writeBuffer);

    writeBuffer.popContext("TrustListDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    TrustListDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (specifiedLists)
    lengthInBits += 32;

    // Implicit Field (noOfTrustedCertificates)
    lengthInBits += 32;

    // Array field
    if (trustedCertificates != null) {
      int i = 0;
      for (PascalByteString element : trustedCertificates) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= trustedCertificates.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfTrustedCrls)
    lengthInBits += 32;

    // Array field
    if (trustedCrls != null) {
      int i = 0;
      for (PascalByteString element : trustedCrls) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= trustedCrls.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfIssuerCertificates)
    lengthInBits += 32;

    // Array field
    if (issuerCertificates != null) {
      int i = 0;
      for (PascalByteString element : issuerCertificates) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= issuerCertificates.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfIssuerCrls)
    lengthInBits += 32;

    // Array field
    if (issuerCrls != null) {
      int i = 0;
      for (PascalByteString element : issuerCrls) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= issuerCrls.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("TrustListDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long specifiedLists = readSimpleField("specifiedLists", readUnsignedLong(readBuffer, 32));

    int noOfTrustedCertificates =
        readImplicitField("noOfTrustedCertificates", readSignedInt(readBuffer, 32));

    List<PascalByteString> trustedCertificates =
        readCountArrayField(
            "trustedCertificates",
            readComplex(() -> PascalByteString.staticParse(readBuffer), readBuffer),
            noOfTrustedCertificates);

    int noOfTrustedCrls = readImplicitField("noOfTrustedCrls", readSignedInt(readBuffer, 32));

    List<PascalByteString> trustedCrls =
        readCountArrayField(
            "trustedCrls",
            readComplex(() -> PascalByteString.staticParse(readBuffer), readBuffer),
            noOfTrustedCrls);

    int noOfIssuerCertificates =
        readImplicitField("noOfIssuerCertificates", readSignedInt(readBuffer, 32));

    List<PascalByteString> issuerCertificates =
        readCountArrayField(
            "issuerCertificates",
            readComplex(() -> PascalByteString.staticParse(readBuffer), readBuffer),
            noOfIssuerCertificates);

    int noOfIssuerCrls = readImplicitField("noOfIssuerCrls", readSignedInt(readBuffer, 32));

    List<PascalByteString> issuerCrls =
        readCountArrayField(
            "issuerCrls",
            readComplex(() -> PascalByteString.staticParse(readBuffer), readBuffer),
            noOfIssuerCrls);

    readBuffer.closeContext("TrustListDataType");
    // Create the instance
    return new TrustListDataTypeBuilderImpl(
        specifiedLists, trustedCertificates, trustedCrls, issuerCertificates, issuerCrls);
  }

  public static class TrustListDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final long specifiedLists;
    private final List<PascalByteString> trustedCertificates;
    private final List<PascalByteString> trustedCrls;
    private final List<PascalByteString> issuerCertificates;
    private final List<PascalByteString> issuerCrls;

    public TrustListDataTypeBuilderImpl(
        long specifiedLists,
        List<PascalByteString> trustedCertificates,
        List<PascalByteString> trustedCrls,
        List<PascalByteString> issuerCertificates,
        List<PascalByteString> issuerCrls) {
      this.specifiedLists = specifiedLists;
      this.trustedCertificates = trustedCertificates;
      this.trustedCrls = trustedCrls;
      this.issuerCertificates = issuerCertificates;
      this.issuerCrls = issuerCrls;
    }

    public TrustListDataType build() {
      TrustListDataType trustListDataType =
          new TrustListDataType(
              specifiedLists, trustedCertificates, trustedCrls, issuerCertificates, issuerCrls);
      return trustListDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TrustListDataType)) {
      return false;
    }
    TrustListDataType that = (TrustListDataType) o;
    return (getSpecifiedLists() == that.getSpecifiedLists())
        && (getTrustedCertificates() == that.getTrustedCertificates())
        && (getTrustedCrls() == that.getTrustedCrls())
        && (getIssuerCertificates() == that.getIssuerCertificates())
        && (getIssuerCrls() == that.getIssuerCrls())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getSpecifiedLists(),
        getTrustedCertificates(),
        getTrustedCrls(),
        getIssuerCertificates(),
        getIssuerCrls());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
