/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class DtlsPubSubConnectionDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 18796;
  }

  // Properties.
  protected final PascalString clientCipherSuite;
  protected final List<PascalString> serverCipherSuites;
  protected final boolean zeroRTT;
  protected final NodeId certificateGroupId;
  protected final boolean verifyClientCertificate;

  public DtlsPubSubConnectionDataType(
      PascalString clientCipherSuite,
      List<PascalString> serverCipherSuites,
      boolean zeroRTT,
      NodeId certificateGroupId,
      boolean verifyClientCertificate) {
    super();
    this.clientCipherSuite = clientCipherSuite;
    this.serverCipherSuites = serverCipherSuites;
    this.zeroRTT = zeroRTT;
    this.certificateGroupId = certificateGroupId;
    this.verifyClientCertificate = verifyClientCertificate;
  }

  public PascalString getClientCipherSuite() {
    return clientCipherSuite;
  }

  public List<PascalString> getServerCipherSuites() {
    return serverCipherSuites;
  }

  public boolean getZeroRTT() {
    return zeroRTT;
  }

  public NodeId getCertificateGroupId() {
    return certificateGroupId;
  }

  public boolean getVerifyClientCertificate() {
    return verifyClientCertificate;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("DtlsPubSubConnectionDataType");

    // Simple Field (clientCipherSuite)
    writeSimpleField("clientCipherSuite", clientCipherSuite, writeComplex(writeBuffer));

    // Implicit Field (noOfServerCipherSuites) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfServerCipherSuites =
        (int) ((((getServerCipherSuites()) == (null)) ? -(1) : COUNT(getServerCipherSuites())));
    writeImplicitField(
        "noOfServerCipherSuites", noOfServerCipherSuites, writeSignedInt(writeBuffer, 32));

    // Array Field (serverCipherSuites)
    writeComplexTypeArrayField("serverCipherSuites", serverCipherSuites, writeBuffer);

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

    // Simple Field (zeroRTT)
    writeSimpleField("zeroRTT", zeroRTT, writeBoolean(writeBuffer));

    // Simple Field (certificateGroupId)
    writeSimpleField("certificateGroupId", certificateGroupId, writeComplex(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

    // Simple Field (verifyClientCertificate)
    writeSimpleField("verifyClientCertificate", verifyClientCertificate, writeBoolean(writeBuffer));

    writeBuffer.popContext("DtlsPubSubConnectionDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    DtlsPubSubConnectionDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (clientCipherSuite)
    lengthInBits += clientCipherSuite.getLengthInBits();

    // Implicit Field (noOfServerCipherSuites)
    lengthInBits += 32;

    // Array field
    if (serverCipherSuites != null) {
      int i = 0;
      for (PascalString element : serverCipherSuites) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= serverCipherSuites.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (zeroRTT)
    lengthInBits += 1;

    // Simple field (certificateGroupId)
    lengthInBits += certificateGroupId.getLengthInBits();

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (verifyClientCertificate)
    lengthInBits += 1;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("DtlsPubSubConnectionDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString clientCipherSuite =
        readSimpleField(
            "clientCipherSuite",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfServerCipherSuites =
        readImplicitField("noOfServerCipherSuites", readSignedInt(readBuffer, 32));

    List<PascalString> serverCipherSuites =
        readCountArrayField(
            "serverCipherSuites",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer),
            noOfServerCipherSuites);

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

    boolean zeroRTT = readSimpleField("zeroRTT", readBoolean(readBuffer));

    NodeId certificateGroupId =
        readSimpleField(
            "certificateGroupId", readComplex(() -> NodeId.staticParse(readBuffer), readBuffer));

    Byte reservedField1 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

    boolean verifyClientCertificate =
        readSimpleField("verifyClientCertificate", readBoolean(readBuffer));

    readBuffer.closeContext("DtlsPubSubConnectionDataType");
    // Create the instance
    return new DtlsPubSubConnectionDataTypeBuilderImpl(
        clientCipherSuite,
        serverCipherSuites,
        zeroRTT,
        certificateGroupId,
        verifyClientCertificate);
  }

  public static class DtlsPubSubConnectionDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString clientCipherSuite;
    private final List<PascalString> serverCipherSuites;
    private final boolean zeroRTT;
    private final NodeId certificateGroupId;
    private final boolean verifyClientCertificate;

    public DtlsPubSubConnectionDataTypeBuilderImpl(
        PascalString clientCipherSuite,
        List<PascalString> serverCipherSuites,
        boolean zeroRTT,
        NodeId certificateGroupId,
        boolean verifyClientCertificate) {
      this.clientCipherSuite = clientCipherSuite;
      this.serverCipherSuites = serverCipherSuites;
      this.zeroRTT = zeroRTT;
      this.certificateGroupId = certificateGroupId;
      this.verifyClientCertificate = verifyClientCertificate;
    }

    public DtlsPubSubConnectionDataType build() {
      DtlsPubSubConnectionDataType dtlsPubSubConnectionDataType =
          new DtlsPubSubConnectionDataType(
              clientCipherSuite,
              serverCipherSuites,
              zeroRTT,
              certificateGroupId,
              verifyClientCertificate);
      return dtlsPubSubConnectionDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof DtlsPubSubConnectionDataType)) {
      return false;
    }
    DtlsPubSubConnectionDataType that = (DtlsPubSubConnectionDataType) o;
    return (getClientCipherSuite() == that.getClientCipherSuite())
        && (getServerCipherSuites() == that.getServerCipherSuites())
        && (getZeroRTT() == that.getZeroRTT())
        && (getCertificateGroupId() == that.getCertificateGroupId())
        && (getVerifyClientCertificate() == that.getVerifyClientCertificate())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getClientCipherSuite(),
        getServerCipherSuites(),
        getZeroRTT(),
        getCertificateGroupId(),
        getVerifyClientCertificate());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
