/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.iec608705104.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class InformationObject implements Message {

  // Abstract accessors for discriminator values.
  public abstract Byte getNumTimeByte();

  // Properties.
  protected final int address;

  public InformationObject(int address) {
    super();
    this.address = address;
  }

  public int getAddress() {
    return address;
  }

  protected abstract void serializeInformationObjectChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("InformationObject");

    // Simple Field (address)
    writeSimpleField(
        "address",
        address,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Switch field (Serialize the sub-type)
    serializeInformationObjectChild(writeBuffer);

    writeBuffer.popContext("InformationObject");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    InformationObject _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (address)
    lengthInBits += 24;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static InformationObject staticParse(
      ReadBuffer readBuffer, TypeIdentification typeIdentification, Byte numTimeByte)
      throws ParseException {
    readBuffer.pullContext("InformationObject");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int address =
        readSimpleField(
            "address",
            readUnsignedInt(readBuffer, 24),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    InformationObjectBuilder builder = null;
    if (EvaluationHelper.equals(numTimeByte, (byte) 0)) {
      builder =
          InformationObjectWithoutTime.staticParseInformationObjectBuilder(
              readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(numTimeByte, (byte) 3)) {
      builder =
          InformationObjectWithTreeByteTime.staticParseInformationObjectBuilder(
              readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(numTimeByte, (byte) 7)) {
      builder =
          InformationObjectWithSevenByteTime.staticParseInformationObjectBuilder(
              readBuffer, typeIdentification, numTimeByte);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "numTimeByte="
              + numTimeByte
              + "]");
    }

    readBuffer.closeContext("InformationObject");
    // Create the instance
    InformationObject _informationObject = builder.build(address);
    return _informationObject;
  }

  public interface InformationObjectBuilder {
    InformationObject build(int address);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof InformationObject)) {
      return false;
    }
    InformationObject that = (InformationObject) o;
    return (getAddress() == that.getAddress()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getAddress());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
