/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.firmata.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class FirmataCommandSetDigitalPinValue extends FirmataCommand implements Message {

  // Accessors for discriminator values.
  public Byte getCommandCode() {
    return (byte) 0x5;
  }

  // Properties.
  protected final short pin;
  protected final boolean on;

  public FirmataCommandSetDigitalPinValue(short pin, boolean on) {
    super();
    this.pin = pin;
    this.on = on;
  }

  public short getPin() {
    return pin;
  }

  public boolean getOn() {
    return on;
  }

  @Override
  protected void serializeFirmataCommandChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("FirmataCommandSetDigitalPinValue");

    // Simple Field (pin)
    writeSimpleField("pin", pin, writeUnsignedShort(writeBuffer, 8));

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

    // Simple Field (on)
    writeSimpleField("on", on, writeBoolean(writeBuffer));

    writeBuffer.popContext("FirmataCommandSetDigitalPinValue");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    FirmataCommandSetDigitalPinValue _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (pin)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (on)
    lengthInBits += 1;

    return lengthInBits;
  }

  public static FirmataCommandBuilder staticParseFirmataCommandBuilder(
      ReadBuffer readBuffer, Boolean response) throws ParseException {
    readBuffer.pullContext("FirmataCommandSetDigitalPinValue");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short pin = readSimpleField("pin", readUnsignedShort(readBuffer, 8));

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

    boolean on = readSimpleField("on", readBoolean(readBuffer));

    readBuffer.closeContext("FirmataCommandSetDigitalPinValue");
    // Create the instance
    return new FirmataCommandSetDigitalPinValueBuilderImpl(pin, on);
  }

  public static class FirmataCommandSetDigitalPinValueBuilderImpl
      implements FirmataCommand.FirmataCommandBuilder {
    private final short pin;
    private final boolean on;

    public FirmataCommandSetDigitalPinValueBuilderImpl(short pin, boolean on) {
      this.pin = pin;
      this.on = on;
    }

    public FirmataCommandSetDigitalPinValue build() {
      FirmataCommandSetDigitalPinValue firmataCommandSetDigitalPinValue =
          new FirmataCommandSetDigitalPinValue(pin, on);
      return firmataCommandSetDigitalPinValue;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof FirmataCommandSetDigitalPinValue)) {
      return false;
    }
    FirmataCommandSetDigitalPinValue that = (FirmataCommandSetDigitalPinValue) o;
    return (getPin() == that.getPin()) && (getOn() == that.getOn()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getPin(), getOn());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
