/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * ctrlX CORE - Data Layer API
 * This is the base API for the ctrlX Data Layer access on ctrlX CORE devices <ul> <li>Click 'Authorize' to open the 'Available authorizations' dialog.</li> <li>Enter 'username' and 'password'. The 'Client credentials location' selector together with the 'client_id' and 'client_secret' fields as well as the 'Bearer' section can be ignored.</li> <li>Click 'Authorize' and then 'Close' to close the 'Available authorizations' dialog.</li> <li>Try out those GET, PUT, ... operations you're interested in.</li> </ul>
 *
 * The version of the OpenAPI document: 2.1.0
 * Contact: support@boschrexroth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;

/**
 * CommDatalayerServerSettings
 */
@JsonPropertyOrder({
  CommDatalayerServerSettings.JSON_PROPERTY_SERVER_IDLE_PING_TIMEOUT,
  CommDatalayerServerSettings.JSON_PROPERTY_SERVER_WAIT_RESPONSE_TIMEOUT
})
@JsonTypeName("comm_datalayer_ServerSettings")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-18T13:34:36.056861+01:00[Europe/Berlin]")
public class CommDatalayerServerSettings {
  public static final String JSON_PROPERTY_SERVER_IDLE_PING_TIMEOUT = "serverIdlePingTimeout";
  private Integer serverIdlePingTimeout = 30000;

  public static final String JSON_PROPERTY_SERVER_WAIT_RESPONSE_TIMEOUT = "serverWaitResponseTimeout";
  private Integer serverWaitResponseTimeout = 3000;

  public CommDatalayerServerSettings() {
  }

  public CommDatalayerServerSettings serverIdlePingTimeout(Integer serverIdlePingTimeout) {
    
    this.serverIdlePingTimeout = serverIdlePingTimeout;
    return this;
  }

   /**
   * after this time send a ping to not used provider is send to test if provider is still alive
   * minimum: 0
   * maximum: 4294967295
   * @return serverIdlePingTimeout
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SERVER_IDLE_PING_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getServerIdlePingTimeout() {
    return serverIdlePingTimeout;
  }


  @JsonProperty(JSON_PROPERTY_SERVER_IDLE_PING_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setServerIdlePingTimeout(Integer serverIdlePingTimeout) {
    this.serverIdlePingTimeout = serverIdlePingTimeout;
  }


  public CommDatalayerServerSettings serverWaitResponseTimeout(Integer serverWaitResponseTimeout) {
    
    this.serverWaitResponseTimeout = serverWaitResponseTimeout;
    return this;
  }

   /**
   * after this time a response from provider is expected - if there is no answer a provider is assumed to be dead --&gt; kick provider out of routing
   * maximum: 4294967295
   * @return serverWaitResponseTimeout
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SERVER_WAIT_RESPONSE_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getServerWaitResponseTimeout() {
    return serverWaitResponseTimeout;
  }


  @JsonProperty(JSON_PROPERTY_SERVER_WAIT_RESPONSE_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setServerWaitResponseTimeout(Integer serverWaitResponseTimeout) {
    this.serverWaitResponseTimeout = serverWaitResponseTimeout;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CommDatalayerServerSettings commDatalayerServerSettings = (CommDatalayerServerSettings) o;
    return Objects.equals(this.serverIdlePingTimeout, commDatalayerServerSettings.serverIdlePingTimeout) &&
        Objects.equals(this.serverWaitResponseTimeout, commDatalayerServerSettings.serverWaitResponseTimeout);
  }

  @Override
  public int hashCode() {
    return Objects.hash(serverIdlePingTimeout, serverWaitResponseTimeout);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CommDatalayerServerSettings {\n");
    sb.append("    serverIdlePingTimeout: ").append(toIndentedString(serverIdlePingTimeout)).append("\n");
    sb.append("    serverWaitResponseTimeout: ").append(toIndentedString(serverWaitResponseTimeout)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `serverIdlePingTimeout` to the URL query string
    if (getServerIdlePingTimeout() != null) {
      try {
        joiner.add(String.format("%sserverIdlePingTimeout%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getServerIdlePingTimeout()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `serverWaitResponseTimeout` to the URL query string
    if (getServerWaitResponseTimeout() != null) {
      try {
        joiner.add(String.format("%sserverWaitResponseTimeout%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getServerWaitResponseTimeout()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

