/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry
    implements Message {

  // Properties.
  protected final BACnetContextTagObjectIdentifier monitoredObjectIdentifier;
  protected final
  BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferences
      listOfCovReferences;

  public BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry(
      BACnetContextTagObjectIdentifier monitoredObjectIdentifier,
      BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferences
          listOfCovReferences) {
    super();
    this.monitoredObjectIdentifier = monitoredObjectIdentifier;
    this.listOfCovReferences = listOfCovReferences;
  }

  public BACnetContextTagObjectIdentifier getMonitoredObjectIdentifier() {
    return monitoredObjectIdentifier;
  }

  public BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferences
      getListOfCovReferences() {
    return listOfCovReferences;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry");

    // Simple Field (monitoredObjectIdentifier)
    writeSimpleField(
        "monitoredObjectIdentifier", monitoredObjectIdentifier, writeComplex(writeBuffer));

    // Simple Field (listOfCovReferences)
    writeSimpleField("listOfCovReferences", listOfCovReferences, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (monitoredObjectIdentifier)
    lengthInBits += monitoredObjectIdentifier.getLengthInBits();

    // Simple field (listOfCovReferences)
    lengthInBits += listOfCovReferences.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry staticParse(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetContextTagObjectIdentifier monitoredObjectIdentifier =
        readSimpleField(
            "monitoredObjectIdentifier",
            readComplex(
                () ->
                    (BACnetContextTagObjectIdentifier)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (0),
                            (BACnetDataType) (BACnetDataType.BACNET_OBJECT_IDENTIFIER)),
                readBuffer));

    BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferences
        listOfCovReferences =
            readSimpleField(
                "listOfCovReferences",
                readComplex(
                    () ->
                        BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferences
                            .staticParse(readBuffer, (short) (1)),
                    readBuffer));

    readBuffer.closeContext("BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry");
    // Create the instance
    BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry
        _bACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry;
    _bACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry =
        new BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry(
            monitoredObjectIdentifier, listOfCovReferences);
    return _bACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry)) {
      return false;
    }
    BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry that =
        (BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry) o;
    return (getMonitoredObjectIdentifier() == that.getMonitoredObjectIdentifier())
        && (getListOfCovReferences() == that.getListOfCovReferences())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getMonitoredObjectIdentifier(), getListOfCovReferences());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
