/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class APDUSegmentAck extends APDU implements Message {

  // Accessors for discriminator values.
  public ApduType getApduType() {
    return ApduType.SEGMENT_ACK_PDU;
  }

  // Properties.
  protected final boolean negativeAck;
  protected final boolean server;
  protected final short originalInvokeId;
  protected final short sequenceNumber;
  protected final short actualWindowSize;

  // Arguments.
  protected final Integer apduLength;
  // Reserved Fields
  private Byte reservedField0;

  public APDUSegmentAck(
      boolean negativeAck,
      boolean server,
      short originalInvokeId,
      short sequenceNumber,
      short actualWindowSize,
      Integer apduLength) {
    super(apduLength);
    this.negativeAck = negativeAck;
    this.server = server;
    this.originalInvokeId = originalInvokeId;
    this.sequenceNumber = sequenceNumber;
    this.actualWindowSize = actualWindowSize;
    this.apduLength = apduLength;
  }

  public boolean getNegativeAck() {
    return negativeAck;
  }

  public boolean getServer() {
    return server;
  }

  public short getOriginalInvokeId() {
    return originalInvokeId;
  }

  public short getSequenceNumber() {
    return sequenceNumber;
  }

  public short getActualWindowSize() {
    return actualWindowSize;
  }

  @Override
  protected void serializeAPDUChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("APDUSegmentAck");

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (byte) 0x00,
        writeUnsignedByte(writeBuffer, 2));

    // Simple Field (negativeAck)
    writeSimpleField("negativeAck", negativeAck, writeBoolean(writeBuffer));

    // Simple Field (server)
    writeSimpleField("server", server, writeBoolean(writeBuffer));

    // Simple Field (originalInvokeId)
    writeSimpleField("originalInvokeId", originalInvokeId, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (sequenceNumber)
    writeSimpleField("sequenceNumber", sequenceNumber, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (actualWindowSize)
    writeSimpleField("actualWindowSize", actualWindowSize, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("APDUSegmentAck");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    APDUSegmentAck _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Reserved Field (reserved)
    lengthInBits += 2;

    // Simple field (negativeAck)
    lengthInBits += 1;

    // Simple field (server)
    lengthInBits += 1;

    // Simple field (originalInvokeId)
    lengthInBits += 8;

    // Simple field (sequenceNumber)
    lengthInBits += 8;

    // Simple field (actualWindowSize)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static APDUBuilder staticParseAPDUBuilder(ReadBuffer readBuffer, Integer apduLength)
      throws ParseException {
    readBuffer.pullContext("APDUSegmentAck");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 2), (byte) 0x00);

    boolean negativeAck = readSimpleField("negativeAck", readBoolean(readBuffer));

    boolean server = readSimpleField("server", readBoolean(readBuffer));

    short originalInvokeId = readSimpleField("originalInvokeId", readUnsignedShort(readBuffer, 8));

    short sequenceNumber = readSimpleField("sequenceNumber", readUnsignedShort(readBuffer, 8));

    short actualWindowSize = readSimpleField("actualWindowSize", readUnsignedShort(readBuffer, 8));

    readBuffer.closeContext("APDUSegmentAck");
    // Create the instance
    return new APDUSegmentAckBuilderImpl(
        negativeAck,
        server,
        originalInvokeId,
        sequenceNumber,
        actualWindowSize,
        apduLength,
        reservedField0);
  }

  public static class APDUSegmentAckBuilderImpl implements APDU.APDUBuilder {
    private final boolean negativeAck;
    private final boolean server;
    private final short originalInvokeId;
    private final short sequenceNumber;
    private final short actualWindowSize;
    private final Integer apduLength;
    private final Byte reservedField0;

    public APDUSegmentAckBuilderImpl(
        boolean negativeAck,
        boolean server,
        short originalInvokeId,
        short sequenceNumber,
        short actualWindowSize,
        Integer apduLength,
        Byte reservedField0) {
      this.negativeAck = negativeAck;
      this.server = server;
      this.originalInvokeId = originalInvokeId;
      this.sequenceNumber = sequenceNumber;
      this.actualWindowSize = actualWindowSize;
      this.apduLength = apduLength;
      this.reservedField0 = reservedField0;
    }

    public APDUSegmentAck build(Integer apduLength) {

      APDUSegmentAck aPDUSegmentAck =
          new APDUSegmentAck(
              negativeAck, server, originalInvokeId, sequenceNumber, actualWindowSize, apduLength);
      aPDUSegmentAck.reservedField0 = reservedField0;
      return aPDUSegmentAck;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof APDUSegmentAck)) {
      return false;
    }
    APDUSegmentAck that = (APDUSegmentAck) o;
    return (getNegativeAck() == that.getNegativeAck())
        && (getServer() == that.getServer())
        && (getOriginalInvokeId() == that.getOriginalInvokeId())
        && (getSequenceNumber() == that.getSequenceNumber())
        && (getActualWindowSize() == that.getActualWindowSize())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getNegativeAck(),
        getServer(),
        getOriginalInvokeId(),
        getSequenceNumber(),
        getActualWindowSize());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
