/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// MonitoredItemModifyRequest is the corresponding interface of MonitoredItemModifyRequest
type MonitoredItemModifyRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetMonitoredItemId returns MonitoredItemId (property field)
	GetMonitoredItemId() uint32
	// GetRequestedParameters returns RequestedParameters (property field)
	GetRequestedParameters() MonitoringParameters
	// IsMonitoredItemModifyRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsMonitoredItemModifyRequest()
	// CreateBuilder creates a MonitoredItemModifyRequestBuilder
	CreateMonitoredItemModifyRequestBuilder() MonitoredItemModifyRequestBuilder
}

// _MonitoredItemModifyRequest is the data-structure of this message
type _MonitoredItemModifyRequest struct {
	ExtensionObjectDefinitionContract
	MonitoredItemId     uint32
	RequestedParameters MonitoringParameters
}

var _ MonitoredItemModifyRequest = (*_MonitoredItemModifyRequest)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_MonitoredItemModifyRequest)(nil)

// NewMonitoredItemModifyRequest factory function for _MonitoredItemModifyRequest
func NewMonitoredItemModifyRequest(monitoredItemId uint32, requestedParameters MonitoringParameters) *_MonitoredItemModifyRequest {
	if requestedParameters == nil {
		panic("requestedParameters of type MonitoringParameters for MonitoredItemModifyRequest must not be nil")
	}
	_result := &_MonitoredItemModifyRequest{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		MonitoredItemId:                   monitoredItemId,
		RequestedParameters:               requestedParameters,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// MonitoredItemModifyRequestBuilder is a builder for MonitoredItemModifyRequest
type MonitoredItemModifyRequestBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(monitoredItemId uint32, requestedParameters MonitoringParameters) MonitoredItemModifyRequestBuilder
	// WithMonitoredItemId adds MonitoredItemId (property field)
	WithMonitoredItemId(uint32) MonitoredItemModifyRequestBuilder
	// WithRequestedParameters adds RequestedParameters (property field)
	WithRequestedParameters(MonitoringParameters) MonitoredItemModifyRequestBuilder
	// WithRequestedParametersBuilder adds RequestedParameters (property field) which is build by the builder
	WithRequestedParametersBuilder(func(MonitoringParametersBuilder) MonitoringParametersBuilder) MonitoredItemModifyRequestBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the MonitoredItemModifyRequest or returns an error if something is wrong
	Build() (MonitoredItemModifyRequest, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() MonitoredItemModifyRequest
}

// NewMonitoredItemModifyRequestBuilder() creates a MonitoredItemModifyRequestBuilder
func NewMonitoredItemModifyRequestBuilder() MonitoredItemModifyRequestBuilder {
	return &_MonitoredItemModifyRequestBuilder{_MonitoredItemModifyRequest: new(_MonitoredItemModifyRequest)}
}

type _MonitoredItemModifyRequestBuilder struct {
	*_MonitoredItemModifyRequest

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (MonitoredItemModifyRequestBuilder) = (*_MonitoredItemModifyRequestBuilder)(nil)

func (b *_MonitoredItemModifyRequestBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._MonitoredItemModifyRequest
}

func (b *_MonitoredItemModifyRequestBuilder) WithMandatoryFields(monitoredItemId uint32, requestedParameters MonitoringParameters) MonitoredItemModifyRequestBuilder {
	return b.WithMonitoredItemId(monitoredItemId).WithRequestedParameters(requestedParameters)
}

func (b *_MonitoredItemModifyRequestBuilder) WithMonitoredItemId(monitoredItemId uint32) MonitoredItemModifyRequestBuilder {
	b.MonitoredItemId = monitoredItemId
	return b
}

func (b *_MonitoredItemModifyRequestBuilder) WithRequestedParameters(requestedParameters MonitoringParameters) MonitoredItemModifyRequestBuilder {
	b.RequestedParameters = requestedParameters
	return b
}

func (b *_MonitoredItemModifyRequestBuilder) WithRequestedParametersBuilder(builderSupplier func(MonitoringParametersBuilder) MonitoringParametersBuilder) MonitoredItemModifyRequestBuilder {
	builder := builderSupplier(b.RequestedParameters.CreateMonitoringParametersBuilder())
	var err error
	b.RequestedParameters, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "MonitoringParametersBuilder failed"))
	}
	return b
}

func (b *_MonitoredItemModifyRequestBuilder) Build() (MonitoredItemModifyRequest, error) {
	if b.RequestedParameters == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'requestedParameters' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._MonitoredItemModifyRequest.deepCopy(), nil
}

func (b *_MonitoredItemModifyRequestBuilder) MustBuild() MonitoredItemModifyRequest {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_MonitoredItemModifyRequestBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_MonitoredItemModifyRequestBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_MonitoredItemModifyRequestBuilder) DeepCopy() any {
	_copy := b.CreateMonitoredItemModifyRequestBuilder().(*_MonitoredItemModifyRequestBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateMonitoredItemModifyRequestBuilder creates a MonitoredItemModifyRequestBuilder
func (b *_MonitoredItemModifyRequest) CreateMonitoredItemModifyRequestBuilder() MonitoredItemModifyRequestBuilder {
	if b == nil {
		return NewMonitoredItemModifyRequestBuilder()
	}
	return &_MonitoredItemModifyRequestBuilder{_MonitoredItemModifyRequest: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_MonitoredItemModifyRequest) GetExtensionId() int32 {
	return int32(757)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_MonitoredItemModifyRequest) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_MonitoredItemModifyRequest) GetMonitoredItemId() uint32 {
	return m.MonitoredItemId
}

func (m *_MonitoredItemModifyRequest) GetRequestedParameters() MonitoringParameters {
	return m.RequestedParameters
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastMonitoredItemModifyRequest(structType any) MonitoredItemModifyRequest {
	if casted, ok := structType.(MonitoredItemModifyRequest); ok {
		return casted
	}
	if casted, ok := structType.(*MonitoredItemModifyRequest); ok {
		return *casted
	}
	return nil
}

func (m *_MonitoredItemModifyRequest) GetTypeName() string {
	return "MonitoredItemModifyRequest"
}

func (m *_MonitoredItemModifyRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (monitoredItemId)
	lengthInBits += 32

	// Simple field (requestedParameters)
	lengthInBits += m.RequestedParameters.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_MonitoredItemModifyRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_MonitoredItemModifyRequest) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__monitoredItemModifyRequest MonitoredItemModifyRequest, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("MonitoredItemModifyRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for MonitoredItemModifyRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	monitoredItemId, err := ReadSimpleField(ctx, "monitoredItemId", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'monitoredItemId' field"))
	}
	m.MonitoredItemId = monitoredItemId

	requestedParameters, err := ReadSimpleField[MonitoringParameters](ctx, "requestedParameters", ReadComplex[MonitoringParameters](ExtensionObjectDefinitionParseWithBufferProducer[MonitoringParameters]((int32)(int32(742))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'requestedParameters' field"))
	}
	m.RequestedParameters = requestedParameters

	if closeErr := readBuffer.CloseContext("MonitoredItemModifyRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for MonitoredItemModifyRequest")
	}

	return m, nil
}

func (m *_MonitoredItemModifyRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_MonitoredItemModifyRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("MonitoredItemModifyRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for MonitoredItemModifyRequest")
		}

		if err := WriteSimpleField[uint32](ctx, "monitoredItemId", m.GetMonitoredItemId(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'monitoredItemId' field")
		}

		if err := WriteSimpleField[MonitoringParameters](ctx, "requestedParameters", m.GetRequestedParameters(), WriteComplex[MonitoringParameters](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'requestedParameters' field")
		}

		if popErr := writeBuffer.PopContext("MonitoredItemModifyRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for MonitoredItemModifyRequest")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_MonitoredItemModifyRequest) IsMonitoredItemModifyRequest() {}

func (m *_MonitoredItemModifyRequest) DeepCopy() any {
	return m.deepCopy()
}

func (m *_MonitoredItemModifyRequest) deepCopy() *_MonitoredItemModifyRequest {
	if m == nil {
		return nil
	}
	_MonitoredItemModifyRequestCopy := &_MonitoredItemModifyRequest{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.MonitoredItemId,
		utils.DeepCopy[MonitoringParameters](m.RequestedParameters),
	}
	_MonitoredItemModifyRequestCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _MonitoredItemModifyRequestCopy
}

func (m *_MonitoredItemModifyRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
