/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataRestart is the corresponding interface of ApduDataRestart
type ApduDataRestart interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduData
	// IsApduDataRestart is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataRestart()
	// CreateBuilder creates a ApduDataRestartBuilder
	CreateApduDataRestartBuilder() ApduDataRestartBuilder
}

// _ApduDataRestart is the data-structure of this message
type _ApduDataRestart struct {
	ApduDataContract
}

var _ ApduDataRestart = (*_ApduDataRestart)(nil)
var _ ApduDataRequirements = (*_ApduDataRestart)(nil)

// NewApduDataRestart factory function for _ApduDataRestart
func NewApduDataRestart(dataLength uint8) *_ApduDataRestart {
	_result := &_ApduDataRestart{
		ApduDataContract: NewApduData(dataLength),
	}
	_result.ApduDataContract.(*_ApduData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataRestartBuilder is a builder for ApduDataRestart
type ApduDataRestartBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ApduDataRestartBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataBuilder
	// Build builds the ApduDataRestart or returns an error if something is wrong
	Build() (ApduDataRestart, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataRestart
}

// NewApduDataRestartBuilder() creates a ApduDataRestartBuilder
func NewApduDataRestartBuilder() ApduDataRestartBuilder {
	return &_ApduDataRestartBuilder{_ApduDataRestart: new(_ApduDataRestart)}
}

type _ApduDataRestartBuilder struct {
	*_ApduDataRestart

	parentBuilder *_ApduDataBuilder

	collectedErr []error
}

var _ (ApduDataRestartBuilder) = (*_ApduDataRestartBuilder)(nil)

func (b *_ApduDataRestartBuilder) setParent(contract ApduDataContract) {
	b.ApduDataContract = contract
	contract.(*_ApduData)._SubType = b._ApduDataRestart
}

func (b *_ApduDataRestartBuilder) WithMandatoryFields() ApduDataRestartBuilder {
	return b
}

func (b *_ApduDataRestartBuilder) Build() (ApduDataRestart, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ApduDataRestart.deepCopy(), nil
}

func (b *_ApduDataRestartBuilder) MustBuild() ApduDataRestart {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataRestartBuilder) Done() ApduDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataBuilder().(*_ApduDataBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataRestartBuilder) buildForApduData() (ApduData, error) {
	return b.Build()
}

func (b *_ApduDataRestartBuilder) DeepCopy() any {
	_copy := b.CreateApduDataRestartBuilder().(*_ApduDataRestartBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateApduDataRestartBuilder creates a ApduDataRestartBuilder
func (b *_ApduDataRestart) CreateApduDataRestartBuilder() ApduDataRestartBuilder {
	if b == nil {
		return NewApduDataRestartBuilder()
	}
	return &_ApduDataRestartBuilder{_ApduDataRestart: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataRestart) GetApciType() uint8 {
	return 0xE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataRestart) GetParent() ApduDataContract {
	return m.ApduDataContract
}

// Deprecated: use the interface for direct cast
func CastApduDataRestart(structType any) ApduDataRestart {
	if casted, ok := structType.(ApduDataRestart); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataRestart); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataRestart) GetTypeName() string {
	return "ApduDataRestart"
}

func (m *_ApduDataRestart) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataContract.(*_ApduData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_ApduDataRestart) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataRestart) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduData, dataLength uint8) (__apduDataRestart ApduDataRestart, err error) {
	m.ApduDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataRestart"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataRestart")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApduDataRestart"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataRestart")
	}

	return m, nil
}

func (m *_ApduDataRestart) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataRestart) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataRestart"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataRestart")
		}

		if popErr := writeBuffer.PopContext("ApduDataRestart"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataRestart")
		}
		return nil
	}
	return m.ApduDataContract.(*_ApduData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataRestart) IsApduDataRestart() {}

func (m *_ApduDataRestart) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataRestart) deepCopy() *_ApduDataRestart {
	if m == nil {
		return nil
	}
	_ApduDataRestartCopy := &_ApduDataRestart{
		m.ApduDataContract.(*_ApduData).deepCopy(),
	}
	_ApduDataRestartCopy.ApduDataContract.(*_ApduData)._SubType = m
	return _ApduDataRestartCopy
}

func (m *_ApduDataRestart) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
