/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// AccessControlCommandTypeContainer is an enum
type AccessControlCommandTypeContainer uint8

type IAccessControlCommandTypeContainer interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	NumBytes() uint8
	CommandType() AccessControlCommandType
	Category() AccessControlCategory
}

const (
	AccessControlCommandTypeContainer_AccessControlCommandCloseAccessPoint             AccessControlCommandTypeContainer = 0x02
	AccessControlCommandTypeContainer_AccessControlCommandLockAccessPoint              AccessControlCommandTypeContainer = 0x0A
	AccessControlCommandTypeContainer_AccessControlCommandAccessPointLeftOpen          AccessControlCommandTypeContainer = 0x12
	AccessControlCommandTypeContainer_AccessControlCommandAccessPointForcedOpen        AccessControlCommandTypeContainer = 0x1A
	AccessControlCommandTypeContainer_AccessControlCommandAccessPointClosed            AccessControlCommandTypeContainer = 0x22
	AccessControlCommandTypeContainer_AccessControlCommandRequestToExit                AccessControlCommandTypeContainer = 0x32
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_0Bytes    AccessControlCommandTypeContainer = 0xA0
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_1Bytes    AccessControlCommandTypeContainer = 0xA1
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_2Bytes    AccessControlCommandTypeContainer = 0xA2
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_3Bytes    AccessControlCommandTypeContainer = 0xA3
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_4Bytes    AccessControlCommandTypeContainer = 0xA4
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_5Bytes    AccessControlCommandTypeContainer = 0xA5
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_6Bytes    AccessControlCommandTypeContainer = 0xA6
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_7Bytes    AccessControlCommandTypeContainer = 0xA7
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_8Bytes    AccessControlCommandTypeContainer = 0xA8
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_9Bytes    AccessControlCommandTypeContainer = 0xA9
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_10Bytes   AccessControlCommandTypeContainer = 0xAA
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_11Bytes   AccessControlCommandTypeContainer = 0xAB
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_12Bytes   AccessControlCommandTypeContainer = 0xAC
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_13Bytes   AccessControlCommandTypeContainer = 0xAD
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_14Bytes   AccessControlCommandTypeContainer = 0xAE
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_15Bytes   AccessControlCommandTypeContainer = 0xAF
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_16Bytes   AccessControlCommandTypeContainer = 0xB0
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_17Bytes   AccessControlCommandTypeContainer = 0xB1
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_18Bytes   AccessControlCommandTypeContainer = 0xB2
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_19Bytes   AccessControlCommandTypeContainer = 0xB3
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_20Bytes   AccessControlCommandTypeContainer = 0xB4
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_21Bytes   AccessControlCommandTypeContainer = 0xB5
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_22Bytes   AccessControlCommandTypeContainer = 0xB6
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_23Bytes   AccessControlCommandTypeContainer = 0xB7
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_24Bytes   AccessControlCommandTypeContainer = 0xB8
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_25Bytes   AccessControlCommandTypeContainer = 0xB9
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_26Bytes   AccessControlCommandTypeContainer = 0xBA
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_27Bytes   AccessControlCommandTypeContainer = 0xBB
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_28Bytes   AccessControlCommandTypeContainer = 0xBC
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_29Bytes   AccessControlCommandTypeContainer = 0xBD
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_30Bytes   AccessControlCommandTypeContainer = 0xBE
	AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_31Bytes   AccessControlCommandTypeContainer = 0xBF
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_0Bytes  AccessControlCommandTypeContainer = 0xC0
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_1Bytes  AccessControlCommandTypeContainer = 0xC1
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_2Bytes  AccessControlCommandTypeContainer = 0xC2
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_3Bytes  AccessControlCommandTypeContainer = 0xC3
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_4Bytes  AccessControlCommandTypeContainer = 0xC4
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_5Bytes  AccessControlCommandTypeContainer = 0xC5
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_6Bytes  AccessControlCommandTypeContainer = 0xC6
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_7Bytes  AccessControlCommandTypeContainer = 0xC7
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_8Bytes  AccessControlCommandTypeContainer = 0xC8
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_9Bytes  AccessControlCommandTypeContainer = 0xC9
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_10Bytes AccessControlCommandTypeContainer = 0xCA
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_11Bytes AccessControlCommandTypeContainer = 0xCB
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_12Bytes AccessControlCommandTypeContainer = 0xCC
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_13Bytes AccessControlCommandTypeContainer = 0xCD
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_14Bytes AccessControlCommandTypeContainer = 0xCE
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_15Bytes AccessControlCommandTypeContainer = 0xCF
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_16Bytes AccessControlCommandTypeContainer = 0xD0
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_17Bytes AccessControlCommandTypeContainer = 0xD1
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_18Bytes AccessControlCommandTypeContainer = 0xD2
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_19Bytes AccessControlCommandTypeContainer = 0xD3
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_20Bytes AccessControlCommandTypeContainer = 0xD4
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_21Bytes AccessControlCommandTypeContainer = 0xD5
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_22Bytes AccessControlCommandTypeContainer = 0xD6
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_23Bytes AccessControlCommandTypeContainer = 0xD7
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_24Bytes AccessControlCommandTypeContainer = 0xD8
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_25Bytes AccessControlCommandTypeContainer = 0xD9
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_26Bytes AccessControlCommandTypeContainer = 0xDA
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_27Bytes AccessControlCommandTypeContainer = 0xDB
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_28Bytes AccessControlCommandTypeContainer = 0xDC
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_29Bytes AccessControlCommandTypeContainer = 0xDD
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_30Bytes AccessControlCommandTypeContainer = 0xDE
	AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_31Bytes AccessControlCommandTypeContainer = 0xDF
)

var AccessControlCommandTypeContainerValues []AccessControlCommandTypeContainer

func init() {
	_ = errors.New
	AccessControlCommandTypeContainerValues = []AccessControlCommandTypeContainer{
		AccessControlCommandTypeContainer_AccessControlCommandCloseAccessPoint,
		AccessControlCommandTypeContainer_AccessControlCommandLockAccessPoint,
		AccessControlCommandTypeContainer_AccessControlCommandAccessPointLeftOpen,
		AccessControlCommandTypeContainer_AccessControlCommandAccessPointForcedOpen,
		AccessControlCommandTypeContainer_AccessControlCommandAccessPointClosed,
		AccessControlCommandTypeContainer_AccessControlCommandRequestToExit,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_0Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_1Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_2Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_3Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_4Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_5Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_6Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_7Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_8Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_9Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_10Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_11Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_12Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_13Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_14Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_15Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_16Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_17Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_18Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_19Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_20Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_21Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_22Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_23Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_24Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_25Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_26Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_27Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_28Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_29Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_30Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_31Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_0Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_1Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_2Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_3Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_4Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_5Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_6Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_7Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_8Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_9Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_10Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_11Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_12Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_13Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_14Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_15Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_16Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_17Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_18Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_19Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_20Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_21Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_22Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_23Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_24Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_25Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_26Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_27Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_28Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_29Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_30Bytes,
		AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_31Bytes,
	}
}

func (e AccessControlCommandTypeContainer) NumBytes() uint8 {
	switch e {
	case 0x02:
		{ /* '0x02' */
			return 2
		}
	case 0x0A:
		{ /* '0x0A' */
			return 2
		}
	case 0x12:
		{ /* '0x12' */
			return 2
		}
	case 0x1A:
		{ /* '0x1A' */
			return 2
		}
	case 0x22:
		{ /* '0x22' */
			return 2
		}
	case 0x32:
		{ /* '0x32' */
			return 2
		}
	case 0xA0:
		{ /* '0xA0' */
			return 0
		}
	case 0xA1:
		{ /* '0xA1' */
			return 1
		}
	case 0xA2:
		{ /* '0xA2' */
			return 2
		}
	case 0xA3:
		{ /* '0xA3' */
			return 3
		}
	case 0xA4:
		{ /* '0xA4' */
			return 4
		}
	case 0xA5:
		{ /* '0xA5' */
			return 5
		}
	case 0xA6:
		{ /* '0xA6' */
			return 6
		}
	case 0xA7:
		{ /* '0xA7' */
			return 7
		}
	case 0xA8:
		{ /* '0xA8' */
			return 8
		}
	case 0xA9:
		{ /* '0xA9' */
			return 9
		}
	case 0xAA:
		{ /* '0xAA' */
			return 10
		}
	case 0xAB:
		{ /* '0xAB' */
			return 11
		}
	case 0xAC:
		{ /* '0xAC' */
			return 12
		}
	case 0xAD:
		{ /* '0xAD' */
			return 13
		}
	case 0xAE:
		{ /* '0xAE' */
			return 14
		}
	case 0xAF:
		{ /* '0xAF' */
			return 15
		}
	case 0xB0:
		{ /* '0xB0' */
			return 16
		}
	case 0xB1:
		{ /* '0xB1' */
			return 17
		}
	case 0xB2:
		{ /* '0xB2' */
			return 18
		}
	case 0xB3:
		{ /* '0xB3' */
			return 19
		}
	case 0xB4:
		{ /* '0xB4' */
			return 20
		}
	case 0xB5:
		{ /* '0xB5' */
			return 21
		}
	case 0xB6:
		{ /* '0xB6' */
			return 22
		}
	case 0xB7:
		{ /* '0xB7' */
			return 23
		}
	case 0xB8:
		{ /* '0xB8' */
			return 24
		}
	case 0xB9:
		{ /* '0xB9' */
			return 25
		}
	case 0xBA:
		{ /* '0xBA' */
			return 26
		}
	case 0xBB:
		{ /* '0xBB' */
			return 27
		}
	case 0xBC:
		{ /* '0xBC' */
			return 28
		}
	case 0xBD:
		{ /* '0xBD' */
			return 29
		}
	case 0xBE:
		{ /* '0xBE' */
			return 30
		}
	case 0xBF:
		{ /* '0xBF' */
			return 31
		}
	case 0xC0:
		{ /* '0xC0' */
			return 0
		}
	case 0xC1:
		{ /* '0xC1' */
			return 1
		}
	case 0xC2:
		{ /* '0xC2' */
			return 2
		}
	case 0xC3:
		{ /* '0xC3' */
			return 3
		}
	case 0xC4:
		{ /* '0xC4' */
			return 4
		}
	case 0xC5:
		{ /* '0xC5' */
			return 5
		}
	case 0xC6:
		{ /* '0xC6' */
			return 6
		}
	case 0xC7:
		{ /* '0xC7' */
			return 7
		}
	case 0xC8:
		{ /* '0xC8' */
			return 8
		}
	case 0xC9:
		{ /* '0xC9' */
			return 9
		}
	case 0xCA:
		{ /* '0xCA' */
			return 10
		}
	case 0xCB:
		{ /* '0xCB' */
			return 11
		}
	case 0xCC:
		{ /* '0xCC' */
			return 12
		}
	case 0xCD:
		{ /* '0xCD' */
			return 13
		}
	case 0xCE:
		{ /* '0xCE' */
			return 14
		}
	case 0xCF:
		{ /* '0xCF' */
			return 15
		}
	case 0xD0:
		{ /* '0xD0' */
			return 16
		}
	case 0xD1:
		{ /* '0xD1' */
			return 17
		}
	case 0xD2:
		{ /* '0xD2' */
			return 18
		}
	case 0xD3:
		{ /* '0xD3' */
			return 19
		}
	case 0xD4:
		{ /* '0xD4' */
			return 20
		}
	case 0xD5:
		{ /* '0xD5' */
			return 21
		}
	case 0xD6:
		{ /* '0xD6' */
			return 22
		}
	case 0xD7:
		{ /* '0xD7' */
			return 23
		}
	case 0xD8:
		{ /* '0xD8' */
			return 24
		}
	case 0xD9:
		{ /* '0xD9' */
			return 25
		}
	case 0xDA:
		{ /* '0xDA' */
			return 26
		}
	case 0xDB:
		{ /* '0xDB' */
			return 27
		}
	case 0xDC:
		{ /* '0xDC' */
			return 28
		}
	case 0xDD:
		{ /* '0xDD' */
			return 29
		}
	case 0xDE:
		{ /* '0xDE' */
			return 30
		}
	case 0xDF:
		{ /* '0xDF' */
			return 31
		}
	default:
		{
			return 0
		}
	}
}

func AccessControlCommandTypeContainerFirstEnumForFieldNumBytes(value uint8) (enum AccessControlCommandTypeContainer, ok bool) {
	for _, sizeValue := range AccessControlCommandTypeContainerValues {
		if sizeValue.NumBytes() == value {
			return sizeValue, true
		}
	}
	return 0, false
}

func (e AccessControlCommandTypeContainer) CommandType() AccessControlCommandType {
	switch e {
	case 0x02:
		{ /* '0x02' */
			return AccessControlCommandType_CLOSE_ACCESS_POINT
		}
	case 0x0A:
		{ /* '0x0A' */
			return AccessControlCommandType_LOCK_ACCESS_POINT
		}
	case 0x12:
		{ /* '0x12' */
			return AccessControlCommandType_ACCESS_POINT_LEFT_OPEN
		}
	case 0x1A:
		{ /* '0x1A' */
			return AccessControlCommandType_ACCESS_POINT_FORCED_OPEN
		}
	case 0x22:
		{ /* '0x22' */
			return AccessControlCommandType_ACCESS_POINT_CLOSED
		}
	case 0x32:
		{ /* '0x32' */
			return AccessControlCommandType_REQUEST_TO_EXIT
		}
	case 0xA0:
		{ /* '0xA0' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xA1:
		{ /* '0xA1' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xA2:
		{ /* '0xA2' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xA3:
		{ /* '0xA3' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xA4:
		{ /* '0xA4' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xA5:
		{ /* '0xA5' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xA6:
		{ /* '0xA6' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xA7:
		{ /* '0xA7' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xA8:
		{ /* '0xA8' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xA9:
		{ /* '0xA9' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xAA:
		{ /* '0xAA' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xAB:
		{ /* '0xAB' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xAC:
		{ /* '0xAC' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xAD:
		{ /* '0xAD' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xAE:
		{ /* '0xAE' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xAF:
		{ /* '0xAF' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xB0:
		{ /* '0xB0' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xB1:
		{ /* '0xB1' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xB2:
		{ /* '0xB2' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xB3:
		{ /* '0xB3' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xB4:
		{ /* '0xB4' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xB5:
		{ /* '0xB5' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xB6:
		{ /* '0xB6' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xB7:
		{ /* '0xB7' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xB8:
		{ /* '0xB8' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xB9:
		{ /* '0xB9' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xBA:
		{ /* '0xBA' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xBB:
		{ /* '0xBB' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xBC:
		{ /* '0xBC' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xBD:
		{ /* '0xBD' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xBE:
		{ /* '0xBE' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xBF:
		{ /* '0xBF' */
			return AccessControlCommandType_VALID_ACCESS
		}
	case 0xC0:
		{ /* '0xC0' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xC1:
		{ /* '0xC1' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xC2:
		{ /* '0xC2' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xC3:
		{ /* '0xC3' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xC4:
		{ /* '0xC4' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xC5:
		{ /* '0xC5' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xC6:
		{ /* '0xC6' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xC7:
		{ /* '0xC7' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xC8:
		{ /* '0xC8' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xC9:
		{ /* '0xC9' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xCA:
		{ /* '0xCA' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xCB:
		{ /* '0xCB' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xCC:
		{ /* '0xCC' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xCD:
		{ /* '0xCD' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xCE:
		{ /* '0xCE' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xCF:
		{ /* '0xCF' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xD0:
		{ /* '0xD0' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xD1:
		{ /* '0xD1' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xD2:
		{ /* '0xD2' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xD3:
		{ /* '0xD3' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xD4:
		{ /* '0xD4' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xD5:
		{ /* '0xD5' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xD6:
		{ /* '0xD6' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xD7:
		{ /* '0xD7' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xD8:
		{ /* '0xD8' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xD9:
		{ /* '0xD9' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xDA:
		{ /* '0xDA' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xDB:
		{ /* '0xDB' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xDC:
		{ /* '0xDC' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xDD:
		{ /* '0xDD' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xDE:
		{ /* '0xDE' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	case 0xDF:
		{ /* '0xDF' */
			return AccessControlCommandType_INVALID_ACCESS
		}
	default:
		{
			return 0
		}
	}
}

func AccessControlCommandTypeContainerFirstEnumForFieldCommandType(value AccessControlCommandType) (enum AccessControlCommandTypeContainer, ok bool) {
	for _, sizeValue := range AccessControlCommandTypeContainerValues {
		if sizeValue.CommandType() == value {
			return sizeValue, true
		}
	}
	return 0, false
}

func (e AccessControlCommandTypeContainer) Category() AccessControlCategory {
	switch e {
	case 0x02:
		{ /* '0x02' */
			return AccessControlCategory_SYSTEM_REQUEST
		}
	case 0x0A:
		{ /* '0x0A' */
			return AccessControlCategory_SYSTEM_REQUEST
		}
	case 0x12:
		{ /* '0x12' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0x1A:
		{ /* '0x1A' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0x22:
		{ /* '0x22' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0x32:
		{ /* '0x32' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xA0:
		{ /* '0xA0' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xA1:
		{ /* '0xA1' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xA2:
		{ /* '0xA2' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xA3:
		{ /* '0xA3' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xA4:
		{ /* '0xA4' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xA5:
		{ /* '0xA5' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xA6:
		{ /* '0xA6' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xA7:
		{ /* '0xA7' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xA8:
		{ /* '0xA8' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xA9:
		{ /* '0xA9' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xAA:
		{ /* '0xAA' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xAB:
		{ /* '0xAB' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xAC:
		{ /* '0xAC' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xAD:
		{ /* '0xAD' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xAE:
		{ /* '0xAE' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xAF:
		{ /* '0xAF' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xB0:
		{ /* '0xB0' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xB1:
		{ /* '0xB1' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xB2:
		{ /* '0xB2' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xB3:
		{ /* '0xB3' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xB4:
		{ /* '0xB4' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xB5:
		{ /* '0xB5' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xB6:
		{ /* '0xB6' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xB7:
		{ /* '0xB7' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xB8:
		{ /* '0xB8' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xB9:
		{ /* '0xB9' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xBA:
		{ /* '0xBA' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xBB:
		{ /* '0xBB' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xBC:
		{ /* '0xBC' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xBD:
		{ /* '0xBD' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xBE:
		{ /* '0xBE' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xBF:
		{ /* '0xBF' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xC0:
		{ /* '0xC0' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xC1:
		{ /* '0xC1' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xC2:
		{ /* '0xC2' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xC3:
		{ /* '0xC3' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xC4:
		{ /* '0xC4' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xC5:
		{ /* '0xC5' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xC6:
		{ /* '0xC6' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xC7:
		{ /* '0xC7' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xC8:
		{ /* '0xC8' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xC9:
		{ /* '0xC9' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xCA:
		{ /* '0xCA' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xCB:
		{ /* '0xCB' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xCC:
		{ /* '0xCC' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xCD:
		{ /* '0xCD' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xCE:
		{ /* '0xCE' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xCF:
		{ /* '0xCF' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xD0:
		{ /* '0xD0' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xD1:
		{ /* '0xD1' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xD2:
		{ /* '0xD2' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xD3:
		{ /* '0xD3' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xD4:
		{ /* '0xD4' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xD5:
		{ /* '0xD5' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xD6:
		{ /* '0xD6' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xD7:
		{ /* '0xD7' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xD8:
		{ /* '0xD8' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xD9:
		{ /* '0xD9' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xDA:
		{ /* '0xDA' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xDB:
		{ /* '0xDB' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xDC:
		{ /* '0xDC' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xDD:
		{ /* '0xDD' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xDE:
		{ /* '0xDE' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	case 0xDF:
		{ /* '0xDF' */
			return AccessControlCategory_SYSTEM_ACTIVITY
		}
	default:
		{
			return 0
		}
	}
}

func AccessControlCommandTypeContainerFirstEnumForFieldCategory(value AccessControlCategory) (enum AccessControlCommandTypeContainer, ok bool) {
	for _, sizeValue := range AccessControlCommandTypeContainerValues {
		if sizeValue.Category() == value {
			return sizeValue, true
		}
	}
	return 0, false
}
func AccessControlCommandTypeContainerByValue(value uint8) (enum AccessControlCommandTypeContainer, ok bool) {
	switch value {
	case 0x02:
		return AccessControlCommandTypeContainer_AccessControlCommandCloseAccessPoint, true
	case 0x0A:
		return AccessControlCommandTypeContainer_AccessControlCommandLockAccessPoint, true
	case 0x12:
		return AccessControlCommandTypeContainer_AccessControlCommandAccessPointLeftOpen, true
	case 0x1A:
		return AccessControlCommandTypeContainer_AccessControlCommandAccessPointForcedOpen, true
	case 0x22:
		return AccessControlCommandTypeContainer_AccessControlCommandAccessPointClosed, true
	case 0x32:
		return AccessControlCommandTypeContainer_AccessControlCommandRequestToExit, true
	case 0xA0:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_0Bytes, true
	case 0xA1:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_1Bytes, true
	case 0xA2:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_2Bytes, true
	case 0xA3:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_3Bytes, true
	case 0xA4:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_4Bytes, true
	case 0xA5:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_5Bytes, true
	case 0xA6:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_6Bytes, true
	case 0xA7:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_7Bytes, true
	case 0xA8:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_8Bytes, true
	case 0xA9:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_9Bytes, true
	case 0xAA:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_10Bytes, true
	case 0xAB:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_11Bytes, true
	case 0xAC:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_12Bytes, true
	case 0xAD:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_13Bytes, true
	case 0xAE:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_14Bytes, true
	case 0xAF:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_15Bytes, true
	case 0xB0:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_16Bytes, true
	case 0xB1:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_17Bytes, true
	case 0xB2:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_18Bytes, true
	case 0xB3:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_19Bytes, true
	case 0xB4:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_20Bytes, true
	case 0xB5:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_21Bytes, true
	case 0xB6:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_22Bytes, true
	case 0xB7:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_23Bytes, true
	case 0xB8:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_24Bytes, true
	case 0xB9:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_25Bytes, true
	case 0xBA:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_26Bytes, true
	case 0xBB:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_27Bytes, true
	case 0xBC:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_28Bytes, true
	case 0xBD:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_29Bytes, true
	case 0xBE:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_30Bytes, true
	case 0xBF:
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_31Bytes, true
	case 0xC0:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_0Bytes, true
	case 0xC1:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_1Bytes, true
	case 0xC2:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_2Bytes, true
	case 0xC3:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_3Bytes, true
	case 0xC4:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_4Bytes, true
	case 0xC5:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_5Bytes, true
	case 0xC6:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_6Bytes, true
	case 0xC7:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_7Bytes, true
	case 0xC8:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_8Bytes, true
	case 0xC9:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_9Bytes, true
	case 0xCA:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_10Bytes, true
	case 0xCB:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_11Bytes, true
	case 0xCC:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_12Bytes, true
	case 0xCD:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_13Bytes, true
	case 0xCE:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_14Bytes, true
	case 0xCF:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_15Bytes, true
	case 0xD0:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_16Bytes, true
	case 0xD1:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_17Bytes, true
	case 0xD2:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_18Bytes, true
	case 0xD3:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_19Bytes, true
	case 0xD4:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_20Bytes, true
	case 0xD5:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_21Bytes, true
	case 0xD6:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_22Bytes, true
	case 0xD7:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_23Bytes, true
	case 0xD8:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_24Bytes, true
	case 0xD9:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_25Bytes, true
	case 0xDA:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_26Bytes, true
	case 0xDB:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_27Bytes, true
	case 0xDC:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_28Bytes, true
	case 0xDD:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_29Bytes, true
	case 0xDE:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_30Bytes, true
	case 0xDF:
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_31Bytes, true
	}
	return 0, false
}

func AccessControlCommandTypeContainerByName(value string) (enum AccessControlCommandTypeContainer, ok bool) {
	switch value {
	case "AccessControlCommandCloseAccessPoint":
		return AccessControlCommandTypeContainer_AccessControlCommandCloseAccessPoint, true
	case "AccessControlCommandLockAccessPoint":
		return AccessControlCommandTypeContainer_AccessControlCommandLockAccessPoint, true
	case "AccessControlCommandAccessPointLeftOpen":
		return AccessControlCommandTypeContainer_AccessControlCommandAccessPointLeftOpen, true
	case "AccessControlCommandAccessPointForcedOpen":
		return AccessControlCommandTypeContainer_AccessControlCommandAccessPointForcedOpen, true
	case "AccessControlCommandAccessPointClosed":
		return AccessControlCommandTypeContainer_AccessControlCommandAccessPointClosed, true
	case "AccessControlCommandRequestToExit":
		return AccessControlCommandTypeContainer_AccessControlCommandRequestToExit, true
	case "AccessControlCommandValidAccessRequest_0Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_0Bytes, true
	case "AccessControlCommandValidAccessRequest_1Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_1Bytes, true
	case "AccessControlCommandValidAccessRequest_2Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_2Bytes, true
	case "AccessControlCommandValidAccessRequest_3Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_3Bytes, true
	case "AccessControlCommandValidAccessRequest_4Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_4Bytes, true
	case "AccessControlCommandValidAccessRequest_5Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_5Bytes, true
	case "AccessControlCommandValidAccessRequest_6Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_6Bytes, true
	case "AccessControlCommandValidAccessRequest_7Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_7Bytes, true
	case "AccessControlCommandValidAccessRequest_8Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_8Bytes, true
	case "AccessControlCommandValidAccessRequest_9Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_9Bytes, true
	case "AccessControlCommandValidAccessRequest_10Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_10Bytes, true
	case "AccessControlCommandValidAccessRequest_11Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_11Bytes, true
	case "AccessControlCommandValidAccessRequest_12Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_12Bytes, true
	case "AccessControlCommandValidAccessRequest_13Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_13Bytes, true
	case "AccessControlCommandValidAccessRequest_14Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_14Bytes, true
	case "AccessControlCommandValidAccessRequest_15Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_15Bytes, true
	case "AccessControlCommandValidAccessRequest_16Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_16Bytes, true
	case "AccessControlCommandValidAccessRequest_17Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_17Bytes, true
	case "AccessControlCommandValidAccessRequest_18Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_18Bytes, true
	case "AccessControlCommandValidAccessRequest_19Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_19Bytes, true
	case "AccessControlCommandValidAccessRequest_20Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_20Bytes, true
	case "AccessControlCommandValidAccessRequest_21Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_21Bytes, true
	case "AccessControlCommandValidAccessRequest_22Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_22Bytes, true
	case "AccessControlCommandValidAccessRequest_23Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_23Bytes, true
	case "AccessControlCommandValidAccessRequest_24Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_24Bytes, true
	case "AccessControlCommandValidAccessRequest_25Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_25Bytes, true
	case "AccessControlCommandValidAccessRequest_26Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_26Bytes, true
	case "AccessControlCommandValidAccessRequest_27Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_27Bytes, true
	case "AccessControlCommandValidAccessRequest_28Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_28Bytes, true
	case "AccessControlCommandValidAccessRequest_29Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_29Bytes, true
	case "AccessControlCommandValidAccessRequest_30Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_30Bytes, true
	case "AccessControlCommandValidAccessRequest_31Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_31Bytes, true
	case "AccessControlCommandInvalidAccessRequest_0Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_0Bytes, true
	case "AccessControlCommandInvalidAccessRequest_1Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_1Bytes, true
	case "AccessControlCommandInvalidAccessRequest_2Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_2Bytes, true
	case "AccessControlCommandInvalidAccessRequest_3Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_3Bytes, true
	case "AccessControlCommandInvalidAccessRequest_4Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_4Bytes, true
	case "AccessControlCommandInvalidAccessRequest_5Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_5Bytes, true
	case "AccessControlCommandInvalidAccessRequest_6Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_6Bytes, true
	case "AccessControlCommandInvalidAccessRequest_7Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_7Bytes, true
	case "AccessControlCommandInvalidAccessRequest_8Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_8Bytes, true
	case "AccessControlCommandInvalidAccessRequest_9Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_9Bytes, true
	case "AccessControlCommandInvalidAccessRequest_10Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_10Bytes, true
	case "AccessControlCommandInvalidAccessRequest_11Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_11Bytes, true
	case "AccessControlCommandInvalidAccessRequest_12Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_12Bytes, true
	case "AccessControlCommandInvalidAccessRequest_13Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_13Bytes, true
	case "AccessControlCommandInvalidAccessRequest_14Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_14Bytes, true
	case "AccessControlCommandInvalidAccessRequest_15Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_15Bytes, true
	case "AccessControlCommandInvalidAccessRequest_16Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_16Bytes, true
	case "AccessControlCommandInvalidAccessRequest_17Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_17Bytes, true
	case "AccessControlCommandInvalidAccessRequest_18Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_18Bytes, true
	case "AccessControlCommandInvalidAccessRequest_19Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_19Bytes, true
	case "AccessControlCommandInvalidAccessRequest_20Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_20Bytes, true
	case "AccessControlCommandInvalidAccessRequest_21Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_21Bytes, true
	case "AccessControlCommandInvalidAccessRequest_22Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_22Bytes, true
	case "AccessControlCommandInvalidAccessRequest_23Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_23Bytes, true
	case "AccessControlCommandInvalidAccessRequest_24Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_24Bytes, true
	case "AccessControlCommandInvalidAccessRequest_25Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_25Bytes, true
	case "AccessControlCommandInvalidAccessRequest_26Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_26Bytes, true
	case "AccessControlCommandInvalidAccessRequest_27Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_27Bytes, true
	case "AccessControlCommandInvalidAccessRequest_28Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_28Bytes, true
	case "AccessControlCommandInvalidAccessRequest_29Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_29Bytes, true
	case "AccessControlCommandInvalidAccessRequest_30Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_30Bytes, true
	case "AccessControlCommandInvalidAccessRequest_31Bytes":
		return AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_31Bytes, true
	}
	return 0, false
}

func AccessControlCommandTypeContainerKnows(value uint8) bool {
	for _, typeValue := range AccessControlCommandTypeContainerValues {
		if uint8(typeValue) == value {
			return true
		}
	}
	return false
}

func CastAccessControlCommandTypeContainer(structType any) AccessControlCommandTypeContainer {
	castFunc := func(typ any) AccessControlCommandTypeContainer {
		if sAccessControlCommandTypeContainer, ok := typ.(AccessControlCommandTypeContainer); ok {
			return sAccessControlCommandTypeContainer
		}
		return 0
	}
	return castFunc(structType)
}

func (m AccessControlCommandTypeContainer) GetLengthInBits(ctx context.Context) uint16 {
	return 8
}

func (m AccessControlCommandTypeContainer) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func AccessControlCommandTypeContainerParse(ctx context.Context, theBytes []byte) (AccessControlCommandTypeContainer, error) {
	return AccessControlCommandTypeContainerParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func AccessControlCommandTypeContainerParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (AccessControlCommandTypeContainer, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("AccessControlCommandTypeContainer", 8)
	if err != nil {
		return 0, errors.Wrap(err, "error reading AccessControlCommandTypeContainer")
	}
	if enum, ok := AccessControlCommandTypeContainerByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for AccessControlCommandTypeContainer")
		return AccessControlCommandTypeContainer(val), nil
	} else {
		return enum, nil
	}
}

func (e AccessControlCommandTypeContainer) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e AccessControlCommandTypeContainer) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteUint8("AccessControlCommandTypeContainer", 8, uint8(uint8(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e AccessControlCommandTypeContainer) GetValue() uint8 {
	return uint8(e)
}

func (e AccessControlCommandTypeContainer) GetNumBytes() uint8 {
	return e.NumBytes()
}
func (e AccessControlCommandTypeContainer) GetCommandType() AccessControlCommandType {
	return e.CommandType()
}
func (e AccessControlCommandTypeContainer) GetCategory() AccessControlCategory {
	return e.Category()
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e AccessControlCommandTypeContainer) PLC4XEnumName() string {
	switch e {
	case AccessControlCommandTypeContainer_AccessControlCommandCloseAccessPoint:
		return "AccessControlCommandCloseAccessPoint"
	case AccessControlCommandTypeContainer_AccessControlCommandLockAccessPoint:
		return "AccessControlCommandLockAccessPoint"
	case AccessControlCommandTypeContainer_AccessControlCommandAccessPointLeftOpen:
		return "AccessControlCommandAccessPointLeftOpen"
	case AccessControlCommandTypeContainer_AccessControlCommandAccessPointForcedOpen:
		return "AccessControlCommandAccessPointForcedOpen"
	case AccessControlCommandTypeContainer_AccessControlCommandAccessPointClosed:
		return "AccessControlCommandAccessPointClosed"
	case AccessControlCommandTypeContainer_AccessControlCommandRequestToExit:
		return "AccessControlCommandRequestToExit"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_0Bytes:
		return "AccessControlCommandValidAccessRequest_0Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_1Bytes:
		return "AccessControlCommandValidAccessRequest_1Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_2Bytes:
		return "AccessControlCommandValidAccessRequest_2Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_3Bytes:
		return "AccessControlCommandValidAccessRequest_3Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_4Bytes:
		return "AccessControlCommandValidAccessRequest_4Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_5Bytes:
		return "AccessControlCommandValidAccessRequest_5Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_6Bytes:
		return "AccessControlCommandValidAccessRequest_6Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_7Bytes:
		return "AccessControlCommandValidAccessRequest_7Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_8Bytes:
		return "AccessControlCommandValidAccessRequest_8Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_9Bytes:
		return "AccessControlCommandValidAccessRequest_9Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_10Bytes:
		return "AccessControlCommandValidAccessRequest_10Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_11Bytes:
		return "AccessControlCommandValidAccessRequest_11Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_12Bytes:
		return "AccessControlCommandValidAccessRequest_12Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_13Bytes:
		return "AccessControlCommandValidAccessRequest_13Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_14Bytes:
		return "AccessControlCommandValidAccessRequest_14Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_15Bytes:
		return "AccessControlCommandValidAccessRequest_15Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_16Bytes:
		return "AccessControlCommandValidAccessRequest_16Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_17Bytes:
		return "AccessControlCommandValidAccessRequest_17Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_18Bytes:
		return "AccessControlCommandValidAccessRequest_18Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_19Bytes:
		return "AccessControlCommandValidAccessRequest_19Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_20Bytes:
		return "AccessControlCommandValidAccessRequest_20Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_21Bytes:
		return "AccessControlCommandValidAccessRequest_21Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_22Bytes:
		return "AccessControlCommandValidAccessRequest_22Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_23Bytes:
		return "AccessControlCommandValidAccessRequest_23Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_24Bytes:
		return "AccessControlCommandValidAccessRequest_24Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_25Bytes:
		return "AccessControlCommandValidAccessRequest_25Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_26Bytes:
		return "AccessControlCommandValidAccessRequest_26Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_27Bytes:
		return "AccessControlCommandValidAccessRequest_27Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_28Bytes:
		return "AccessControlCommandValidAccessRequest_28Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_29Bytes:
		return "AccessControlCommandValidAccessRequest_29Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_30Bytes:
		return "AccessControlCommandValidAccessRequest_30Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandValidAccessRequest_31Bytes:
		return "AccessControlCommandValidAccessRequest_31Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_0Bytes:
		return "AccessControlCommandInvalidAccessRequest_0Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_1Bytes:
		return "AccessControlCommandInvalidAccessRequest_1Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_2Bytes:
		return "AccessControlCommandInvalidAccessRequest_2Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_3Bytes:
		return "AccessControlCommandInvalidAccessRequest_3Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_4Bytes:
		return "AccessControlCommandInvalidAccessRequest_4Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_5Bytes:
		return "AccessControlCommandInvalidAccessRequest_5Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_6Bytes:
		return "AccessControlCommandInvalidAccessRequest_6Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_7Bytes:
		return "AccessControlCommandInvalidAccessRequest_7Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_8Bytes:
		return "AccessControlCommandInvalidAccessRequest_8Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_9Bytes:
		return "AccessControlCommandInvalidAccessRequest_9Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_10Bytes:
		return "AccessControlCommandInvalidAccessRequest_10Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_11Bytes:
		return "AccessControlCommandInvalidAccessRequest_11Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_12Bytes:
		return "AccessControlCommandInvalidAccessRequest_12Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_13Bytes:
		return "AccessControlCommandInvalidAccessRequest_13Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_14Bytes:
		return "AccessControlCommandInvalidAccessRequest_14Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_15Bytes:
		return "AccessControlCommandInvalidAccessRequest_15Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_16Bytes:
		return "AccessControlCommandInvalidAccessRequest_16Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_17Bytes:
		return "AccessControlCommandInvalidAccessRequest_17Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_18Bytes:
		return "AccessControlCommandInvalidAccessRequest_18Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_19Bytes:
		return "AccessControlCommandInvalidAccessRequest_19Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_20Bytes:
		return "AccessControlCommandInvalidAccessRequest_20Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_21Bytes:
		return "AccessControlCommandInvalidAccessRequest_21Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_22Bytes:
		return "AccessControlCommandInvalidAccessRequest_22Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_23Bytes:
		return "AccessControlCommandInvalidAccessRequest_23Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_24Bytes:
		return "AccessControlCommandInvalidAccessRequest_24Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_25Bytes:
		return "AccessControlCommandInvalidAccessRequest_25Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_26Bytes:
		return "AccessControlCommandInvalidAccessRequest_26Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_27Bytes:
		return "AccessControlCommandInvalidAccessRequest_27Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_28Bytes:
		return "AccessControlCommandInvalidAccessRequest_28Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_29Bytes:
		return "AccessControlCommandInvalidAccessRequest_29Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_30Bytes:
		return "AccessControlCommandInvalidAccessRequest_30Bytes"
	case AccessControlCommandTypeContainer_AccessControlCommandInvalidAccessRequest_31Bytes:
		return "AccessControlCommandInvalidAccessRequest_31Bytes"
	}
	return fmt.Sprintf("Unknown(%v)", uint8(e))
}

func (e AccessControlCommandTypeContainer) String() string {
	return e.PLC4XEnumName()
}
