/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetEventTypeTagged is the corresponding interface of BACnetEventTypeTagged
type BACnetEventTypeTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetEventType
	// GetProprietaryValue returns ProprietaryValue (property field)
	GetProprietaryValue() uint32
	// GetIsProprietary returns IsProprietary (virtual field)
	GetIsProprietary() bool
	// IsBACnetEventTypeTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetEventTypeTagged()
	// CreateBuilder creates a BACnetEventTypeTaggedBuilder
	CreateBACnetEventTypeTaggedBuilder() BACnetEventTypeTaggedBuilder
}

// _BACnetEventTypeTagged is the data-structure of this message
type _BACnetEventTypeTagged struct {
	Header           BACnetTagHeader
	Value            BACnetEventType
	ProprietaryValue uint32

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetEventTypeTagged = (*_BACnetEventTypeTagged)(nil)

// NewBACnetEventTypeTagged factory function for _BACnetEventTypeTagged
func NewBACnetEventTypeTagged(header BACnetTagHeader, value BACnetEventType, proprietaryValue uint32, tagNumber uint8, tagClass TagClass) *_BACnetEventTypeTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetEventTypeTagged must not be nil")
	}
	return &_BACnetEventTypeTagged{Header: header, Value: value, ProprietaryValue: proprietaryValue, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetEventTypeTaggedBuilder is a builder for BACnetEventTypeTagged
type BACnetEventTypeTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetEventType, proprietaryValue uint32) BACnetEventTypeTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetEventTypeTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetEventTypeTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetEventType) BACnetEventTypeTaggedBuilder
	// WithProprietaryValue adds ProprietaryValue (property field)
	WithProprietaryValue(uint32) BACnetEventTypeTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetEventTypeTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetEventTypeTaggedBuilder
	// Build builds the BACnetEventTypeTagged or returns an error if something is wrong
	Build() (BACnetEventTypeTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetEventTypeTagged
}

// NewBACnetEventTypeTaggedBuilder() creates a BACnetEventTypeTaggedBuilder
func NewBACnetEventTypeTaggedBuilder() BACnetEventTypeTaggedBuilder {
	return &_BACnetEventTypeTaggedBuilder{_BACnetEventTypeTagged: new(_BACnetEventTypeTagged)}
}

type _BACnetEventTypeTaggedBuilder struct {
	*_BACnetEventTypeTagged

	collectedErr []error
}

var _ (BACnetEventTypeTaggedBuilder) = (*_BACnetEventTypeTaggedBuilder)(nil)

func (b *_BACnetEventTypeTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetEventType, proprietaryValue uint32) BACnetEventTypeTaggedBuilder {
	return b.WithHeader(header).WithValue(value).WithProprietaryValue(proprietaryValue)
}

func (b *_BACnetEventTypeTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetEventTypeTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetEventTypeTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetEventTypeTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetEventTypeTaggedBuilder) WithValue(value BACnetEventType) BACnetEventTypeTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetEventTypeTaggedBuilder) WithProprietaryValue(proprietaryValue uint32) BACnetEventTypeTaggedBuilder {
	b.ProprietaryValue = proprietaryValue
	return b
}

func (b *_BACnetEventTypeTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetEventTypeTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetEventTypeTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetEventTypeTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetEventTypeTaggedBuilder) Build() (BACnetEventTypeTagged, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetEventTypeTagged.deepCopy(), nil
}

func (b *_BACnetEventTypeTaggedBuilder) MustBuild() BACnetEventTypeTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetEventTypeTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetEventTypeTaggedBuilder().(*_BACnetEventTypeTaggedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetEventTypeTaggedBuilder creates a BACnetEventTypeTaggedBuilder
func (b *_BACnetEventTypeTagged) CreateBACnetEventTypeTaggedBuilder() BACnetEventTypeTaggedBuilder {
	if b == nil {
		return NewBACnetEventTypeTaggedBuilder()
	}
	return &_BACnetEventTypeTaggedBuilder{_BACnetEventTypeTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetEventTypeTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetEventTypeTagged) GetValue() BACnetEventType {
	return m.Value
}

func (m *_BACnetEventTypeTagged) GetProprietaryValue() uint32 {
	return m.ProprietaryValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetEventTypeTagged) GetIsProprietary() bool {
	ctx := context.Background()
	_ = ctx
	return bool(bool((m.GetValue()) == (BACnetEventType_VENDOR_PROPRIETARY_VALUE)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetEventTypeTagged(structType any) BACnetEventTypeTagged {
	if casted, ok := structType.(BACnetEventTypeTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetEventTypeTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetEventTypeTagged) GetTypeName() string {
	return "BACnetEventTypeTagged"
}

func (m *_BACnetEventTypeTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32(int32(0)) }, func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }).(int32))

	// A virtual field doesn't have any in- or output.

	// Manual Field (proprietaryValue)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }, func() any { return int32(int32(0)) }).(int32))

	return lengthInBits
}

func (m *_BACnetEventTypeTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetEventTypeTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetEventTypeTagged, error) {
	return BACnetEventTypeTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetEventTypeTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEventTypeTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEventTypeTagged, error) {
		return BACnetEventTypeTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetEventTypeTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetEventTypeTagged, error) {
	v, err := (&_BACnetEventTypeTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetEventTypeTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetEventTypeTagged BACnetEventTypeTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetEventTypeTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetEventTypeTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetEventType](ctx, "value", readBuffer, EnsureType[BACnetEventType](ReadEnumGeneric(ctx, readBuffer, header.GetActualLength(), BACnetEventType_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	isProprietary, err := ReadVirtualField[bool](ctx, "isProprietary", (*bool)(nil), bool((value) == (BACnetEventType_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isProprietary' field"))
	}
	_ = isProprietary

	proprietaryValue, err := ReadManualField[uint32](ctx, "proprietaryValue", readBuffer, EnsureType[uint32](ReadProprietaryEnumGeneric(ctx, readBuffer, header.GetActualLength(), isProprietary)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'proprietaryValue' field"))
	}
	m.ProprietaryValue = proprietaryValue

	if closeErr := readBuffer.CloseContext("BACnetEventTypeTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetEventTypeTagged")
	}

	return m, nil
}

func (m *_BACnetEventTypeTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetEventTypeTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetEventTypeTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetEventTypeTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetEventType](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}
	// Virtual field
	isProprietary := m.GetIsProprietary()
	_ = isProprietary
	if _isProprietaryErr := writeBuffer.WriteVirtual(ctx, "isProprietary", m.GetIsProprietary()); _isProprietaryErr != nil {
		return errors.Wrap(_isProprietaryErr, "Error serializing 'isProprietary' field")
	}

	if err := WriteManualField[uint32](ctx, "proprietaryValue", func(ctx context.Context) error {
		return WriteProprietaryEnumGeneric(ctx, writeBuffer, m.GetProprietaryValue(), m.GetIsProprietary())
	}, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'proprietaryValue' field")
	}

	if popErr := writeBuffer.PopContext("BACnetEventTypeTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetEventTypeTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetEventTypeTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetEventTypeTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetEventTypeTagged) IsBACnetEventTypeTagged() {}

func (m *_BACnetEventTypeTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetEventTypeTagged) deepCopy() *_BACnetEventTypeTagged {
	if m == nil {
		return nil
	}
	_BACnetEventTypeTaggedCopy := &_BACnetEventTypeTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.ProprietaryValue,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetEventTypeTaggedCopy
}

func (m *_BACnetEventTypeTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
