/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLastCredentialRemovedTime is the corresponding interface of BACnetConstructedDataLastCredentialRemovedTime
type BACnetConstructedDataLastCredentialRemovedTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetLastCredentialRemovedTime returns LastCredentialRemovedTime (property field)
	GetLastCredentialRemovedTime() BACnetDateTime
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetDateTime
	// IsBACnetConstructedDataLastCredentialRemovedTime is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataLastCredentialRemovedTime()
	// CreateBuilder creates a BACnetConstructedDataLastCredentialRemovedTimeBuilder
	CreateBACnetConstructedDataLastCredentialRemovedTimeBuilder() BACnetConstructedDataLastCredentialRemovedTimeBuilder
}

// _BACnetConstructedDataLastCredentialRemovedTime is the data-structure of this message
type _BACnetConstructedDataLastCredentialRemovedTime struct {
	BACnetConstructedDataContract
	LastCredentialRemovedTime BACnetDateTime
}

var _ BACnetConstructedDataLastCredentialRemovedTime = (*_BACnetConstructedDataLastCredentialRemovedTime)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataLastCredentialRemovedTime)(nil)

// NewBACnetConstructedDataLastCredentialRemovedTime factory function for _BACnetConstructedDataLastCredentialRemovedTime
func NewBACnetConstructedDataLastCredentialRemovedTime(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, lastCredentialRemovedTime BACnetDateTime, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLastCredentialRemovedTime {
	if lastCredentialRemovedTime == nil {
		panic("lastCredentialRemovedTime of type BACnetDateTime for BACnetConstructedDataLastCredentialRemovedTime must not be nil")
	}
	_result := &_BACnetConstructedDataLastCredentialRemovedTime{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		LastCredentialRemovedTime:     lastCredentialRemovedTime,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataLastCredentialRemovedTimeBuilder is a builder for BACnetConstructedDataLastCredentialRemovedTime
type BACnetConstructedDataLastCredentialRemovedTimeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(lastCredentialRemovedTime BACnetDateTime) BACnetConstructedDataLastCredentialRemovedTimeBuilder
	// WithLastCredentialRemovedTime adds LastCredentialRemovedTime (property field)
	WithLastCredentialRemovedTime(BACnetDateTime) BACnetConstructedDataLastCredentialRemovedTimeBuilder
	// WithLastCredentialRemovedTimeBuilder adds LastCredentialRemovedTime (property field) which is build by the builder
	WithLastCredentialRemovedTimeBuilder(func(BACnetDateTimeBuilder) BACnetDateTimeBuilder) BACnetConstructedDataLastCredentialRemovedTimeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataLastCredentialRemovedTime or returns an error if something is wrong
	Build() (BACnetConstructedDataLastCredentialRemovedTime, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataLastCredentialRemovedTime
}

// NewBACnetConstructedDataLastCredentialRemovedTimeBuilder() creates a BACnetConstructedDataLastCredentialRemovedTimeBuilder
func NewBACnetConstructedDataLastCredentialRemovedTimeBuilder() BACnetConstructedDataLastCredentialRemovedTimeBuilder {
	return &_BACnetConstructedDataLastCredentialRemovedTimeBuilder{_BACnetConstructedDataLastCredentialRemovedTime: new(_BACnetConstructedDataLastCredentialRemovedTime)}
}

type _BACnetConstructedDataLastCredentialRemovedTimeBuilder struct {
	*_BACnetConstructedDataLastCredentialRemovedTime

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataLastCredentialRemovedTimeBuilder) = (*_BACnetConstructedDataLastCredentialRemovedTimeBuilder)(nil)

func (b *_BACnetConstructedDataLastCredentialRemovedTimeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataLastCredentialRemovedTime
}

func (b *_BACnetConstructedDataLastCredentialRemovedTimeBuilder) WithMandatoryFields(lastCredentialRemovedTime BACnetDateTime) BACnetConstructedDataLastCredentialRemovedTimeBuilder {
	return b.WithLastCredentialRemovedTime(lastCredentialRemovedTime)
}

func (b *_BACnetConstructedDataLastCredentialRemovedTimeBuilder) WithLastCredentialRemovedTime(lastCredentialRemovedTime BACnetDateTime) BACnetConstructedDataLastCredentialRemovedTimeBuilder {
	b.LastCredentialRemovedTime = lastCredentialRemovedTime
	return b
}

func (b *_BACnetConstructedDataLastCredentialRemovedTimeBuilder) WithLastCredentialRemovedTimeBuilder(builderSupplier func(BACnetDateTimeBuilder) BACnetDateTimeBuilder) BACnetConstructedDataLastCredentialRemovedTimeBuilder {
	builder := builderSupplier(b.LastCredentialRemovedTime.CreateBACnetDateTimeBuilder())
	var err error
	b.LastCredentialRemovedTime, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetDateTimeBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataLastCredentialRemovedTimeBuilder) Build() (BACnetConstructedDataLastCredentialRemovedTime, error) {
	if b.LastCredentialRemovedTime == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'lastCredentialRemovedTime' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataLastCredentialRemovedTime.deepCopy(), nil
}

func (b *_BACnetConstructedDataLastCredentialRemovedTimeBuilder) MustBuild() BACnetConstructedDataLastCredentialRemovedTime {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataLastCredentialRemovedTimeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataLastCredentialRemovedTimeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataLastCredentialRemovedTimeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataLastCredentialRemovedTimeBuilder().(*_BACnetConstructedDataLastCredentialRemovedTimeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataLastCredentialRemovedTimeBuilder creates a BACnetConstructedDataLastCredentialRemovedTimeBuilder
func (b *_BACnetConstructedDataLastCredentialRemovedTime) CreateBACnetConstructedDataLastCredentialRemovedTimeBuilder() BACnetConstructedDataLastCredentialRemovedTimeBuilder {
	if b == nil {
		return NewBACnetConstructedDataLastCredentialRemovedTimeBuilder()
	}
	return &_BACnetConstructedDataLastCredentialRemovedTimeBuilder{_BACnetConstructedDataLastCredentialRemovedTime: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLastCredentialRemovedTime) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataLastCredentialRemovedTime) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_LAST_CREDENTIAL_REMOVED_TIME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLastCredentialRemovedTime) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataLastCredentialRemovedTime) GetLastCredentialRemovedTime() BACnetDateTime {
	return m.LastCredentialRemovedTime
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataLastCredentialRemovedTime) GetActualValue() BACnetDateTime {
	ctx := context.Background()
	_ = ctx
	return CastBACnetDateTime(m.GetLastCredentialRemovedTime())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLastCredentialRemovedTime(structType any) BACnetConstructedDataLastCredentialRemovedTime {
	if casted, ok := structType.(BACnetConstructedDataLastCredentialRemovedTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLastCredentialRemovedTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLastCredentialRemovedTime) GetTypeName() string {
	return "BACnetConstructedDataLastCredentialRemovedTime"
}

func (m *_BACnetConstructedDataLastCredentialRemovedTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (lastCredentialRemovedTime)
	lengthInBits += m.LastCredentialRemovedTime.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataLastCredentialRemovedTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataLastCredentialRemovedTime) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataLastCredentialRemovedTime BACnetConstructedDataLastCredentialRemovedTime, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLastCredentialRemovedTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLastCredentialRemovedTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	lastCredentialRemovedTime, err := ReadSimpleField[BACnetDateTime](ctx, "lastCredentialRemovedTime", ReadComplex[BACnetDateTime](BACnetDateTimeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'lastCredentialRemovedTime' field"))
	}
	m.LastCredentialRemovedTime = lastCredentialRemovedTime

	actualValue, err := ReadVirtualField[BACnetDateTime](ctx, "actualValue", (*BACnetDateTime)(nil), lastCredentialRemovedTime)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLastCredentialRemovedTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLastCredentialRemovedTime")
	}

	return m, nil
}

func (m *_BACnetConstructedDataLastCredentialRemovedTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataLastCredentialRemovedTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLastCredentialRemovedTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLastCredentialRemovedTime")
		}

		if err := WriteSimpleField[BACnetDateTime](ctx, "lastCredentialRemovedTime", m.GetLastCredentialRemovedTime(), WriteComplex[BACnetDateTime](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'lastCredentialRemovedTime' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLastCredentialRemovedTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLastCredentialRemovedTime")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLastCredentialRemovedTime) IsBACnetConstructedDataLastCredentialRemovedTime() {
}

func (m *_BACnetConstructedDataLastCredentialRemovedTime) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataLastCredentialRemovedTime) deepCopy() *_BACnetConstructedDataLastCredentialRemovedTime {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataLastCredentialRemovedTimeCopy := &_BACnetConstructedDataLastCredentialRemovedTime{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetDateTime](m.LastCredentialRemovedTime),
	}
	_BACnetConstructedDataLastCredentialRemovedTimeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataLastCredentialRemovedTimeCopy
}

func (m *_BACnetConstructedDataLastCredentialRemovedTime) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
