/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLastAccessPoint is the corresponding interface of BACnetConstructedDataLastAccessPoint
type BACnetConstructedDataLastAccessPoint interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetLastAccessPoint returns LastAccessPoint (property field)
	GetLastAccessPoint() BACnetDeviceObjectReference
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetDeviceObjectReference
	// IsBACnetConstructedDataLastAccessPoint is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataLastAccessPoint()
	// CreateBuilder creates a BACnetConstructedDataLastAccessPointBuilder
	CreateBACnetConstructedDataLastAccessPointBuilder() BACnetConstructedDataLastAccessPointBuilder
}

// _BACnetConstructedDataLastAccessPoint is the data-structure of this message
type _BACnetConstructedDataLastAccessPoint struct {
	BACnetConstructedDataContract
	LastAccessPoint BACnetDeviceObjectReference
}

var _ BACnetConstructedDataLastAccessPoint = (*_BACnetConstructedDataLastAccessPoint)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataLastAccessPoint)(nil)

// NewBACnetConstructedDataLastAccessPoint factory function for _BACnetConstructedDataLastAccessPoint
func NewBACnetConstructedDataLastAccessPoint(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, lastAccessPoint BACnetDeviceObjectReference, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLastAccessPoint {
	if lastAccessPoint == nil {
		panic("lastAccessPoint of type BACnetDeviceObjectReference for BACnetConstructedDataLastAccessPoint must not be nil")
	}
	_result := &_BACnetConstructedDataLastAccessPoint{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		LastAccessPoint:               lastAccessPoint,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataLastAccessPointBuilder is a builder for BACnetConstructedDataLastAccessPoint
type BACnetConstructedDataLastAccessPointBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(lastAccessPoint BACnetDeviceObjectReference) BACnetConstructedDataLastAccessPointBuilder
	// WithLastAccessPoint adds LastAccessPoint (property field)
	WithLastAccessPoint(BACnetDeviceObjectReference) BACnetConstructedDataLastAccessPointBuilder
	// WithLastAccessPointBuilder adds LastAccessPoint (property field) which is build by the builder
	WithLastAccessPointBuilder(func(BACnetDeviceObjectReferenceBuilder) BACnetDeviceObjectReferenceBuilder) BACnetConstructedDataLastAccessPointBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataLastAccessPoint or returns an error if something is wrong
	Build() (BACnetConstructedDataLastAccessPoint, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataLastAccessPoint
}

// NewBACnetConstructedDataLastAccessPointBuilder() creates a BACnetConstructedDataLastAccessPointBuilder
func NewBACnetConstructedDataLastAccessPointBuilder() BACnetConstructedDataLastAccessPointBuilder {
	return &_BACnetConstructedDataLastAccessPointBuilder{_BACnetConstructedDataLastAccessPoint: new(_BACnetConstructedDataLastAccessPoint)}
}

type _BACnetConstructedDataLastAccessPointBuilder struct {
	*_BACnetConstructedDataLastAccessPoint

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataLastAccessPointBuilder) = (*_BACnetConstructedDataLastAccessPointBuilder)(nil)

func (b *_BACnetConstructedDataLastAccessPointBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataLastAccessPoint
}

func (b *_BACnetConstructedDataLastAccessPointBuilder) WithMandatoryFields(lastAccessPoint BACnetDeviceObjectReference) BACnetConstructedDataLastAccessPointBuilder {
	return b.WithLastAccessPoint(lastAccessPoint)
}

func (b *_BACnetConstructedDataLastAccessPointBuilder) WithLastAccessPoint(lastAccessPoint BACnetDeviceObjectReference) BACnetConstructedDataLastAccessPointBuilder {
	b.LastAccessPoint = lastAccessPoint
	return b
}

func (b *_BACnetConstructedDataLastAccessPointBuilder) WithLastAccessPointBuilder(builderSupplier func(BACnetDeviceObjectReferenceBuilder) BACnetDeviceObjectReferenceBuilder) BACnetConstructedDataLastAccessPointBuilder {
	builder := builderSupplier(b.LastAccessPoint.CreateBACnetDeviceObjectReferenceBuilder())
	var err error
	b.LastAccessPoint, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetDeviceObjectReferenceBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataLastAccessPointBuilder) Build() (BACnetConstructedDataLastAccessPoint, error) {
	if b.LastAccessPoint == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'lastAccessPoint' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataLastAccessPoint.deepCopy(), nil
}

func (b *_BACnetConstructedDataLastAccessPointBuilder) MustBuild() BACnetConstructedDataLastAccessPoint {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataLastAccessPointBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataLastAccessPointBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataLastAccessPointBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataLastAccessPointBuilder().(*_BACnetConstructedDataLastAccessPointBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataLastAccessPointBuilder creates a BACnetConstructedDataLastAccessPointBuilder
func (b *_BACnetConstructedDataLastAccessPoint) CreateBACnetConstructedDataLastAccessPointBuilder() BACnetConstructedDataLastAccessPointBuilder {
	if b == nil {
		return NewBACnetConstructedDataLastAccessPointBuilder()
	}
	return &_BACnetConstructedDataLastAccessPointBuilder{_BACnetConstructedDataLastAccessPoint: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLastAccessPoint) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataLastAccessPoint) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_LAST_ACCESS_POINT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLastAccessPoint) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataLastAccessPoint) GetLastAccessPoint() BACnetDeviceObjectReference {
	return m.LastAccessPoint
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataLastAccessPoint) GetActualValue() BACnetDeviceObjectReference {
	ctx := context.Background()
	_ = ctx
	return CastBACnetDeviceObjectReference(m.GetLastAccessPoint())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLastAccessPoint(structType any) BACnetConstructedDataLastAccessPoint {
	if casted, ok := structType.(BACnetConstructedDataLastAccessPoint); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLastAccessPoint); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLastAccessPoint) GetTypeName() string {
	return "BACnetConstructedDataLastAccessPoint"
}

func (m *_BACnetConstructedDataLastAccessPoint) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (lastAccessPoint)
	lengthInBits += m.LastAccessPoint.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataLastAccessPoint) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataLastAccessPoint) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataLastAccessPoint BACnetConstructedDataLastAccessPoint, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLastAccessPoint"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLastAccessPoint")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	lastAccessPoint, err := ReadSimpleField[BACnetDeviceObjectReference](ctx, "lastAccessPoint", ReadComplex[BACnetDeviceObjectReference](BACnetDeviceObjectReferenceParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'lastAccessPoint' field"))
	}
	m.LastAccessPoint = lastAccessPoint

	actualValue, err := ReadVirtualField[BACnetDeviceObjectReference](ctx, "actualValue", (*BACnetDeviceObjectReference)(nil), lastAccessPoint)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLastAccessPoint"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLastAccessPoint")
	}

	return m, nil
}

func (m *_BACnetConstructedDataLastAccessPoint) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataLastAccessPoint) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLastAccessPoint"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLastAccessPoint")
		}

		if err := WriteSimpleField[BACnetDeviceObjectReference](ctx, "lastAccessPoint", m.GetLastAccessPoint(), WriteComplex[BACnetDeviceObjectReference](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'lastAccessPoint' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLastAccessPoint"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLastAccessPoint")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLastAccessPoint) IsBACnetConstructedDataLastAccessPoint() {}

func (m *_BACnetConstructedDataLastAccessPoint) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataLastAccessPoint) deepCopy() *_BACnetConstructedDataLastAccessPoint {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataLastAccessPointCopy := &_BACnetConstructedDataLastAccessPoint{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetDeviceObjectReference](m.LastAccessPoint),
	}
	_BACnetConstructedDataLastAccessPointCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataLastAccessPointCopy
}

func (m *_BACnetConstructedDataLastAccessPoint) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
