/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataDeadband is the corresponding interface of BACnetConstructedDataDeadband
type BACnetConstructedDataDeadband interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetDeadband returns Deadband (property field)
	GetDeadband() BACnetApplicationTagReal
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagReal
	// IsBACnetConstructedDataDeadband is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataDeadband()
	// CreateBuilder creates a BACnetConstructedDataDeadbandBuilder
	CreateBACnetConstructedDataDeadbandBuilder() BACnetConstructedDataDeadbandBuilder
}

// _BACnetConstructedDataDeadband is the data-structure of this message
type _BACnetConstructedDataDeadband struct {
	BACnetConstructedDataContract
	Deadband BACnetApplicationTagReal
}

var _ BACnetConstructedDataDeadband = (*_BACnetConstructedDataDeadband)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataDeadband)(nil)

// NewBACnetConstructedDataDeadband factory function for _BACnetConstructedDataDeadband
func NewBACnetConstructedDataDeadband(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, deadband BACnetApplicationTagReal, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataDeadband {
	if deadband == nil {
		panic("deadband of type BACnetApplicationTagReal for BACnetConstructedDataDeadband must not be nil")
	}
	_result := &_BACnetConstructedDataDeadband{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		Deadband:                      deadband,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataDeadbandBuilder is a builder for BACnetConstructedDataDeadband
type BACnetConstructedDataDeadbandBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(deadband BACnetApplicationTagReal) BACnetConstructedDataDeadbandBuilder
	// WithDeadband adds Deadband (property field)
	WithDeadband(BACnetApplicationTagReal) BACnetConstructedDataDeadbandBuilder
	// WithDeadbandBuilder adds Deadband (property field) which is build by the builder
	WithDeadbandBuilder(func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataDeadbandBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataDeadband or returns an error if something is wrong
	Build() (BACnetConstructedDataDeadband, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataDeadband
}

// NewBACnetConstructedDataDeadbandBuilder() creates a BACnetConstructedDataDeadbandBuilder
func NewBACnetConstructedDataDeadbandBuilder() BACnetConstructedDataDeadbandBuilder {
	return &_BACnetConstructedDataDeadbandBuilder{_BACnetConstructedDataDeadband: new(_BACnetConstructedDataDeadband)}
}

type _BACnetConstructedDataDeadbandBuilder struct {
	*_BACnetConstructedDataDeadband

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataDeadbandBuilder) = (*_BACnetConstructedDataDeadbandBuilder)(nil)

func (b *_BACnetConstructedDataDeadbandBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataDeadband
}

func (b *_BACnetConstructedDataDeadbandBuilder) WithMandatoryFields(deadband BACnetApplicationTagReal) BACnetConstructedDataDeadbandBuilder {
	return b.WithDeadband(deadband)
}

func (b *_BACnetConstructedDataDeadbandBuilder) WithDeadband(deadband BACnetApplicationTagReal) BACnetConstructedDataDeadbandBuilder {
	b.Deadband = deadband
	return b
}

func (b *_BACnetConstructedDataDeadbandBuilder) WithDeadbandBuilder(builderSupplier func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataDeadbandBuilder {
	builder := builderSupplier(b.Deadband.CreateBACnetApplicationTagRealBuilder())
	var err error
	b.Deadband, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagRealBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataDeadbandBuilder) Build() (BACnetConstructedDataDeadband, error) {
	if b.Deadband == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'deadband' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataDeadband.deepCopy(), nil
}

func (b *_BACnetConstructedDataDeadbandBuilder) MustBuild() BACnetConstructedDataDeadband {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataDeadbandBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataDeadbandBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataDeadbandBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataDeadbandBuilder().(*_BACnetConstructedDataDeadbandBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataDeadbandBuilder creates a BACnetConstructedDataDeadbandBuilder
func (b *_BACnetConstructedDataDeadband) CreateBACnetConstructedDataDeadbandBuilder() BACnetConstructedDataDeadbandBuilder {
	if b == nil {
		return NewBACnetConstructedDataDeadbandBuilder()
	}
	return &_BACnetConstructedDataDeadbandBuilder{_BACnetConstructedDataDeadband: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataDeadband) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataDeadband) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_DEADBAND
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataDeadband) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataDeadband) GetDeadband() BACnetApplicationTagReal {
	return m.Deadband
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataDeadband) GetActualValue() BACnetApplicationTagReal {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagReal(m.GetDeadband())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataDeadband(structType any) BACnetConstructedDataDeadband {
	if casted, ok := structType.(BACnetConstructedDataDeadband); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataDeadband); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataDeadband) GetTypeName() string {
	return "BACnetConstructedDataDeadband"
}

func (m *_BACnetConstructedDataDeadband) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (deadband)
	lengthInBits += m.Deadband.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataDeadband) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataDeadband) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataDeadband BACnetConstructedDataDeadband, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataDeadband"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataDeadband")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	deadband, err := ReadSimpleField[BACnetApplicationTagReal](ctx, "deadband", ReadComplex[BACnetApplicationTagReal](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagReal](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deadband' field"))
	}
	m.Deadband = deadband

	actualValue, err := ReadVirtualField[BACnetApplicationTagReal](ctx, "actualValue", (*BACnetApplicationTagReal)(nil), deadband)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataDeadband"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataDeadband")
	}

	return m, nil
}

func (m *_BACnetConstructedDataDeadband) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataDeadband) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataDeadband"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataDeadband")
		}

		if err := WriteSimpleField[BACnetApplicationTagReal](ctx, "deadband", m.GetDeadband(), WriteComplex[BACnetApplicationTagReal](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'deadband' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataDeadband"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataDeadband")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataDeadband) IsBACnetConstructedDataDeadband() {}

func (m *_BACnetConstructedDataDeadband) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataDeadband) deepCopy() *_BACnetConstructedDataDeadband {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataDeadbandCopy := &_BACnetConstructedDataDeadband{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagReal](m.Deadband),
	}
	_BACnetConstructedDataDeadbandCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataDeadbandCopy
}

func (m *_BACnetConstructedDataDeadband) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
