/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package readwrite

import (
	"context"

	"github.com/pkg/errors"

	. "github.com/apache/plc4x/plc4go/protocols/bacnetip/readwrite/model"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

type BacnetipParserHelper struct {
}

func (m BacnetipParserHelper) Parse(typeName string, arguments []string, io utils.ReadBuffer) (any, error) {
	switch typeName {
	case "BACnetAuthenticationStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetAuthenticationStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLiftGroupModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetLiftGroupModeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetValueSource":
		return BACnetValueSourceParseWithBuffer[BACnetValueSource](context.Background(), io)
	case "NLMUpdateKeyUpdateKeyEntry":
		return NLMUpdateKeyUpdateKeyEntryParseWithBuffer(context.Background(), io)
	case "BACnetOpeningTag":
		tagNumberArgument, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetOpeningTagParseWithBuffer(context.Background(), io, tagNumberArgument)
	case "BACnetPriorityArray":
		objectTypeArgument, _ := BACnetObjectTypeByName(arguments[0])
		tagNumber, err := utils.StrToUint8(arguments[1])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		var arrayIndexArgument BACnetTagPayloadUnsignedInteger
		return BACnetPriorityArrayParseWithBuffer(context.Background(), io, objectTypeArgument, tagNumber, arrayIndexArgument)
	case "BACnetNameValue":
		return BACnetNameValueParseWithBuffer(context.Background(), io)
	case "SecurityResponseCodeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return SecurityResponseCodeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetPropertyReferenceEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetPropertyReferenceEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetSpecialEvent":
		return BACnetSpecialEventParseWithBuffer(context.Background(), io)
	case "BACnetRouterEntry":
		return BACnetRouterEntryParseWithBuffer(context.Background(), io)
	case "BACnetTagPayloadReal":
		return BACnetTagPayloadRealParseWithBuffer(context.Background(), io)
	case "BACnetFaultParameterFaultExtendedParameters":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetFaultParameterFaultExtendedParametersParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetNotificationParametersExtendedParameters":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetNotificationParametersExtendedParametersParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetLoggingTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetLoggingTypeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilter":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilterParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetTimeValue":
		return BACnetTimeValueParseWithBuffer(context.Background(), io)
	case "BACnetTagPayloadOctetString":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetTagPayloadOctetStringParseWithBuffer(context.Background(), io, actualLength)
	case "BACnetEscalatorOperationDirectionTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetEscalatorOperationDirectionTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "NPDUControl":
		return NPDUControlParseWithBuffer(context.Background(), io)
	case "BACnetFaultParameterFaultStateListOfFaultValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetFaultParameterFaultStateListOfFaultValuesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetTimeStampEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetTimeStampEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetTimerStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetTimerStateTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDateRangeEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetDateRangeEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetEventParameterChangeOfTimerAlarmValue":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetEventParameterChangeOfTimerAlarmValueParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetUnconfirmedServiceRequest":
		serviceRequestLength, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetUnconfirmedServiceRequestParseWithBuffer[BACnetUnconfirmedServiceRequest](context.Background(), io, serviceRequestLength)
	case "BACnetAddressEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetAddressEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetObjectTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetObjectTypeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDaysOfWeekTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetDaysOfWeekTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetReadAccessResultListOfResults":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		objectTypeArgument, _ := BACnetObjectTypeByName(arguments[1])
		return BACnetReadAccessResultListOfResultsParseWithBuffer(context.Background(), io, tagNumber, objectTypeArgument)
	case "BACnetRouterEntryStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetRouterEntryStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetAccessRuleTimeRangeSpecifierTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetAccessRuleTimeRangeSpecifierTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetObjectTypesSupportedTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetObjectTypesSupportedTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BVLCBroadcastDistributionTableEntry":
		return BVLCBroadcastDistributionTableEntryParseWithBuffer(context.Background(), io)
	case "BACnetBackupStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetBackupStateTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetEventParameterChangeOfLifeSavetyListOfLifeSavetyAlarmValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetEventParameterChangeOfLifeSavetyListOfLifeSavetyAlarmValuesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetDestination":
		return BACnetDestinationParseWithBuffer(context.Background(), io)
	case "BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecification":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetDeviceStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetDeviceStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetPrescale":
		return BACnetPrescaleParseWithBuffer(context.Background(), io)
	case "ErrorEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return ErrorEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetAuthenticationPolicyListEntry":
		return BACnetAuthenticationPolicyListEntryParseWithBuffer(context.Background(), io)
	case "APDU":
		apduLength, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return APDUParseWithBuffer[APDU](context.Background(), io, apduLength)
	case "BACnetEventNotificationSubscription":
		return BACnetEventNotificationSubscriptionParseWithBuffer(context.Background(), io)
	case "BACnetSegmentationTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetSegmentationTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetSecurityKeySet":
		return BACnetSecurityKeySetParseWithBuffer(context.Background(), io)
	case "BACnetNetworkSecurityPolicy":
		return BACnetNetworkSecurityPolicyParseWithBuffer(context.Background(), io)
	case "BACnetHostNPortEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetHostNPortEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetPropertyIdentifierTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetPropertyIdentifierTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetRecipientEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetRecipientEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetConfirmedServiceRequest":
		serviceRequestLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetConfirmedServiceRequestParseWithBuffer[BACnetConfirmedServiceRequest](context.Background(), io, serviceRequestLength)
	case "BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferences":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferencesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetTagPayloadUnsignedInteger":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetTagPayloadUnsignedIntegerParseWithBuffer(context.Background(), io, actualLength)
	case "BACnetAccessUserTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetAccessUserTypeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetRestartReasonTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetRestartReasonTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetTagPayloadBitString":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetTagPayloadBitStringParseWithBuffer(context.Background(), io, actualLength)
	case "BACnetClientCOV":
		return BACnetClientCOVParseWithBuffer[BACnetClientCOV](context.Background(), io)
	case "BACnetSetpointReference":
		return BACnetSetpointReferenceParseWithBuffer(context.Background(), io)
	case "BACnetObjectPropertyReferenceEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetObjectPropertyReferenceEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetEscalatorFaultTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetEscalatorFaultTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetEventStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetEventStateTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetTagHeader":
		return BACnetTagHeaderParseWithBuffer(context.Background(), io)
	case "BACnetTagPayloadBoolean":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetTagPayloadBooleanParseWithBuffer(context.Background(), io, actualLength)
	case "BACnetFaultTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetFaultTypeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "VTCloseErrorListOfVTSessionIdentifiers":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return VTCloseErrorListOfVTSessionIdentifiersParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecifications":
		return BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsParseWithBuffer(context.Background(), io)
	case "BACnetIPModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetIPModeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetAccumulatorRecord":
		return BACnetAccumulatorRecordParseWithBuffer(context.Background(), io)
	case "BACnetDailySchedule":
		return BACnetDailyScheduleParseWithBuffer(context.Background(), io)
	case "BACnetLogDataLogDataEntry":
		return BACnetLogDataLogDataEntryParseWithBuffer[BACnetLogDataLogDataEntry](context.Background(), io)
	case "BACnetOptionalBinaryPV":
		return BACnetOptionalBinaryPVParseWithBuffer[BACnetOptionalBinaryPV](context.Background(), io)
	case "BACnetBDTEntry":
		return BACnetBDTEntryParseWithBuffer(context.Background(), io)
	case "BACnetEngineeringUnitsTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetEngineeringUnitsTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "ListOfCovNotifications":
		return ListOfCovNotificationsParseWithBuffer(context.Background(), io)
	case "BACnetAssignedAccessRights":
		return BACnetAssignedAccessRightsParseWithBuffer(context.Background(), io)
	case "BACnetConfirmedServiceRequestCreateObjectObjectSpecifier":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetConfirmedServiceRequestCreateObjectObjectSpecifierParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetAuthenticationPolicy":
		return BACnetAuthenticationPolicyParseWithBuffer(context.Background(), io)
	case "BACnetPropertyAccessResult":
		return BACnetPropertyAccessResultParseWithBuffer(context.Background(), io)
	case "BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsListParseWithBuffer(context.Background(), io, tagNumber)
	case "NPDU":
		npduLength, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return NPDUParseWithBuffer(context.Background(), io, npduLength)
	case "BACnetProgramStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetProgramStateTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDoorSecuredStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetDoorSecuredStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "ErrorClassTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return ErrorClassTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetSpecialEventListOfTimeValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetSpecialEventListOfTimeValuesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetFaultParameterFaultOutOfRangeMaxNormalValue":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetFaultParameterFaultOutOfRangeMaxNormalValueParseWithBuffer[BACnetFaultParameterFaultOutOfRangeMaxNormalValue](context.Background(), io, tagNumber)
	case "BACnetAccessRuleLocationSpecifierTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetAccessRuleLocationSpecifierTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferencesEntry":
		return BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferencesEntryParseWithBuffer(context.Background(), io)
	case "BACnetAuthenticationFactorFormat":
		return BACnetAuthenticationFactorFormatParseWithBuffer(context.Background(), io)
	case "BACnetMaintenanceTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetMaintenanceTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetNotificationParametersChangeOfDiscreteValueNewValue":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetNotificationParametersChangeOfDiscreteValueNewValueParseWithBuffer[BACnetNotificationParametersChangeOfDiscreteValueNewValue](context.Background(), io, tagNumber)
	case "BACnetReadAccessPropertyReadResult":
		objectTypeArgument, _ := BACnetObjectTypeByName(arguments[0])
		propertyIdentifierArgument, _ := BACnetPropertyIdentifierByName(arguments[1])
		var arrayIndexArgument BACnetTagPayloadUnsignedInteger
		return BACnetReadAccessPropertyReadResultParseWithBuffer(context.Background(), io, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case "BACnetActionCommand":
		return BACnetActionCommandParseWithBuffer(context.Background(), io)
	case "BACnetFaultParameterFaultExtendedParametersEntry":
		return BACnetFaultParameterFaultExtendedParametersEntryParseWithBuffer[BACnetFaultParameterFaultExtendedParametersEntry](context.Background(), io)
	case "BACnetTagPayloadDate":
		return BACnetTagPayloadDateParseWithBuffer(context.Background(), io)
	case "BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetEventParameterExtendedParameters":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetEventParameterExtendedParametersParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetEventParameterAccessEventListOfAccessEvents":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetEventParameterAccessEventListOfAccessEventsParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetReadAccessProperty":
		objectTypeArgument, _ := BACnetObjectTypeByName(arguments[0])
		return BACnetReadAccessPropertyParseWithBuffer(context.Background(), io, objectTypeArgument)
	case "BACnetLifeSafetyOperationTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetLifeSafetyOperationTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetWeekNDayTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetWeekNDayTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetEventTransitionBitsTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetEventTransitionBitsTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLogData":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetLogDataParseWithBuffer[BACnetLogData](context.Background(), io, tagNumber)
	case "BACnetFaultParameterFaultCharacterStringListOfFaultValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetFaultParameterFaultCharacterStringListOfFaultValuesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetLockStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetLockStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDeviceObjectPropertyReferenceEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetDeviceObjectPropertyReferenceEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetPropertyStates":
		return BACnetPropertyStatesParseWithBuffer[BACnetPropertyStates](context.Background(), io)
	case "BACnetReadAccessResult":
		return BACnetReadAccessResultParseWithBuffer(context.Background(), io)
	case "BACnetResultFlagsTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetResultFlagsTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetAccessCredentialDisableReasonTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetAccessCredentialDisableReasonTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLightingInProgressTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetLightingInProgressTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLifeSafetyStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetLifeSafetyStateTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetVTSession":
		return BACnetVTSessionParseWithBuffer(context.Background(), io)
	case "BACnetEventTimestampsEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetEventTimestampsEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetSecurityLevelTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetSecurityLevelTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLogRecordLogDatum":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetLogRecordLogDatumParseWithBuffer[BACnetLogRecordLogDatum](context.Background(), io, tagNumber)
	case "BACnetDateTimeEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetDateTimeEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetTimerTransitionTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetTimerTransitionTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLogMultipleRecord":
		return BACnetLogMultipleRecordParseWithBuffer(context.Background(), io)
	case "BACnetProgramRequestTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetProgramRequestTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDateRange":
		return BACnetDateRangeParseWithBuffer(context.Background(), io)
	case "BACnetEventParameter":
		return BACnetEventParameterParseWithBuffer[BACnetEventParameter](context.Background(), io)
	case "BACnetLiftFaultTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetLiftFaultTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetPropertyStatesEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetPropertyStatesEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetGroupChannelValueList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetGroupChannelValueListParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetFileAccessMethodTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetFileAccessMethodTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetTagPayloadCharacterString":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetTagPayloadCharacterStringParseWithBuffer(context.Background(), io, actualLength)
	case "BACnetEventLogRecordLogDatum":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetEventLogRecordLogDatumParseWithBuffer[BACnetEventLogRecordLogDatum](context.Background(), io, tagNumber)
	case "BACnetStatusFlagsTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetStatusFlagsTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetNodeTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetNodeTypeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetOptionalCharacterString":
		return BACnetOptionalCharacterStringParseWithBuffer[BACnetOptionalCharacterString](context.Background(), io)
	case "BACnetAddress":
		return BACnetAddressParseWithBuffer(context.Background(), io)
	case "BACnetEventParameterChangeOfLifeSavetyListOfAlarmValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetEventParameterChangeOfLifeSavetyListOfAlarmValuesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsReference":
		return BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsReferenceParseWithBuffer(context.Background(), io)
	case "BACnetApplicationTag":
		return BACnetApplicationTagParseWithBuffer[BACnetApplicationTag](context.Background(), io)
	case "BACnetEventParameterChangeOfBitstringListOfBitstringValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetEventParameterChangeOfBitstringListOfBitstringValuesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetShedLevel":
		return BACnetShedLevelParseWithBuffer[BACnetShedLevel](context.Background(), io)
	case "BACnetActionTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetActionTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetCredentialAuthenticationFactor":
		return BACnetCredentialAuthenticationFactorParseWithBuffer(context.Background(), io)
	case "BACnetAssignedLandingCallsLandingCallsListEntry":
		return BACnetAssignedLandingCallsLandingCallsListEntryParseWithBuffer(context.Background(), io)
	case "BACnetPropertyValue":
		objectTypeArgument, _ := BACnetObjectTypeByName(arguments[0])
		return BACnetPropertyValueParseWithBuffer(context.Background(), io, objectTypeArgument)
	case "BACnetCOVSubscription":
		return BACnetCOVSubscriptionParseWithBuffer(context.Background(), io)
	case "BACnetFaultParameterFaultLifeSafetyListOfFaultValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetFaultParameterFaultLifeSafetyListOfFaultValuesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetRelationshipTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetRelationshipTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetRecipientProcessEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetRecipientProcessEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetAccessRule":
		return BACnetAccessRuleParseWithBuffer(context.Background(), io)
	case "BACnetHostNPort":
		return BACnetHostNPortParseWithBuffer(context.Background(), io)
	case "BACnetShedStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetShedStateTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetAccessEventTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetAccessEventTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetServiceAck":
		serviceAckLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetServiceAckParseWithBuffer[BACnetServiceAck](context.Background(), io, serviceAckLength)
	case "BACnetAccessCredentialDisableTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetAccessCredentialDisableTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLiftCarCallList":
		return BACnetLiftCarCallListParseWithBuffer(context.Background(), io)
	case "BACnetLightingTransitionTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetLightingTransitionTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "NLMUpdateKeyUpdateControlFlags":
		return NLMUpdateKeyUpdateControlFlagsParseWithBuffer(context.Background(), io)
	case "BACnetAssignedLandingCalls":
		return BACnetAssignedLandingCallsParseWithBuffer(context.Background(), io)
	case "BACnetNotifyTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetNotifyTypeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetAuthorizationExemptionTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetAuthorizationExemptionTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLandingDoorStatusLandingDoorsList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetLandingDoorStatusLandingDoorsListParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDeviceTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDeviceTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetAuthenticationFactorTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetAuthenticationFactorTypeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetAccessAuthenticationFactorDisableTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetAccessAuthenticationFactorDisableTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetAuthorizationModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetAuthorizationModeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestConfirmedTextMessageMessagePriorityTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetConfirmedServiceRequestConfirmedTextMessageMessagePriorityTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDoorStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetDoorStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetVendorIdTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetVendorIdTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetEventTimestamps":
		return BACnetEventTimestampsParseWithBuffer(context.Background(), io)
	case "BACnetNameValueCollection":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetNameValueCollectionParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetTagPayloadEnumerated":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetTagPayloadEnumeratedParseWithBuffer(context.Background(), io, actualLength)
	case "BACnetLimitEnableTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetLimitEnableTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDoorAlarmStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetDoorAlarmStateTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetServicesSupportedTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetServicesSupportedTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetWriteStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetWriteStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetRecipientProcess":
		return BACnetRecipientProcessParseWithBuffer(context.Background(), io)
	case "BACnetReadAccessSpecification":
		return BACnetReadAccessSpecificationParseWithBuffer(context.Background(), io)
	case "BACnetAuthenticationPolicyList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetAuthenticationPolicyListParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetLandingDoorStatus":
		return BACnetLandingDoorStatusParseWithBuffer(context.Background(), io)
	case "BACnetLiftCarCallListFloorList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetLiftCarCallListFloorListParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetAccessThreatLevel":
		return BACnetAccessThreatLevelParseWithBuffer(context.Background(), io)
	case "BACnetCalendarEntryEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetCalendarEntryEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetRecipient":
		return BACnetRecipientParseWithBuffer[BACnetRecipient](context.Background(), io)
	case "BACnetLiftCarDriveStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetLiftCarDriveStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetUnconfirmedServiceRequestWhoHasObject":
		return BACnetUnconfirmedServiceRequestWhoHasObjectParseWithBuffer[BACnetUnconfirmedServiceRequestWhoHasObject](context.Background(), io)
	case "BACnetTagPayloadSignedInteger":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetTagPayloadSignedIntegerParseWithBuffer(context.Background(), io, actualLength)
	case "BACnetSecurityPolicyTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetSecurityPolicyTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord":
		return BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecordParseWithBuffer[BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord](context.Background(), io)
	case "BVLC":
		return BVLCParseWithBuffer[BVLC](context.Background(), io)
	case "ConfirmedEventNotificationRequest":
		return ConfirmedEventNotificationRequestParseWithBuffer(context.Background(), io)
	case "BACnetLandingDoorStatusLandingDoorsListEntry":
		return BACnetLandingDoorStatusLandingDoorsListEntryParseWithBuffer(context.Background(), io)
	case "BACnetLiftCarDirectionTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetLiftCarDirectionTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestConfirmedTextMessageMessageClass":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetConfirmedServiceRequestConfirmedTextMessageMessageClassParseWithBuffer[BACnetConfirmedServiceRequestConfirmedTextMessageMessageClass](context.Background(), io, tagNumber)
	case "BACnetAddressBinding":
		return BACnetAddressBindingParseWithBuffer(context.Background(), io)
	case "BACnetLandingCallStatusCommand":
		return BACnetLandingCallStatusCommandParseWithBuffer[BACnetLandingCallStatusCommand](context.Background(), io)
	case "ListOfCovNotificationsValue":
		objectTypeArgument, _ := BACnetObjectTypeByName(arguments[0])
		return ListOfCovNotificationsValueParseWithBuffer(context.Background(), io, objectTypeArgument)
	case "BACnetLandingCallStatus":
		return BACnetLandingCallStatusParseWithBuffer(context.Background(), io)
	case "BACnetEventParameterChangeOfStateListOfValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetEventParameterChangeOfStateListOfValuesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetPortPermission":
		return BACnetPortPermissionParseWithBuffer(context.Background(), io)
	case "BACnetConfirmedServiceRequestReadRangeRange":
		return BACnetConfirmedServiceRequestReadRangeRangeParseWithBuffer[BACnetConfirmedServiceRequestReadRangeRange](context.Background(), io)
	case "BACnetError":
		errorChoice, _ := BACnetConfirmedServiceChoiceByName(arguments[0])
		return BACnetErrorParseWithBuffer[BACnetError](context.Background(), io, errorChoice)
	case "BACnetDeviceObjectReferenceEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetDeviceObjectReferenceEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetOptionalUnsigned":
		return BACnetOptionalUnsignedParseWithBuffer[BACnetOptionalUnsigned](context.Background(), io)
	case "BACnetHostAddress":
		return BACnetHostAddressParseWithBuffer[BACnetHostAddress](context.Background(), io)
	case "ListOfCovNotificationsList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return ListOfCovNotificationsListParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetEventSummariesList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetEventSummariesListParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetVTClassTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetVTClassTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDeviceObjectPropertyReference":
		return BACnetDeviceObjectPropertyReferenceParseWithBuffer(context.Background(), io)
	case "BACnetConfirmedServiceRequestDeviceCommunicationControlEnableDisableTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetConfirmedServiceRequestDeviceCommunicationControlEnableDisableTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetProcessIdSelection":
		return BACnetProcessIdSelectionParseWithBuffer[BACnetProcessIdSelection](context.Background(), io)
	case "BACnetAssignedLandingCallsLandingCallsList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetAssignedLandingCallsLandingCallsListParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetTagPayloadDouble":
		return BACnetTagPayloadDoubleParseWithBuffer(context.Background(), io)
	case "BACnetAccumulatorRecordAccumulatorStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetAccumulatorRecordAccumulatorStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetTimerStateChangeValue":
		objectTypeArgument, _ := BACnetObjectTypeByName(arguments[0])
		return BACnetTimerStateChangeValueParseWithBuffer[BACnetTimerStateChangeValue](context.Background(), io, objectTypeArgument)
	case "BACnetSpecialEventPeriod":
		return BACnetSpecialEventPeriodParseWithBuffer[BACnetSpecialEventPeriod](context.Background(), io)
	case "BACnetKeyIdentifier":
		return BACnetKeyIdentifierParseWithBuffer(context.Background(), io)
	case "BACnetNetworkNumberQualityTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetNetworkNumberQualityTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLogStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetLogStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetAbortReasonTagged":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetAbortReasonTaggedParseWithBuffer(context.Background(), io, actualLength)
	case "BACnetProgramErrorTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetProgramErrorTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "Error":
		return ErrorParseWithBuffer(context.Background(), io)
	case "BACnetPropertyReference":
		return BACnetPropertyReferenceParseWithBuffer(context.Background(), io)
	case "BACnetContextTag":
		tagNumberArgument, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		dataType, _ := BACnetDataTypeByName(arguments[1])
		return BACnetContextTagParseWithBuffer[BACnetContextTag](context.Background(), io, tagNumberArgument, dataType)
	case "BACnetUnconfirmedServiceChoiceTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetUnconfirmedServiceChoiceTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BVLCResultCodeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BVLCResultCodeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetFaultParameter":
		return BACnetFaultParameterParseWithBuffer[BACnetFaultParameter](context.Background(), io)
	case "BACnetEventParameterChangeOfValueCivCriteria":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetEventParameterChangeOfValueCivCriteriaParseWithBuffer[BACnetEventParameterChangeOfValueCivCriteria](context.Background(), io, tagNumber)
	case "BACnetPriorityValue":
		objectTypeArgument, _ := BACnetObjectTypeByName(arguments[0])
		return BACnetPriorityValueParseWithBuffer[BACnetPriorityValue](context.Background(), io, objectTypeArgument)
	case "BACnetLogRecord":
		return BACnetLogRecordParseWithBuffer(context.Background(), io)
	case "BACnetCalendarEntry":
		return BACnetCalendarEntryParseWithBuffer[BACnetCalendarEntry](context.Background(), io)
	case "BACnetAccessPassbackModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetAccessPassbackModeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDeviceObjectReference":
		return BACnetDeviceObjectReferenceParseWithBuffer(context.Background(), io)
	case "BVLCForeignDeviceTableEntry":
		return BVLCForeignDeviceTableEntryParseWithBuffer(context.Background(), io)
	case "NLM":
		apduLength, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return NLMParseWithBuffer[NLM](context.Background(), io, apduLength)
	case "BACnetWeekNDay":
		return BACnetWeekNDayParseWithBuffer(context.Background(), io)
	case "NLMInitializeRoutingTablePortMapping":
		return NLMInitializeRoutingTablePortMappingParseWithBuffer(context.Background(), io)
	case "NPDUNetworkPriorityTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return NPDUNetworkPriorityTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetReliabilityTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetReliabilityTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDoorValueTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetDoorValueTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetScale":
		return BACnetScaleParseWithBuffer[BACnetScale](context.Background(), io)
	case "BACnetNotificationParametersChangeOfValueNewValue":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetNotificationParametersChangeOfValueNewValueParseWithBuffer[BACnetNotificationParametersChangeOfValueNewValue](context.Background(), io, tagNumber)
	case "ErrorCodeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return ErrorCodeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BacnetConstants":
		return BacnetConstantsParseWithBuffer(context.Background(), io)
	case "BACnetPolarityTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetPolarityTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetServiceAckAtomicReadFileStreamOrRecord":
		return BACnetServiceAckAtomicReadFileStreamOrRecordParseWithBuffer[BACnetServiceAckAtomicReadFileStreamOrRecord](context.Background(), io)
	case "BACnetChannelValue":
		return BACnetChannelValueParseWithBuffer[BACnetChannelValue](context.Background(), io)
	case "BACnetConstructedData":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		objectTypeArgument, _ := BACnetObjectTypeByName(arguments[1])
		propertyIdentifierArgument, _ := BACnetPropertyIdentifierByName(arguments[2])
		var arrayIndexArgument BACnetTagPayloadUnsignedInteger
		return BACnetConstructedDataParseWithBuffer[BACnetConstructedData](context.Background(), io, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case "BACnetEventTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetEventTypeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetObjectPropertyReference":
		return BACnetObjectPropertyReferenceParseWithBuffer(context.Background(), io)
	case "BACnetBinaryLightingPVTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetBinaryLightingPVTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetOptionalREAL":
		return BACnetOptionalREALParseWithBuffer[BACnetOptionalREAL](context.Background(), io)
	case "BACnetTagPayloadTime":
		return BACnetTagPayloadTimeParseWithBuffer(context.Background(), io)
	case "BACnetAuthenticationFactorEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetAuthenticationFactorEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetEventSummary":
		return BACnetEventSummaryParseWithBuffer(context.Background(), io)
	case "BACnetAccessZoneOccupancyStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetAccessZoneOccupancyStateTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetPropertyAccessResultAccessResult":
		objectTypeArgument, _ := BACnetObjectTypeByName(arguments[0])
		propertyIdentifierArgument, _ := BACnetPropertyIdentifierByName(arguments[1])
		var propertyArrayIndexArgument BACnetTagPayloadUnsignedInteger
		return BACnetPropertyAccessResultAccessResultParseWithBuffer[BACnetPropertyAccessResultAccessResult](context.Background(), io, objectTypeArgument, propertyIdentifierArgument, propertyArrayIndexArgument)
	case "BACnetNetworkPortCommandTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetNetworkPortCommandTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetGroupChannelValue":
		return BACnetGroupChannelValueParseWithBuffer(context.Background(), io)
	case "BACnetRejectReasonTagged":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetRejectReasonTaggedParseWithBuffer(context.Background(), io, actualLength)
	case "BACnetEscalatorModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetEscalatorModeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetTagPayloadObjectIdentifier":
		return BACnetTagPayloadObjectIdentifierParseWithBuffer(context.Background(), io)
	case "BACnetPropertyWriteDefinition":
		objectTypeArgument, _ := BACnetObjectTypeByName(arguments[0])
		return BACnetPropertyWriteDefinitionParseWithBuffer(context.Background(), io, objectTypeArgument)
	case "BACnetEventLogRecord":
		return BACnetEventLogRecordParseWithBuffer(context.Background(), io)
	case "BACnetBinaryPVTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetBinaryPVTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetEventPriorities":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetEventPrioritiesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetDateTime":
		return BACnetDateTimeParseWithBuffer(context.Background(), io)
	case "BACnetLightingOperationTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetLightingOperationTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetFaultParameterFaultOutOfRangeMinNormalValue":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetFaultParameterFaultOutOfRangeMinNormalValueParseWithBuffer[BACnetFaultParameterFaultOutOfRangeMinNormalValue](context.Background(), io, tagNumber)
	case "BACnetEventParameterChangeOfCharacterStringListOfAlarmValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetEventParameterChangeOfCharacterStringListOfAlarmValuesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetSecurityKeySetKeyIds":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetSecurityKeySetKeyIdsParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetVMACEntry":
		return BACnetVMACEntryParseWithBuffer(context.Background(), io)
	case "BACnetTimeStamp":
		return BACnetTimeStampParseWithBuffer[BACnetTimeStamp](context.Background(), io)
	case "BACnetNotificationParameters":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		objectTypeArgument, _ := BACnetObjectTypeByName(arguments[1])
		return BACnetNotificationParametersParseWithBuffer[BACnetNotificationParameters](context.Background(), io, tagNumber, objectTypeArgument)
	case "BACnetClosingTag":
		tagNumberArgument, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetClosingTagParseWithBuffer(context.Background(), io, tagNumberArgument)
	case "BACnetTimeStampsEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetTimeStampsEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry":
		return BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryParseWithBuffer(context.Background(), io)
	case "BACnetHostAddressEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetHostAddressEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetNetworkTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetNetworkTypeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetConstructedDataElement":
		objectTypeArgument, _ := BACnetObjectTypeByName(arguments[0])
		propertyIdentifierArgument, _ := BACnetPropertyIdentifierByName(arguments[1])
		var arrayIndexArgument BACnetTagPayloadUnsignedInteger
		return BACnetConstructedDataElementParseWithBuffer(context.Background(), io, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case "BACnetPropertyValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		objectTypeArgument, _ := BACnetObjectTypeByName(arguments[1])
		return BACnetPropertyValuesParseWithBuffer(context.Background(), io, tagNumber, objectTypeArgument)
	case "BACnetProtocolLevelTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetProtocolLevelTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetCOVMultipleSubscription":
		return BACnetCOVMultipleSubscriptionParseWithBuffer(context.Background(), io)
	case "BACnetActionList":
		return BACnetActionListParseWithBuffer(context.Background(), io)
	case "BACnetLightingCommand":
		return BACnetLightingCommandParseWithBuffer(context.Background(), io)
	case "SubscribeCOVPropertyMultipleErrorFirstFailedSubscription":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return SubscribeCOVPropertyMultipleErrorFirstFailedSubscriptionParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetAuthenticationFactor":
		return BACnetAuthenticationFactorParseWithBuffer(context.Background(), io)
	case "BACnetWriteAccessSpecification":
		return BACnetWriteAccessSpecificationParseWithBuffer(context.Background(), io)
	case "BACnetLightingCommandEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return BACnetLightingCommandEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetLiftCarDoorCommandTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetLiftCarDoorCommandTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLiftCarModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetLiftCarModeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetSilencedStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetSilencedStateTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLifeSafetyModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := TagClassByName(arguments[1])
		return BACnetLifeSafetyModeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	}
	return nil, errors.Errorf("Unsupported type %s", typeName)
}
