/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SetTriggeringResponse extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 778;
  }

  // Properties.
  protected final ResponseHeader responseHeader;
  protected final List<StatusCode> addResults;
  protected final List<DiagnosticInfo> addDiagnosticInfos;
  protected final List<StatusCode> removeResults;
  protected final List<DiagnosticInfo> removeDiagnosticInfos;

  public SetTriggeringResponse(
      ResponseHeader responseHeader,
      List<StatusCode> addResults,
      List<DiagnosticInfo> addDiagnosticInfos,
      List<StatusCode> removeResults,
      List<DiagnosticInfo> removeDiagnosticInfos) {
    super();
    this.responseHeader = responseHeader;
    this.addResults = addResults;
    this.addDiagnosticInfos = addDiagnosticInfos;
    this.removeResults = removeResults;
    this.removeDiagnosticInfos = removeDiagnosticInfos;
  }

  public ResponseHeader getResponseHeader() {
    return responseHeader;
  }

  public List<StatusCode> getAddResults() {
    return addResults;
  }

  public List<DiagnosticInfo> getAddDiagnosticInfos() {
    return addDiagnosticInfos;
  }

  public List<StatusCode> getRemoveResults() {
    return removeResults;
  }

  public List<DiagnosticInfo> getRemoveDiagnosticInfos() {
    return removeDiagnosticInfos;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SetTriggeringResponse");

    // Simple Field (responseHeader)
    writeSimpleField("responseHeader", responseHeader, writeComplex(writeBuffer));

    // Implicit Field (noOfAddResults) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfAddResults = (int) ((((getAddResults()) == (null)) ? -(1) : COUNT(getAddResults())));
    writeImplicitField("noOfAddResults", noOfAddResults, writeSignedInt(writeBuffer, 32));

    // Array Field (addResults)
    writeComplexTypeArrayField("addResults", addResults, writeBuffer);

    // Implicit Field (noOfAddDiagnosticInfos) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfAddDiagnosticInfos =
        (int) ((((getAddDiagnosticInfos()) == (null)) ? -(1) : COUNT(getAddDiagnosticInfos())));
    writeImplicitField(
        "noOfAddDiagnosticInfos", noOfAddDiagnosticInfos, writeSignedInt(writeBuffer, 32));

    // Array Field (addDiagnosticInfos)
    writeComplexTypeArrayField("addDiagnosticInfos", addDiagnosticInfos, writeBuffer);

    // Implicit Field (noOfRemoveResults) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfRemoveResults =
        (int) ((((getRemoveResults()) == (null)) ? -(1) : COUNT(getRemoveResults())));
    writeImplicitField("noOfRemoveResults", noOfRemoveResults, writeSignedInt(writeBuffer, 32));

    // Array Field (removeResults)
    writeComplexTypeArrayField("removeResults", removeResults, writeBuffer);

    // Implicit Field (noOfRemoveDiagnosticInfos) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfRemoveDiagnosticInfos =
        (int)
            ((((getRemoveDiagnosticInfos()) == (null)) ? -(1) : COUNT(getRemoveDiagnosticInfos())));
    writeImplicitField(
        "noOfRemoveDiagnosticInfos", noOfRemoveDiagnosticInfos, writeSignedInt(writeBuffer, 32));

    // Array Field (removeDiagnosticInfos)
    writeComplexTypeArrayField("removeDiagnosticInfos", removeDiagnosticInfos, writeBuffer);

    writeBuffer.popContext("SetTriggeringResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SetTriggeringResponse _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (responseHeader)
    lengthInBits += responseHeader.getLengthInBits();

    // Implicit Field (noOfAddResults)
    lengthInBits += 32;

    // Array field
    if (addResults != null) {
      int i = 0;
      for (StatusCode element : addResults) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= addResults.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfAddDiagnosticInfos)
    lengthInBits += 32;

    // Array field
    if (addDiagnosticInfos != null) {
      int i = 0;
      for (DiagnosticInfo element : addDiagnosticInfos) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= addDiagnosticInfos.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfRemoveResults)
    lengthInBits += 32;

    // Array field
    if (removeResults != null) {
      int i = 0;
      for (StatusCode element : removeResults) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= removeResults.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfRemoveDiagnosticInfos)
    lengthInBits += 32;

    // Array field
    if (removeDiagnosticInfos != null) {
      int i = 0;
      for (DiagnosticInfo element : removeDiagnosticInfos) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= removeDiagnosticInfos.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("SetTriggeringResponse");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ResponseHeader responseHeader =
        readSimpleField(
            "responseHeader",
            readComplex(
                () ->
                    (ResponseHeader) ExtensionObjectDefinition.staticParse(readBuffer, (int) (394)),
                readBuffer));

    int noOfAddResults = readImplicitField("noOfAddResults", readSignedInt(readBuffer, 32));

    List<StatusCode> addResults =
        readCountArrayField(
            "addResults",
            readComplex(() -> StatusCode.staticParse(readBuffer), readBuffer),
            noOfAddResults);

    int noOfAddDiagnosticInfos =
        readImplicitField("noOfAddDiagnosticInfos", readSignedInt(readBuffer, 32));

    List<DiagnosticInfo> addDiagnosticInfos =
        readCountArrayField(
            "addDiagnosticInfos",
            readComplex(() -> DiagnosticInfo.staticParse(readBuffer), readBuffer),
            noOfAddDiagnosticInfos);

    int noOfRemoveResults = readImplicitField("noOfRemoveResults", readSignedInt(readBuffer, 32));

    List<StatusCode> removeResults =
        readCountArrayField(
            "removeResults",
            readComplex(() -> StatusCode.staticParse(readBuffer), readBuffer),
            noOfRemoveResults);

    int noOfRemoveDiagnosticInfos =
        readImplicitField("noOfRemoveDiagnosticInfos", readSignedInt(readBuffer, 32));

    List<DiagnosticInfo> removeDiagnosticInfos =
        readCountArrayField(
            "removeDiagnosticInfos",
            readComplex(() -> DiagnosticInfo.staticParse(readBuffer), readBuffer),
            noOfRemoveDiagnosticInfos);

    readBuffer.closeContext("SetTriggeringResponse");
    // Create the instance
    return new SetTriggeringResponseBuilderImpl(
        responseHeader, addResults, addDiagnosticInfos, removeResults, removeDiagnosticInfos);
  }

  public static class SetTriggeringResponseBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ResponseHeader responseHeader;
    private final List<StatusCode> addResults;
    private final List<DiagnosticInfo> addDiagnosticInfos;
    private final List<StatusCode> removeResults;
    private final List<DiagnosticInfo> removeDiagnosticInfos;

    public SetTriggeringResponseBuilderImpl(
        ResponseHeader responseHeader,
        List<StatusCode> addResults,
        List<DiagnosticInfo> addDiagnosticInfos,
        List<StatusCode> removeResults,
        List<DiagnosticInfo> removeDiagnosticInfos) {
      this.responseHeader = responseHeader;
      this.addResults = addResults;
      this.addDiagnosticInfos = addDiagnosticInfos;
      this.removeResults = removeResults;
      this.removeDiagnosticInfos = removeDiagnosticInfos;
    }

    public SetTriggeringResponse build() {
      SetTriggeringResponse setTriggeringResponse =
          new SetTriggeringResponse(
              responseHeader, addResults, addDiagnosticInfos, removeResults, removeDiagnosticInfos);
      return setTriggeringResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SetTriggeringResponse)) {
      return false;
    }
    SetTriggeringResponse that = (SetTriggeringResponse) o;
    return (getResponseHeader() == that.getResponseHeader())
        && (getAddResults() == that.getAddResults())
        && (getAddDiagnosticInfos() == that.getAddDiagnosticInfos())
        && (getRemoveResults() == that.getRemoveResults())
        && (getRemoveDiagnosticInfos() == that.getRemoveDiagnosticInfos())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getResponseHeader(),
        getAddResults(),
        getAddDiagnosticInfos(),
        getRemoveResults(),
        getRemoveDiagnosticInfos());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
