/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PubSubKeyPushTargetDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 25272;
  }

  // Properties.
  protected final PascalString applicationUri;
  protected final List<PascalString> pushTargetFolder;
  protected final PascalString endpointUrl;
  protected final PascalString securityPolicyUri;
  protected final UserTokenPolicy userTokenType;
  protected final int requestedKeyCount;
  protected final double retryInterval;
  protected final List<KeyValuePair> pushTargetProperties;
  protected final List<PascalString> securityGroups;

  public PubSubKeyPushTargetDataType(
      PascalString applicationUri,
      List<PascalString> pushTargetFolder,
      PascalString endpointUrl,
      PascalString securityPolicyUri,
      UserTokenPolicy userTokenType,
      int requestedKeyCount,
      double retryInterval,
      List<KeyValuePair> pushTargetProperties,
      List<PascalString> securityGroups) {
    super();
    this.applicationUri = applicationUri;
    this.pushTargetFolder = pushTargetFolder;
    this.endpointUrl = endpointUrl;
    this.securityPolicyUri = securityPolicyUri;
    this.userTokenType = userTokenType;
    this.requestedKeyCount = requestedKeyCount;
    this.retryInterval = retryInterval;
    this.pushTargetProperties = pushTargetProperties;
    this.securityGroups = securityGroups;
  }

  public PascalString getApplicationUri() {
    return applicationUri;
  }

  public List<PascalString> getPushTargetFolder() {
    return pushTargetFolder;
  }

  public PascalString getEndpointUrl() {
    return endpointUrl;
  }

  public PascalString getSecurityPolicyUri() {
    return securityPolicyUri;
  }

  public UserTokenPolicy getUserTokenType() {
    return userTokenType;
  }

  public int getRequestedKeyCount() {
    return requestedKeyCount;
  }

  public double getRetryInterval() {
    return retryInterval;
  }

  public List<KeyValuePair> getPushTargetProperties() {
    return pushTargetProperties;
  }

  public List<PascalString> getSecurityGroups() {
    return securityGroups;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PubSubKeyPushTargetDataType");

    // Simple Field (applicationUri)
    writeSimpleField("applicationUri", applicationUri, writeComplex(writeBuffer));

    // Implicit Field (noOfPushTargetFolder) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfPushTargetFolder =
        (int) ((((getPushTargetFolder()) == (null)) ? -(1) : COUNT(getPushTargetFolder())));
    writeImplicitField(
        "noOfPushTargetFolder", noOfPushTargetFolder, writeSignedInt(writeBuffer, 32));

    // Array Field (pushTargetFolder)
    writeComplexTypeArrayField("pushTargetFolder", pushTargetFolder, writeBuffer);

    // Simple Field (endpointUrl)
    writeSimpleField("endpointUrl", endpointUrl, writeComplex(writeBuffer));

    // Simple Field (securityPolicyUri)
    writeSimpleField("securityPolicyUri", securityPolicyUri, writeComplex(writeBuffer));

    // Simple Field (userTokenType)
    writeSimpleField("userTokenType", userTokenType, writeComplex(writeBuffer));

    // Simple Field (requestedKeyCount)
    writeSimpleField("requestedKeyCount", requestedKeyCount, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (retryInterval)
    writeSimpleField("retryInterval", retryInterval, writeDouble(writeBuffer, 64));

    // Implicit Field (noOfPushTargetProperties) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfPushTargetProperties =
        (int) ((((getPushTargetProperties()) == (null)) ? -(1) : COUNT(getPushTargetProperties())));
    writeImplicitField(
        "noOfPushTargetProperties", noOfPushTargetProperties, writeSignedInt(writeBuffer, 32));

    // Array Field (pushTargetProperties)
    writeComplexTypeArrayField("pushTargetProperties", pushTargetProperties, writeBuffer);

    // Implicit Field (noOfSecurityGroups) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfSecurityGroups =
        (int) ((((getSecurityGroups()) == (null)) ? -(1) : COUNT(getSecurityGroups())));
    writeImplicitField("noOfSecurityGroups", noOfSecurityGroups, writeSignedInt(writeBuffer, 32));

    // Array Field (securityGroups)
    writeComplexTypeArrayField("securityGroups", securityGroups, writeBuffer);

    writeBuffer.popContext("PubSubKeyPushTargetDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    PubSubKeyPushTargetDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (applicationUri)
    lengthInBits += applicationUri.getLengthInBits();

    // Implicit Field (noOfPushTargetFolder)
    lengthInBits += 32;

    // Array field
    if (pushTargetFolder != null) {
      int i = 0;
      for (PascalString element : pushTargetFolder) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= pushTargetFolder.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (endpointUrl)
    lengthInBits += endpointUrl.getLengthInBits();

    // Simple field (securityPolicyUri)
    lengthInBits += securityPolicyUri.getLengthInBits();

    // Simple field (userTokenType)
    lengthInBits += userTokenType.getLengthInBits();

    // Simple field (requestedKeyCount)
    lengthInBits += 16;

    // Simple field (retryInterval)
    lengthInBits += 64;

    // Implicit Field (noOfPushTargetProperties)
    lengthInBits += 32;

    // Array field
    if (pushTargetProperties != null) {
      int i = 0;
      for (KeyValuePair element : pushTargetProperties) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= pushTargetProperties.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfSecurityGroups)
    lengthInBits += 32;

    // Array field
    if (securityGroups != null) {
      int i = 0;
      for (PascalString element : securityGroups) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= securityGroups.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("PubSubKeyPushTargetDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString applicationUri =
        readSimpleField(
            "applicationUri", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfPushTargetFolder =
        readImplicitField("noOfPushTargetFolder", readSignedInt(readBuffer, 32));

    List<PascalString> pushTargetFolder =
        readCountArrayField(
            "pushTargetFolder",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer),
            noOfPushTargetFolder);

    PascalString endpointUrl =
        readSimpleField(
            "endpointUrl", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString securityPolicyUri =
        readSimpleField(
            "securityPolicyUri",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    UserTokenPolicy userTokenType =
        readSimpleField(
            "userTokenType",
            readComplex(
                () ->
                    (UserTokenPolicy)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (306)),
                readBuffer));

    int requestedKeyCount = readSimpleField("requestedKeyCount", readUnsignedInt(readBuffer, 16));

    double retryInterval = readSimpleField("retryInterval", readDouble(readBuffer, 64));

    int noOfPushTargetProperties =
        readImplicitField("noOfPushTargetProperties", readSignedInt(readBuffer, 32));

    List<KeyValuePair> pushTargetProperties =
        readCountArrayField(
            "pushTargetProperties",
            readComplex(
                () ->
                    (KeyValuePair) ExtensionObjectDefinition.staticParse(readBuffer, (int) (14535)),
                readBuffer),
            noOfPushTargetProperties);

    int noOfSecurityGroups = readImplicitField("noOfSecurityGroups", readSignedInt(readBuffer, 32));

    List<PascalString> securityGroups =
        readCountArrayField(
            "securityGroups",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer),
            noOfSecurityGroups);

    readBuffer.closeContext("PubSubKeyPushTargetDataType");
    // Create the instance
    return new PubSubKeyPushTargetDataTypeBuilderImpl(
        applicationUri,
        pushTargetFolder,
        endpointUrl,
        securityPolicyUri,
        userTokenType,
        requestedKeyCount,
        retryInterval,
        pushTargetProperties,
        securityGroups);
  }

  public static class PubSubKeyPushTargetDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString applicationUri;
    private final List<PascalString> pushTargetFolder;
    private final PascalString endpointUrl;
    private final PascalString securityPolicyUri;
    private final UserTokenPolicy userTokenType;
    private final int requestedKeyCount;
    private final double retryInterval;
    private final List<KeyValuePair> pushTargetProperties;
    private final List<PascalString> securityGroups;

    public PubSubKeyPushTargetDataTypeBuilderImpl(
        PascalString applicationUri,
        List<PascalString> pushTargetFolder,
        PascalString endpointUrl,
        PascalString securityPolicyUri,
        UserTokenPolicy userTokenType,
        int requestedKeyCount,
        double retryInterval,
        List<KeyValuePair> pushTargetProperties,
        List<PascalString> securityGroups) {
      this.applicationUri = applicationUri;
      this.pushTargetFolder = pushTargetFolder;
      this.endpointUrl = endpointUrl;
      this.securityPolicyUri = securityPolicyUri;
      this.userTokenType = userTokenType;
      this.requestedKeyCount = requestedKeyCount;
      this.retryInterval = retryInterval;
      this.pushTargetProperties = pushTargetProperties;
      this.securityGroups = securityGroups;
    }

    public PubSubKeyPushTargetDataType build() {
      PubSubKeyPushTargetDataType pubSubKeyPushTargetDataType =
          new PubSubKeyPushTargetDataType(
              applicationUri,
              pushTargetFolder,
              endpointUrl,
              securityPolicyUri,
              userTokenType,
              requestedKeyCount,
              retryInterval,
              pushTargetProperties,
              securityGroups);
      return pubSubKeyPushTargetDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PubSubKeyPushTargetDataType)) {
      return false;
    }
    PubSubKeyPushTargetDataType that = (PubSubKeyPushTargetDataType) o;
    return (getApplicationUri() == that.getApplicationUri())
        && (getPushTargetFolder() == that.getPushTargetFolder())
        && (getEndpointUrl() == that.getEndpointUrl())
        && (getSecurityPolicyUri() == that.getSecurityPolicyUri())
        && (getUserTokenType() == that.getUserTokenType())
        && (getRequestedKeyCount() == that.getRequestedKeyCount())
        && (getRetryInterval() == that.getRetryInterval())
        && (getPushTargetProperties() == that.getPushTargetProperties())
        && (getSecurityGroups() == that.getSecurityGroups())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getApplicationUri(),
        getPushTargetFolder(),
        getEndpointUrl(),
        getSecurityPolicyUri(),
        getUserTokenType(),
        getRequestedKeyCount(),
        getRetryInterval(),
        getPushTargetProperties(),
        getSecurityGroups());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
