/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class DataChangeFilter extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 724;
  }

  // Properties.
  protected final DataChangeTrigger trigger;
  protected final long deadbandType;
  protected final double deadbandValue;

  public DataChangeFilter(DataChangeTrigger trigger, long deadbandType, double deadbandValue) {
    super();
    this.trigger = trigger;
    this.deadbandType = deadbandType;
    this.deadbandValue = deadbandValue;
  }

  public DataChangeTrigger getTrigger() {
    return trigger;
  }

  public long getDeadbandType() {
    return deadbandType;
  }

  public double getDeadbandValue() {
    return deadbandValue;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("DataChangeFilter");

    // Simple Field (trigger)
    writeSimpleEnumField(
        "trigger",
        "DataChangeTrigger",
        trigger,
        writeEnum(
            DataChangeTrigger::getValue,
            DataChangeTrigger::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (deadbandType)
    writeSimpleField("deadbandType", deadbandType, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (deadbandValue)
    writeSimpleField("deadbandValue", deadbandValue, writeDouble(writeBuffer, 64));

    writeBuffer.popContext("DataChangeFilter");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    DataChangeFilter _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (trigger)
    lengthInBits += 32;

    // Simple field (deadbandType)
    lengthInBits += 32;

    // Simple field (deadbandValue)
    lengthInBits += 64;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("DataChangeFilter");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    DataChangeTrigger trigger =
        readEnumField(
            "trigger",
            "DataChangeTrigger",
            readEnum(DataChangeTrigger::enumForValue, readUnsignedLong(readBuffer, 32)));

    long deadbandType = readSimpleField("deadbandType", readUnsignedLong(readBuffer, 32));

    double deadbandValue = readSimpleField("deadbandValue", readDouble(readBuffer, 64));

    readBuffer.closeContext("DataChangeFilter");
    // Create the instance
    return new DataChangeFilterBuilderImpl(trigger, deadbandType, deadbandValue);
  }

  public static class DataChangeFilterBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final DataChangeTrigger trigger;
    private final long deadbandType;
    private final double deadbandValue;

    public DataChangeFilterBuilderImpl(
        DataChangeTrigger trigger, long deadbandType, double deadbandValue) {
      this.trigger = trigger;
      this.deadbandType = deadbandType;
      this.deadbandValue = deadbandValue;
    }

    public DataChangeFilter build() {
      DataChangeFilter dataChangeFilter =
          new DataChangeFilter(trigger, deadbandType, deadbandValue);
      return dataChangeFilter;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof DataChangeFilter)) {
      return false;
    }
    DataChangeFilter that = (DataChangeFilter) o;
    return (getTrigger() == that.getTrigger())
        && (getDeadbandType() == that.getDeadbandType())
        && (getDeadbandValue() == that.getDeadbandValue())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getTrigger(), getDeadbandType(), getDeadbandValue());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
