/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CreateMonitoredItemsRequest extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 751;
  }

  // Properties.
  protected final RequestHeader requestHeader;
  protected final long subscriptionId;
  protected final TimestampsToReturn timestampsToReturn;
  protected final List<MonitoredItemCreateRequest> itemsToCreate;

  public CreateMonitoredItemsRequest(
      RequestHeader requestHeader,
      long subscriptionId,
      TimestampsToReturn timestampsToReturn,
      List<MonitoredItemCreateRequest> itemsToCreate) {
    super();
    this.requestHeader = requestHeader;
    this.subscriptionId = subscriptionId;
    this.timestampsToReturn = timestampsToReturn;
    this.itemsToCreate = itemsToCreate;
  }

  public RequestHeader getRequestHeader() {
    return requestHeader;
  }

  public long getSubscriptionId() {
    return subscriptionId;
  }

  public TimestampsToReturn getTimestampsToReturn() {
    return timestampsToReturn;
  }

  public List<MonitoredItemCreateRequest> getItemsToCreate() {
    return itemsToCreate;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CreateMonitoredItemsRequest");

    // Simple Field (requestHeader)
    writeSimpleField("requestHeader", requestHeader, writeComplex(writeBuffer));

    // Simple Field (subscriptionId)
    writeSimpleField("subscriptionId", subscriptionId, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (timestampsToReturn)
    writeSimpleEnumField(
        "timestampsToReturn",
        "TimestampsToReturn",
        timestampsToReturn,
        writeEnum(
            TimestampsToReturn::getValue,
            TimestampsToReturn::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Implicit Field (noOfItemsToCreate) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfItemsToCreate =
        (int) ((((getItemsToCreate()) == (null)) ? -(1) : COUNT(getItemsToCreate())));
    writeImplicitField("noOfItemsToCreate", noOfItemsToCreate, writeSignedInt(writeBuffer, 32));

    // Array Field (itemsToCreate)
    writeComplexTypeArrayField("itemsToCreate", itemsToCreate, writeBuffer);

    writeBuffer.popContext("CreateMonitoredItemsRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    CreateMonitoredItemsRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (requestHeader)
    lengthInBits += requestHeader.getLengthInBits();

    // Simple field (subscriptionId)
    lengthInBits += 32;

    // Simple field (timestampsToReturn)
    lengthInBits += 32;

    // Implicit Field (noOfItemsToCreate)
    lengthInBits += 32;

    // Array field
    if (itemsToCreate != null) {
      int i = 0;
      for (MonitoredItemCreateRequest element : itemsToCreate) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= itemsToCreate.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("CreateMonitoredItemsRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    RequestHeader requestHeader =
        readSimpleField(
            "requestHeader",
            readComplex(
                () ->
                    (RequestHeader) ExtensionObjectDefinition.staticParse(readBuffer, (int) (391)),
                readBuffer));

    long subscriptionId = readSimpleField("subscriptionId", readUnsignedLong(readBuffer, 32));

    TimestampsToReturn timestampsToReturn =
        readEnumField(
            "timestampsToReturn",
            "TimestampsToReturn",
            readEnum(TimestampsToReturn::enumForValue, readUnsignedLong(readBuffer, 32)));

    int noOfItemsToCreate = readImplicitField("noOfItemsToCreate", readSignedInt(readBuffer, 32));

    List<MonitoredItemCreateRequest> itemsToCreate =
        readCountArrayField(
            "itemsToCreate",
            readComplex(
                () ->
                    (MonitoredItemCreateRequest)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (745)),
                readBuffer),
            noOfItemsToCreate);

    readBuffer.closeContext("CreateMonitoredItemsRequest");
    // Create the instance
    return new CreateMonitoredItemsRequestBuilderImpl(
        requestHeader, subscriptionId, timestampsToReturn, itemsToCreate);
  }

  public static class CreateMonitoredItemsRequestBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final RequestHeader requestHeader;
    private final long subscriptionId;
    private final TimestampsToReturn timestampsToReturn;
    private final List<MonitoredItemCreateRequest> itemsToCreate;

    public CreateMonitoredItemsRequestBuilderImpl(
        RequestHeader requestHeader,
        long subscriptionId,
        TimestampsToReturn timestampsToReturn,
        List<MonitoredItemCreateRequest> itemsToCreate) {
      this.requestHeader = requestHeader;
      this.subscriptionId = subscriptionId;
      this.timestampsToReturn = timestampsToReturn;
      this.itemsToCreate = itemsToCreate;
    }

    public CreateMonitoredItemsRequest build() {
      CreateMonitoredItemsRequest createMonitoredItemsRequest =
          new CreateMonitoredItemsRequest(
              requestHeader, subscriptionId, timestampsToReturn, itemsToCreate);
      return createMonitoredItemsRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CreateMonitoredItemsRequest)) {
      return false;
    }
    CreateMonitoredItemsRequest that = (CreateMonitoredItemsRequest) o;
    return (getRequestHeader() == that.getRequestHeader())
        && (getSubscriptionId() == that.getSubscriptionId())
        && (getTimestampsToReturn() == that.getTimestampsToReturn())
        && (getItemsToCreate() == that.getItemsToCreate())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getRequestHeader(),
        getSubscriptionId(),
        getTimestampsToReturn(),
        getItemsToCreate());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
