/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AggregateFilterResult extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 739;
  }

  // Properties.
  protected final long revisedStartTime;
  protected final double revisedProcessingInterval;
  protected final AggregateConfiguration revisedAggregateConfiguration;

  public AggregateFilterResult(
      long revisedStartTime,
      double revisedProcessingInterval,
      AggregateConfiguration revisedAggregateConfiguration) {
    super();
    this.revisedStartTime = revisedStartTime;
    this.revisedProcessingInterval = revisedProcessingInterval;
    this.revisedAggregateConfiguration = revisedAggregateConfiguration;
  }

  public long getRevisedStartTime() {
    return revisedStartTime;
  }

  public double getRevisedProcessingInterval() {
    return revisedProcessingInterval;
  }

  public AggregateConfiguration getRevisedAggregateConfiguration() {
    return revisedAggregateConfiguration;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("AggregateFilterResult");

    // Simple Field (revisedStartTime)
    writeSimpleField("revisedStartTime", revisedStartTime, writeSignedLong(writeBuffer, 64));

    // Simple Field (revisedProcessingInterval)
    writeSimpleField(
        "revisedProcessingInterval", revisedProcessingInterval, writeDouble(writeBuffer, 64));

    // Simple Field (revisedAggregateConfiguration)
    writeSimpleField(
        "revisedAggregateConfiguration", revisedAggregateConfiguration, writeComplex(writeBuffer));

    writeBuffer.popContext("AggregateFilterResult");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    AggregateFilterResult _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (revisedStartTime)
    lengthInBits += 64;

    // Simple field (revisedProcessingInterval)
    lengthInBits += 64;

    // Simple field (revisedAggregateConfiguration)
    lengthInBits += revisedAggregateConfiguration.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("AggregateFilterResult");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long revisedStartTime = readSimpleField("revisedStartTime", readSignedLong(readBuffer, 64));

    double revisedProcessingInterval =
        readSimpleField("revisedProcessingInterval", readDouble(readBuffer, 64));

    AggregateConfiguration revisedAggregateConfiguration =
        readSimpleField(
            "revisedAggregateConfiguration",
            readComplex(
                () ->
                    (AggregateConfiguration)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (950)),
                readBuffer));

    readBuffer.closeContext("AggregateFilterResult");
    // Create the instance
    return new AggregateFilterResultBuilderImpl(
        revisedStartTime, revisedProcessingInterval, revisedAggregateConfiguration);
  }

  public static class AggregateFilterResultBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final long revisedStartTime;
    private final double revisedProcessingInterval;
    private final AggregateConfiguration revisedAggregateConfiguration;

    public AggregateFilterResultBuilderImpl(
        long revisedStartTime,
        double revisedProcessingInterval,
        AggregateConfiguration revisedAggregateConfiguration) {
      this.revisedStartTime = revisedStartTime;
      this.revisedProcessingInterval = revisedProcessingInterval;
      this.revisedAggregateConfiguration = revisedAggregateConfiguration;
    }

    public AggregateFilterResult build() {
      AggregateFilterResult aggregateFilterResult =
          new AggregateFilterResult(
              revisedStartTime, revisedProcessingInterval, revisedAggregateConfiguration);
      return aggregateFilterResult;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AggregateFilterResult)) {
      return false;
    }
    AggregateFilterResult that = (AggregateFilterResult) o;
    return (getRevisedStartTime() == that.getRevisedStartTime())
        && (getRevisedProcessingInterval() == that.getRevisedProcessingInterval())
        && (getRevisedAggregateConfiguration() == that.getRevisedAggregateConfiguration())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getRevisedStartTime(),
        getRevisedProcessingInterval(),
        getRevisedAggregateConfiguration());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
