/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class IdentifyReplyCommandSummary extends IdentifyReplyCommand implements Message {

  // Accessors for discriminator values.
  public Attribute getAttribute() {
    return Attribute.Summary;
  }

  // Properties.
  protected final String partName;
  protected final byte unitServiceType;
  protected final String version;

  // Arguments.
  protected final Byte numBytes;

  public IdentifyReplyCommandSummary(
      String partName, byte unitServiceType, String version, Byte numBytes) {
    super(numBytes);
    this.partName = partName;
    this.unitServiceType = unitServiceType;
    this.version = version;
    this.numBytes = numBytes;
  }

  public String getPartName() {
    return partName;
  }

  public byte getUnitServiceType() {
    return unitServiceType;
  }

  public String getVersion() {
    return version;
  }

  @Override
  protected void serializeIdentifyReplyCommandChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("IdentifyReplyCommandSummary");

    // Simple Field (partName)
    writeSimpleField("partName", partName, writeString(writeBuffer, 48));

    // Simple Field (unitServiceType)
    writeSimpleField("unitServiceType", unitServiceType, writeByte(writeBuffer, 8));

    // Simple Field (version)
    writeSimpleField("version", version, writeString(writeBuffer, 32));

    writeBuffer.popContext("IdentifyReplyCommandSummary");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    IdentifyReplyCommandSummary _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (partName)
    lengthInBits += 48;

    // Simple field (unitServiceType)
    lengthInBits += 8;

    // Simple field (version)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static IdentifyReplyCommandBuilder staticParseIdentifyReplyCommandBuilder(
      ReadBuffer readBuffer, Attribute attribute, Byte numBytes) throws ParseException {
    readBuffer.pullContext("IdentifyReplyCommandSummary");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    String partName = readSimpleField("partName", readString(readBuffer, 48));

    byte unitServiceType = readSimpleField("unitServiceType", readByte(readBuffer, 8));

    String version = readSimpleField("version", readString(readBuffer, 32));

    readBuffer.closeContext("IdentifyReplyCommandSummary");
    // Create the instance
    return new IdentifyReplyCommandSummaryBuilderImpl(partName, unitServiceType, version, numBytes);
  }

  public static class IdentifyReplyCommandSummaryBuilderImpl
      implements IdentifyReplyCommand.IdentifyReplyCommandBuilder {
    private final String partName;
    private final byte unitServiceType;
    private final String version;
    private final Byte numBytes;

    public IdentifyReplyCommandSummaryBuilderImpl(
        String partName, byte unitServiceType, String version, Byte numBytes) {
      this.partName = partName;
      this.unitServiceType = unitServiceType;
      this.version = version;
      this.numBytes = numBytes;
    }

    public IdentifyReplyCommandSummary build(Byte numBytes) {

      IdentifyReplyCommandSummary identifyReplyCommandSummary =
          new IdentifyReplyCommandSummary(partName, unitServiceType, version, numBytes);
      return identifyReplyCommandSummary;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof IdentifyReplyCommandSummary)) {
      return false;
    }
    IdentifyReplyCommandSummary that = (IdentifyReplyCommandSummary) o;
    return (getPartName() == that.getPartName())
        && (getUnitServiceType() == that.getUnitServiceType())
        && (getVersion() == that.getVersion())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getPartName(), getUnitServiceType(), getVersion());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
