/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class NLMUpdateKeyUpdateKeyEntry implements Message {

  // Properties.
  protected final int keyIdentifier;
  protected final short keySize;
  protected final byte[] key;

  public NLMUpdateKeyUpdateKeyEntry(int keyIdentifier, short keySize, byte[] key) {
    super();
    this.keyIdentifier = keyIdentifier;
    this.keySize = keySize;
    this.key = key;
  }

  public int getKeyIdentifier() {
    return keyIdentifier;
  }

  public short getKeySize() {
    return keySize;
  }

  public byte[] getKey() {
    return key;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("NLMUpdateKeyUpdateKeyEntry");

    // Simple Field (keyIdentifier)
    writeSimpleField("keyIdentifier", keyIdentifier, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (keySize)
    writeSimpleField("keySize", keySize, writeUnsignedShort(writeBuffer, 8));

    // Array Field (key)
    writeByteArrayField("key", key, writeByteArray(writeBuffer, 8));

    writeBuffer.popContext("NLMUpdateKeyUpdateKeyEntry");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    NLMUpdateKeyUpdateKeyEntry _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (keyIdentifier)
    lengthInBits += 16;

    // Simple field (keySize)
    lengthInBits += 8;

    // Array field
    if (key != null) {
      lengthInBits += 8 * key.length;
    }

    return lengthInBits;
  }

  public static NLMUpdateKeyUpdateKeyEntry staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("NLMUpdateKeyUpdateKeyEntry");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int keyIdentifier = readSimpleField("keyIdentifier", readUnsignedInt(readBuffer, 16));

    short keySize = readSimpleField("keySize", readUnsignedShort(readBuffer, 8));

    byte[] key = readBuffer.readByteArray("key", Math.toIntExact(keySize));

    readBuffer.closeContext("NLMUpdateKeyUpdateKeyEntry");
    // Create the instance
    NLMUpdateKeyUpdateKeyEntry _nLMUpdateKeyUpdateKeyEntry;
    _nLMUpdateKeyUpdateKeyEntry = new NLMUpdateKeyUpdateKeyEntry(keyIdentifier, keySize, key);
    return _nLMUpdateKeyUpdateKeyEntry;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof NLMUpdateKeyUpdateKeyEntry)) {
      return false;
    }
    NLMUpdateKeyUpdateKeyEntry that = (NLMUpdateKeyUpdateKeyEntry) o;
    return (getKeyIdentifier() == that.getKeyIdentifier())
        && (getKeySize() == that.getKeySize())
        && (getKey() == that.getKey())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getKeyIdentifier(), getKeySize(), getKey());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
