/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class NLMChallengeRequest extends NLM implements Message {

  // Accessors for discriminator values.
  public Short getMessageType() {
    return (short) 0x0A;
  }

  // Properties.
  protected final byte messageChallenge;
  protected final long originalMessageId;
  protected final long originalTimestamp;

  // Arguments.
  protected final Integer apduLength;

  public NLMChallengeRequest(
      byte messageChallenge, long originalMessageId, long originalTimestamp, Integer apduLength) {
    super(apduLength);
    this.messageChallenge = messageChallenge;
    this.originalMessageId = originalMessageId;
    this.originalTimestamp = originalTimestamp;
    this.apduLength = apduLength;
  }

  public byte getMessageChallenge() {
    return messageChallenge;
  }

  public long getOriginalMessageId() {
    return originalMessageId;
  }

  public long getOriginalTimestamp() {
    return originalTimestamp;
  }

  @Override
  protected void serializeNLMChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("NLMChallengeRequest");

    // Simple Field (messageChallenge)
    writeSimpleField("messageChallenge", messageChallenge, writeByte(writeBuffer, 8));

    // Simple Field (originalMessageId)
    writeSimpleField("originalMessageId", originalMessageId, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (originalTimestamp)
    writeSimpleField("originalTimestamp", originalTimestamp, writeUnsignedLong(writeBuffer, 32));

    writeBuffer.popContext("NLMChallengeRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    NLMChallengeRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (messageChallenge)
    lengthInBits += 8;

    // Simple field (originalMessageId)
    lengthInBits += 32;

    // Simple field (originalTimestamp)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static NLMBuilder staticParseNLMBuilder(ReadBuffer readBuffer, Integer apduLength)
      throws ParseException {
    readBuffer.pullContext("NLMChallengeRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte messageChallenge = readSimpleField("messageChallenge", readByte(readBuffer, 8));

    long originalMessageId = readSimpleField("originalMessageId", readUnsignedLong(readBuffer, 32));

    long originalTimestamp = readSimpleField("originalTimestamp", readUnsignedLong(readBuffer, 32));

    readBuffer.closeContext("NLMChallengeRequest");
    // Create the instance
    return new NLMChallengeRequestBuilderImpl(
        messageChallenge, originalMessageId, originalTimestamp, apduLength);
  }

  public static class NLMChallengeRequestBuilderImpl implements NLM.NLMBuilder {
    private final byte messageChallenge;
    private final long originalMessageId;
    private final long originalTimestamp;
    private final Integer apduLength;

    public NLMChallengeRequestBuilderImpl(
        byte messageChallenge, long originalMessageId, long originalTimestamp, Integer apduLength) {
      this.messageChallenge = messageChallenge;
      this.originalMessageId = originalMessageId;
      this.originalTimestamp = originalTimestamp;
      this.apduLength = apduLength;
    }

    public NLMChallengeRequest build(Integer apduLength) {

      NLMChallengeRequest nLMChallengeRequest =
          new NLMChallengeRequest(
              messageChallenge, originalMessageId, originalTimestamp, apduLength);
      return nLMChallengeRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof NLMChallengeRequest)) {
      return false;
    }
    NLMChallengeRequest that = (NLMChallengeRequest) o;
    return (getMessageChallenge() == that.getMessageChallenge())
        && (getOriginalMessageId() == that.getOriginalMessageId())
        && (getOriginalTimestamp() == that.getOriginalTimestamp())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getMessageChallenge(), getOriginalMessageId(), getOriginalTimestamp());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
