/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble
    extends BACnetFaultParameterFaultOutOfRangeMinNormalValue implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final BACnetApplicationTagDouble doubleValue;

  // Arguments.
  protected final Short tagNumber;

  public BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble(
      BACnetOpeningTag openingTag,
      BACnetTagHeader peekedTagHeader,
      BACnetClosingTag closingTag,
      BACnetApplicationTagDouble doubleValue,
      Short tagNumber) {
    super(openingTag, peekedTagHeader, closingTag, tagNumber);
    this.doubleValue = doubleValue;
    this.tagNumber = tagNumber;
  }

  public BACnetApplicationTagDouble getDoubleValue() {
    return doubleValue;
  }

  @Override
  protected void serializeBACnetFaultParameterFaultOutOfRangeMinNormalValueChild(
      WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble");

    // Simple Field (doubleValue)
    writeSimpleField("doubleValue", doubleValue, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (doubleValue)
    lengthInBits += doubleValue.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetFaultParameterFaultOutOfRangeMinNormalValueBuilder
      staticParseBACnetFaultParameterFaultOutOfRangeMinNormalValueBuilder(
          ReadBuffer readBuffer, Short tagNumber) throws ParseException {
    readBuffer.pullContext("BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetApplicationTagDouble doubleValue =
        readSimpleField(
            "doubleValue",
            readComplex(
                () -> (BACnetApplicationTagDouble) BACnetApplicationTag.staticParse(readBuffer),
                readBuffer));

    readBuffer.closeContext("BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble");
    // Create the instance
    return new BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilderImpl(
        doubleValue, tagNumber);
  }

  public static class BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilderImpl
      implements BACnetFaultParameterFaultOutOfRangeMinNormalValue
          .BACnetFaultParameterFaultOutOfRangeMinNormalValueBuilder {
    private final BACnetApplicationTagDouble doubleValue;
    private final Short tagNumber;

    public BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilderImpl(
        BACnetApplicationTagDouble doubleValue, Short tagNumber) {
      this.doubleValue = doubleValue;
      this.tagNumber = tagNumber;
    }

    public BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble build(
        BACnetOpeningTag openingTag,
        BACnetTagHeader peekedTagHeader,
        BACnetClosingTag closingTag,
        Short tagNumber) {
      BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble
          bACnetFaultParameterFaultOutOfRangeMinNormalValueDouble =
              new BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble(
                  openingTag, peekedTagHeader, closingTag, doubleValue, tagNumber);
      return bACnetFaultParameterFaultOutOfRangeMinNormalValueDouble;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble)) {
      return false;
    }
    BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble that =
        (BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble) o;
    return (getDoubleValue() == that.getDoubleValue()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getDoubleValue());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
