/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum BACnetAbortReason {
  OTHER((short) 0),
  BUFFER_OVERFLOW((short) 1),
  INVALID_APDU_IN_THIS_STATE((short) 2),
  PREEMPTED_BY_HIGHER_PRIORITY_TASK((short) 3),
  SEGMENTATION_NOT_SUPPORTED((short) 4),
  SECURITY_ERROR((short) 5),
  INSUFFICIENT_SECURITY((short) 6),
  WINDOW_SIZE_OUT_OF_RANGE((short) 7),
  APPLICATION_EXCEEDED_REPLY_TIME((short) 8),
  OUT_OF_RESOURCES((short) 9),
  TSM_TIMEOUT((short) 10),
  APDU_TOO_LONG((short) 11),
  VENDOR_PROPRIETARY_VALUE((short) 0xFF);
  private static final Map<Short, BACnetAbortReason> map;

  static {
    map = new HashMap<>();
    for (BACnetAbortReason value : BACnetAbortReason.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;

  BACnetAbortReason(short value) {
    this.value = value;
  }

  public short getValue() {
    return value;
  }

  public static BACnetAbortReason enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
